/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptDependenciesLibraryRootProviderKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptImplementationSwitcherKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00020\t`\f*\b\u0012\u0004\u0012\u00020\t0\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsProvider;", "()V", "getAdditionalProjectLibraries", "", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "getRootsToWatch", "Lcom/intellij/openapi/vfs/VirtualFile;", "filterValid", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "AbstractDependenciesLibrary", "KotlinScriptDependenciesLibrary", "ScriptSdk", "kotlin.base.scripting"})
public final class KotlinScriptDependenciesLibraryRootProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        Collection collection;
        if (KotlinScriptImplementationSwitcherKt.getScriptsAsEntities()) {
            return CollectionsKt.emptyList();
        }
        ScriptConfigurationManager manager = ScriptConfigurationManager.Companion.getInstance(project);
        LinkedHashSet<VirtualFile> classes2 = this.filterValid(manager.getAllScriptsDependenciesClassFiles());
        LinkedHashSet<VirtualFile> sources = this.filterValid(manager.getAllScriptDependenciesSources());
        LinkedHashSet<VirtualFile> sdkClasses = this.filterValid(manager.getAllScriptsSdkDependenciesClassFiles());
        LinkedHashSet<VirtualFile> sdkSources = this.filterValid(manager.getAllScriptSdkDependenciesSources());
        if (classes2.isEmpty() && sources.isEmpty() && sdkClasses.isEmpty() && sdkSources.isEmpty()) {
            collection = CollectionsKt.emptyList();
        } else {
            List list2;
            KotlinScriptDependenciesLibrary library2 = new KotlinScriptDependenciesLibrary((Collection<? extends VirtualFile>)classes2, (Collection<? extends VirtualFile>)sources);
            if (sdkClasses.isEmpty() && sdkSources.isEmpty()) {
                list2 = CollectionsKt.listOf((Object)((Object)library2));
            } else {
                AbstractDependenciesLibrary[] abstractDependenciesLibraryArray = new AbstractDependenciesLibrary[]{new ScriptSdk(manager.getFirstScriptsSdk(), (Collection<? extends VirtualFile>)sdkClasses, (Collection<? extends VirtualFile>)sdkSources), library2};
                list2 = CollectionsKt.listOf((Object[])abstractDependenciesLibraryArray);
            }
            collection = list2;
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedHashSet<VirtualFile> filterValid(Collection<? extends VirtualFile> $this$filterValid) {
        void var3_3;
        void $this$filterTo$iv;
        Iterable iterable = $this$filterValid;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VirtualFile p0 = (VirtualFile)element$iv;
            boolean bl = false;
            if (!p0.isValid()) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)var3_3;
    }

    @NotNull
    public Collection<VirtualFile> getRootsToWatch(@NotNull Project project) {
        return KotlinScriptImplementationSwitcherKt.getScriptsAsEntities() ? (Collection)CollectionsKt.emptyList() : (Collection)this.filterValid(ScriptConfigurationManager.Companion.allExtraRoots(project));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider$AbstractDependenciesLibrary;", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "Lcom/intellij/navigation/ItemPresentation;", "id", "", "classes", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sources", "(Ljava/lang/String;Ljava/util/Collection;Ljava/util/Collection;)V", "getClasses", "()Ljava/util/Collection;", "gradle", "", "getGradle", "()Z", "gradle$delegate", "Lkotlin/Lazy;", "getSources", "equals", "other", "", "getBinaryRoots", "getIcon", "Ljavax/swing/Icon;", "unused", "getSourceRoots", "hashCode", "", "kotlin.base.scripting"})
    public static abstract class AbstractDependenciesLibrary
    extends SyntheticLibrary
    implements ItemPresentation {
        @NotNull
        private final String id;
        @NotNull
        private final Collection<VirtualFile> classes;
        @NotNull
        private final Collection<VirtualFile> sources;
        @NotNull
        private final Lazy gradle$delegate;

        public AbstractDependenciesLibrary(@NotNull String id, @NotNull Collection<? extends VirtualFile> classes2, @NotNull Collection<? extends VirtualFile> sources) {
            super(id, null);
            this.id = id;
            this.classes = classes2;
            this.sources = sources;
            this.gradle$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ AbstractDependenciesLibrary this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return KotlinScriptDependenciesLibraryRootProviderKt.hasGradleDependency(this.this$0.getClasses());
                }
            }));
        }

        @NotNull
        public final Collection<VirtualFile> getClasses() {
            return this.classes;
        }

        @NotNull
        public final Collection<VirtualFile> getSources() {
            return this.sources;
        }

        protected final boolean getGradle() {
            Lazy lazy = this.gradle$delegate;
            return (Boolean)lazy.getValue();
        }

        @NotNull
        public Collection<VirtualFile> getBinaryRoots() {
            return this.classes;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            return this.sources;
        }

        @NotNull
        public Icon getIcon(boolean unused) {
            return this.getGradle() ? KotlinIcons.GRADLE_SCRIPT : KotlinIcons.SCRIPT;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptDependenciesLibraryRootProvider.AbstractDependenciesLibrary");
            AbstractDependenciesLibrary cfr_ignored_0 = (AbstractDependenciesLibrary)((Object)other);
            return Intrinsics.areEqual((Object)this.id, (Object)((AbstractDependenciesLibrary)((Object)other)).id) && Intrinsics.areEqual(this.classes, ((AbstractDependenciesLibrary)((Object)other)).classes) && Intrinsics.areEqual(this.sources, ((AbstractDependenciesLibrary)((Object)other)).sources);
        }

        public int hashCode() {
            return 31 * ((Object)this.classes).hashCode() + ((Object)this.sources).hashCode();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider$KotlinScriptDependenciesLibrary;", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider$AbstractDependenciesLibrary;", "classes", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sources", "(Ljava/util/Collection;Ljava/util/Collection;)V", "getPresentableText", "", "kotlin.base.scripting"})
    private static final class KotlinScriptDependenciesLibrary
    extends AbstractDependenciesLibrary {
        public KotlinScriptDependenciesLibrary(@NotNull Collection<? extends VirtualFile> classes2, @NotNull Collection<? extends VirtualFile> sources) {
            super("KotlinScriptDependenciesLibrary", classes2, sources);
        }

        @NotNull
        public String getPresentableText() {
            return this.getGradle() ? KotlinBaseScriptingBundle.message("script.name.gradle.script.dependencies", new Object[0]) : KotlinBaseScriptingBundle.message("script.name.kotlin.script.dependencies", new Object[0]);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider$ScriptSdk;", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/KotlinScriptDependenciesLibraryRootProvider$AbstractDependenciesLibrary;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "classes", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sources", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/Collection;Ljava/util/Collection;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getPresentableText", "", "kotlin.base.scripting"})
    private static final class ScriptSdk
    extends AbstractDependenciesLibrary {
        @Nullable
        private final Sdk sdk;

        public ScriptSdk(@Nullable Sdk sdk2, @NotNull Collection<? extends VirtualFile> classes2, @NotNull Collection<? extends VirtualFile> sources) {
            super("ScriptSdk", classes2, sources);
            this.sdk = sdk2;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @NotNull
        public String getPresentableText() {
            Object object;
            block8: {
                block9: {
                    block6: {
                        block7: {
                            if (!this.getGradle()) break block6;
                            object = this.sdk;
                            if (object == null) break block7;
                            Sdk it = object;
                            boolean bl = false;
                            Object[] objectArray = new Object[]{it.getName()};
                            String string2 = KotlinBaseScriptingBundle.message("script.name.gradle.script.sdk.dependencies.0", objectArray);
                            object = string2;
                            if (string2 != null) break block8;
                        }
                        object = KotlinBaseScriptingBundle.message("script.name.gradle.script.sdk.dependencies", new Object[0]);
                        break block8;
                    }
                    object = this.sdk;
                    if (object == null) break block9;
                    Sdk it = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it.getName()};
                    String string3 = KotlinBaseScriptingBundle.message("script.name.kotlin.script.sdk.dependencies.0", objectArray);
                    object = string3;
                    if (string3 != null) break block8;
                }
                object = KotlinBaseScriptingBundle.message("script.name.kotlin.script.sdk.dependencies", new Object[0]);
            }
            return object;
        }
    }
}

