/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.listener;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.DefaultScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangesNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultListener", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/DefaultScriptChangeListener;", "listeners", "", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "getListeners", "()Ljava/util/Collection;", "scriptChangesListenerDelayMillis", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "areListenersDisabled", "", "getListener", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateScriptDependenciesIfNeeded", "", "updateScriptDependenciesIfNeeded$kotlin_base_scripting", "kotlin.base.scripting"})
public final class ScriptChangesNotifier {
    @NotNull
    private final Project project;
    @NotNull
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelayMillis;
    @NotNull
    private final DefaultScriptChangeListener defaultListener;

    public ScriptChangesNotifier(@NotNull Project project) {
        this.project = project;
        this.scriptChangesListenerDelayMillis = 1400;
        KotlinPluginDisposable parentDisposable = KotlinPluginDisposable.Companion.getInstance(this.project);
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)parentDisposable);
        this.project.getMessageBus().connect((Disposable)parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                this.runScriptDependenciesUpdateIfNeeded(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    VirtualFile virtualFile = event.getNewFile();
                    if (virtualFile == null) break block0;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    this.runScriptDependenciesUpdateIfNeeded(it);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file2) {
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    this.updateScriptDependenciesIfNeeded$kotlin_base_scripting(file2);
                } else {
                    AppExecutorUtil.getAppExecutorService().submit(() -> 1.runScriptDependenciesUpdateIfNeeded$lambda$1(this, file2));
                }
            }

            private static final void runScriptDependenciesUpdateIfNeeded$lambda$1(ScriptChangesNotifier this$0, VirtualFile $file) {
                this$0.updateScriptDependenciesIfNeeded$kotlin_base_scripting($file);
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                block11: {
                    block10: {
                        VirtualFile virtualFile;
                        Document document = event.getDocument();
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block10;
                        VirtualFile it = virtualFile = object;
                        boolean bl = false;
                        object = it.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block11;
                    }
                    return;
                }
                VirtualFile file2 = object;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                if (fileEditorManager == null) {
                    return;
                }
                FileEditorManager editorManager = fileEditorManager;
                if (!ArraysKt.contains((Object[])editorManager.getOpenFiles(), (Object)file2)) {
                    return;
                }
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ScriptChangeListener scriptChangeListener = this.getListener(project, file2);
                    if (scriptChangeListener != null) {
                        scriptChangeListener.documentChanged(file2);
                    }
                } else {
                    scriptsQueue.cancelAllRequests();
                    if (!project.isDisposed()) {
                        scriptsQueue.addRequest(() -> 2.documentChanged$lambda$1(this, file2), scriptChangesListenerDelayMillis, true);
                    }
                }
            }

            private static final void documentChanged$lambda$1(ScriptChangesNotifier this$0, VirtualFile $file) {
                block0: {
                    ScriptChangeListener scriptChangeListener = this$0.getListener(this$0.project, $file);
                    if (scriptChangeListener == null) break block0;
                    scriptChangeListener.documentChanged($file);
                }
            }
        }, (Disposable)parentDisposable);
        ScriptChangeListener.Companion.getLISTENER().getExtensions((AreaInstance)this.project);
        this.defaultListener = new DefaultScriptChangeListener(this.project);
    }

    private final Collection<ScriptChangeListener> getListeners() {
        List list2;
        List $this$_get_listeners__u24lambda_u240 = list2 = (List)new ArrayList();
        boolean bl = false;
        $this$_get_listeners__u24lambda_u240.addAll(ScriptChangeListener.Companion.getLISTENER().getExtensions((AreaInstance)this.project));
        $this$_get_listeners__u24lambda_u240.add(this.defaultListener);
        return list2;
    }

    public final void updateScriptDependenciesIfNeeded$kotlin_base_scripting(@NotNull VirtualFile file2) {
        block0: {
            ScriptChangeListener scriptChangeListener = this.getListener(this.project, file2);
            if (scriptChangeListener == null) break block0;
            scriptChangeListener.editorActivated(file2);
        }
    }

    private final ScriptChangeListener getListener(Project project, VirtualFile file2) {
        Object v0;
        block2: {
            if (project.isDisposed() || this.areListenersDisabled()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.getListeners();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptChangeListener it = (ScriptChangeListener)element$iv;
                boolean bl = false;
                if (!it.isApplicable(file2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean areListenersDisabled() {
        boolean $i$f$isUnitTestMode = false;
        return ApplicationManager.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)ScriptUtilsKt.isScriptChangesNotifierDisabled(ApplicationManager.getApplication()), (Object)true);
    }
}

