/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.cache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.impl.BridgeDependenciesResolverKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotFile;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshotForFS;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J(\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationFileAttributeCache;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "areDependenciesValid", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "load", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshotForFS;", "virtualFile", "loadDependencies", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "save", "", "value", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "kotlin.base.scripting"})
public final class ScriptConfigurationFileAttributeCache
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    public ScriptConfigurationFileAttributeCache(@NotNull Project project) {
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        if (!isFirstLoad) {
            return false;
        }
        VirtualFile virtualFile = ktFile.getOriginalFile().getVirtualFile();
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = this.load(virtualFile);
        if (scriptConfigurationSnapshotForFS == null) {
            return false;
        }
        ScriptConfigurationSnapshotForFS fromFs = scriptConfigurationSnapshotForFS;
        context2.saveNewConfiguration(virtualFile, new ScriptConfigurationSnapshot(fromFs.getInputs(), fromFs.getReports(), new ScriptCompilationConfigurationWrapper.FromCompilationConfiguration(new KtFileScriptSource(ktFile, null, 2, null), ScriptCompilationKt.with(fromFs.getConfiguration(), (Function1<? super ScriptCompilationConfiguration.Builder, Unit>)((Function1)new Function1<ScriptCompilationConfiguration.Builder, Unit>(scriptDefinition){
            final /* synthetic */ ScriptDefinition $scriptDefinition;
            {
                this.$scriptDefinition = $scriptDefinition;
                super(1);
            }

            public final void invoke(@NotNull ScriptCompilationConfiguration.Builder $this$with) {
                $this$with.update(ScriptCompilationKt.getHostConfiguration($this$with), (Function1)new Function1<ScriptingHostConfiguration, ScriptingHostConfiguration>(this.$scriptDefinition){
                    final /* synthetic */ ScriptDefinition $scriptDefinition;
                    {
                        this.$scriptDefinition = $scriptDefinition;
                        super(1);
                    }

                    @Nullable
                    public final ScriptingHostConfiguration invoke(@Nullable ScriptingHostConfiguration it) {
                        return HostConfigurationKt.withDefaultsFrom(it, this.$scriptDefinition.getHostConfiguration());
                    }
                });
            }
        })))));
        return fromFs.getInputs().isUpToDate(ktFile.getProject(), virtualFile, ktFile);
    }

    private final ScriptConfigurationSnapshotForFS load(VirtualFile virtualFile) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS = ScriptConfigurationSnapshotFile.Companion.get(this.project, virtualFile);
        if (scriptConfigurationSnapshotForFS == null) {
            return null;
        }
        ScriptConfigurationSnapshotForFS configurationSnapshot = scriptConfigurationSnapshotForFS;
        ScriptUtilsKt.scriptingDebugLog(virtualFile, (Function0<String>)((Function0)new Function0<String>(configurationSnapshot){
            final /* synthetic */ ScriptConfigurationSnapshotForFS $configurationSnapshot;
            {
                this.$configurationSnapshot = $configurationSnapshot;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "configuration from fileAttributes = " + this.$configurationSnapshot;
            }
        }));
        ScriptCompilationConfiguration scriptCompilationConfiguration2 = configurationSnapshot.getConfiguration();
        if (scriptCompilationConfiguration2 == null) {
            return null;
        }
        ScriptCompilationConfiguration configuration2 = scriptCompilationConfiguration2;
        if (!this.areDependenciesValid(virtualFile, configuration2)) {
            this.save(virtualFile, null);
            return null;
        }
        return configurationSnapshot;
    }

    private final boolean areDependenciesValid(VirtualFile file2, ScriptCompilationConfiguration configuration2) {
        boolean bl;
        block5: {
            Iterable $this$all$iv = BridgeDependenciesResolverKt.toClassPathOrEmpty(configuration2.get(ScriptCompilationKt.getDependencies(ScriptCompilationConfiguration.Companion)));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    Path path2 = it.toPath();
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        bl2 = true;
                    } else {
                        ScriptUtilsKt.scriptingDebugLog(file2, (Function0<String>)((Function0)new Function0<String>(path2){
                            final /* synthetic */ Path $path;
                            {
                                this.$path = $path;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "classpath root saved to file attribute doesn't exist: " + ((Object)this.$path).toString();
                            }
                        }));
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void save(@NotNull VirtualFile file2, @Nullable ScriptConfigurationSnapshot value2) {
        ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS;
        ScriptConfigurationSnapshotFile.Companion companion = ScriptConfigurationSnapshotFile.Companion;
        Project project = this.project;
        VirtualFile virtualFile = file2;
        ScriptConfigurationSnapshot scriptConfigurationSnapshot = value2;
        if (scriptConfigurationSnapshot != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void it;
            ScriptConfigurationSnapshot scriptConfigurationSnapshot2 = scriptConfigurationSnapshot;
            VirtualFile virtualFile2 = virtualFile;
            Project project2 = project;
            ScriptConfigurationSnapshotFile.Companion companion2 = companion;
            boolean bl = false;
            Iterable iterable = it.getReports();
            CachedConfigurationInputs cachedConfigurationInputs = it.getInputs();
            boolean $i$f$filter = false;
            void var8_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ScriptDiagnostic report = (ScriptDiagnostic)element$iv$iv;
                boolean bl2 = false;
                if (!(report.getException() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = it.getConfiguration();
            ScriptCompilationConfiguration scriptCompilationConfiguration2 = scriptCompilationConfigurationWrapper != null ? scriptCompilationConfigurationWrapper.getConfiguration() : null;
            List list2 = (List)destination$iv$iv;
            CachedConfigurationInputs cachedConfigurationInputs2 = cachedConfigurationInputs;
            ScriptConfigurationSnapshotForFS scriptConfigurationSnapshotForFS2 = new ScriptConfigurationSnapshotForFS(cachedConfigurationInputs2, list2, scriptCompilationConfiguration2);
            companion = companion2;
            project = project2;
            virtualFile = virtualFile2;
            scriptConfigurationSnapshotForFS = scriptConfigurationSnapshotForFS2;
        } else {
            scriptConfigurationSnapshotForFS = null;
        }
        companion.set(project, virtualFile, scriptConfigurationSnapshotForFS);
    }
}

