/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0017\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptTrafficLightRendererContributor;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRendererContributor;", "()V", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "ScriptTrafficLightRenderer", "kotlin.base.scripting"})
public final class ScriptTrafficLightRendererContributor
implements TrafficLightRendererContributor {
    @RequiresBackgroundThread
    @Nullable
    public TrafficLightRenderer createRenderer(@NotNull Editor editor2, @Nullable PsiFile file2) {
        PsiFile $this$safeAs$iv = file2;
        boolean $i$f$safeAs = false;
        PsiFile psiFile2 = $this$safeAs$iv;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        boolean $i$f$runReadAction = false;
        boolean isScript = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(ktFile2){
            final /* synthetic */ KtFile $ktFile$inlined;
            {
                this.$ktFile$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(this.$ktFile$inlined.isScript());
            }
        });
        return isScript ? (TrafficLightRenderer)new ScriptTrafficLightRenderer(ktFile2.getProject(), editor2.getDocument(), ktFile2) : null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptTrafficLightRendererContributor$ScriptTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getDaemonCodeAnalyzerStatus", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "kotlin.base.scripting"})
    public static final class ScriptTrafficLightRenderer
    extends TrafficLightRenderer {
        @NotNull
        private final KtFile file;

        public ScriptTrafficLightRenderer(@NotNull Project project, @NotNull Document document, @NotNull KtFile file2) {
            super(project, document);
            this.file = file2;
        }

        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            ScriptConfigurationManager configurations = ScriptConfigurationManager.Companion.getServiceIfCreated(this.getProject());
            if (configurations == null) {
                status.reasonWhySuspended = KotlinBaseScriptingBundle.message("text.loading.kotlin.script.configuration", new Object[0]);
                status.errorAnalyzingFinished = false;
            } else if (!ScriptDefinitionsManager.Companion.getInstance(this.getProject()).isReady()) {
                status.reasonWhySuspended = KotlinBaseScriptingBundle.message("text.loading.kotlin.script.definitions", new Object[0]);
                status.errorAnalyzingFinished = false;
            } else if (configurations.isConfigurationLoadingInProgress(this.file)) {
                status.reasonWhySuspended = KotlinBaseScriptingBundle.message("text.loading.kotlin.script.configuration", new Object[0]);
                status.errorAnalyzingFinished = false;
            }
            return status;
        }
    }
}

