/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.TypesWithOperatorDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/core/TypesWithGetValueDetector;", "Lorg/jetbrains/kotlin/idea/core/TypesWithOperatorDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "propertyOwnerType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "propertyType", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lorg/jetbrains/kotlin/idea/util/FuzzyType;Lorg/jetbrains/kotlin/idea/util/FuzzyType;)V", "checkIsSuitableByType", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "operator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "freeTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.base.fe10.analysis"})
public final class TypesWithGetValueDetector
extends TypesWithOperatorDetector {
    @NotNull
    private final FuzzyType propertyOwnerType;
    @Nullable
    private final FuzzyType propertyType;

    public TypesWithGetValueDetector(@NotNull LexicalScope scope2, @Nullable KotlinIndicesHelper indicesHelper2, @NotNull FuzzyType propertyOwnerType, @Nullable FuzzyType propertyType) {
        super(OperatorNameConventions.GET_VALUE, scope2, indicesHelper2);
        this.propertyOwnerType = propertyOwnerType;
        this.propertyType = propertyType;
    }

    @Override
    @Nullable
    protected TypeSubstitutor checkIsSuitableByType(@NotNull FunctionDescriptor operator, @NotNull Collection<? extends TypeParameterDescriptor> freeTypeParams) {
        FuzzyType paramType = FuzzyTypeUtils.toFuzzyType(((ValueParameterDescriptor)CollectionsKt.first((List)operator.getValueParameters())).getType(), freeTypeParams);
        TypeSubstitutor typeSubstitutor2 = paramType.checkIsSuperTypeOf(this.propertyOwnerType);
        if (typeSubstitutor2 == null) {
            return null;
        }
        TypeSubstitutor substitutor3 = typeSubstitutor2;
        if (this.propertyType == null) {
            return substitutor3;
        }
        Object object = operator.getReturnType();
        if (object == null || (object = FuzzyTypeUtils.toFuzzyType((KotlinType)object, freeTypeParams)) == null) {
            return null;
        }
        Object fuzzyReturnType = object;
        TypeSubstitutor typeSubstitutor3 = ((FuzzyType)fuzzyReturnType).checkIsSubtypeOf(this.propertyType);
        if (typeSubstitutor3 == null) {
            return null;
        }
        TypeSubstitutor substitutorFromPropertyType = typeSubstitutor3;
        return FuzzyTypeUtils.combineIfNoConflicts(substitutor3, substitutorFromPropertyType, freeTypeParams);
    }
}

