/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolderKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\rR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isSyncing", "", "()Z", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncDepth", "Ljava/util/concurrent/atomic/AtomicInteger;", "getAndCacheLanguageLevelByDependencies", "", "module", "Lcom/intellij/openapi/module/Module;", "performProjectPostOpenActions", "syncDone", "syncStarted", "Companion", "kotlin.project-configuration"})
public final class KotlinConfigurationCheckerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger syncDepth;
    @NotNull
    public static final String CONFIGURE_NOTIFICATION_GROUP_ID = "Configure Kotlin in Project";

    public KotlinConfigurationCheckerService(@NotNull Project project) {
        this.project = project;
        this.syncDepth = new AtomicInteger();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void performProjectPostOpenActions() {
        Project project = this.project;
        String string2 = KotlinProjectConfigurationBundle.message("configure.kotlin.language.settings", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(this, project, string2){
            final /* synthetic */ KotlinConfigurationCheckerService this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Collection<Module> ktModules;
                boolean $i$f$runReadAction = false;
                boolean kotlinLanguageVersionConfigured = (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ performProjectPostOpenActions.task.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)Boolean.valueOf(KotlinCommonCompilerArgumentsHolderKt.isKotlinLanguageVersionConfigured(this.this$0.getProject()));
                    }
                });
                if (kotlinLanguageVersionConfigured) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    KotlinJpsPluginSettings.Companion.validateSettings(this.getProject());
                    boolean $i$f$runReadAction22 = false;
                    Object[] $i$f$runReadAction22 = (Object[])ApplicationManager.getApplication().runReadAction(new Computable(this){
                        final /* synthetic */ performProjectPostOpenActions.task.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final T compute() {
                            boolean bl = false;
                            return (T)ProjectUtil.getModules((Project)this.this$0.getProject());
                        }
                    });
                    boolean $i$f$filter = false;
                    void var7_9 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        Object facetSettings;
                        Module it = (Module)element$iv$iv;
                        boolean bl = false;
                        Object object = KotlinFacet.Companion.get(it);
                        if (!(object == null || (object = (KotlinFacetConfiguration)object.getConfiguration()) == null || (object = object.getSettings()) == null ? false : !(facetSettings = object).getUseProjectSettings() && (facetSettings.getLanguageLevel() == null || facetSettings.getApiLevel() == null))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List modulesWithKotlinFacets = (List)destination$iv$iv;
                    if (modulesWithKotlinFacets.isEmpty()) {
                        return;
                    }
                    v1 = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(this.getProject(), modulesWithKotlinFacets);
                } else {
                    v1 = ktModules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles$default(this.getProject(), null, 2, null);
                }
                if (ktModules.isEmpty()) {
                    return;
                }
                if (!kotlinLanguageVersionConfigured) {
                    KotlinJpsPluginSettings.Companion.validateSettings(this.getProject());
                }
                indicator.setIndeterminate(false);
                Iterator<E> iterator = ktModules.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int idx = n++;
                    Module module2 = (Module)iterator.next();
                    indicator.checkCanceled();
                    if (this.getProject().isDisposed()) {
                        return;
                    }
                    indicator.setFraction(1.0 * (double)idx / (double)ktModules.size());
                    KotlinConfigurationCheckerService kotlinConfigurationCheckerService = this.this$0;
                    boolean $i$f$runReadAction2 = false;
                    ApplicationManager.getApplication().runReadAction(new Computable(module2, indicator, kotlinConfigurationCheckerService){
                        final /* synthetic */ Module $module$inlined;
                        final /* synthetic */ ProgressIndicator $indicator$inlined;
                        final /* synthetic */ KotlinConfigurationCheckerService this$0;
                        {
                            this.$module$inlined = module2;
                            this.$indicator$inlined = progressIndicator;
                            this.this$0 = kotlinConfigurationCheckerService;
                        }

                        public final T compute() {
                            boolean bl = false;
                            if (!this.$module$inlined.isDisposed()) {
                                Object[] objectArray = new Object[]{this.$module$inlined.getName()};
                                this.$indicator$inlined.setText2(KotlinProjectConfigurationBundle.message("configure.kotlin.language.settings.0.module", objectArray));
                                this.this$0.getAndCacheLanguageLevelByDependencies(this.$module$inlined);
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    @IntellijInternalApi
    @TestOnly
    public final void getAndCacheLanguageLevelByDependencies(@NotNull Module module2) {
        KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(this.project);
        if (kotlinFacetSettingsProvider == null || (kotlinFacetSettingsProvider = kotlinFacetSettingsProvider.getInitializedSettings(module2)) == null) {
            return;
        }
        KotlinFacetSettingsProvider facetSettings = kotlinFacetSettingsProvider;
        TargetPlatform targetPlatform = facetSettings.getTargetPlatform();
        LanguageVersion newLanguageLevel = KotlinVersionInfoProviderKt.getLibraryLanguageLevel$default(module2, null, (IdePlatformKind)(targetPlatform != null ? IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)targetPlatform) : null), false, 8, null);
        if (facetSettings.getUseProjectSettings()) {
            KotlinCommonCompilerArgumentsHolder kotlinCommonCompilerArgumentsHolder;
            KotlinCommonCompilerArgumentsHolder it = kotlinCommonCompilerArgumentsHolder = KotlinCommonCompilerArgumentsHolder.Companion.getInstance(this.project);
            boolean bl = false;
            KotlinCommonCompilerArgumentsHolder kotlinCommonCompilerArgumentsHolder2 = !KotlinCommonCompilerArgumentsHolderKt.isKotlinLanguageVersionConfigured(it) ? kotlinCommonCompilerArgumentsHolder : null;
            if (kotlinCommonCompilerArgumentsHolder2 != null) {
                kotlinCommonCompilerArgumentsHolder2.update((Function1)new Function1<CommonCompilerArguments, Unit>(newLanguageLevel){
                    final /* synthetic */ LanguageVersion $newLanguageLevel;
                    {
                        this.$newLanguageLevel = $newLanguageLevel;
                        super(1);
                    }

                    public final void invoke(@NotNull CommonCompilerArguments $this$update) {
                        if ($this$update.getLanguageVersion() == null) {
                            $this$update.setLanguageVersion(this.$newLanguageLevel.getVersionString());
                        }
                        if ($this$update.getApiVersion() == null) {
                            $this$update.setApiVersion(this.$newLanguageLevel.getVersionString());
                        }
                    }
                });
            }
        } else {
            KotlinFacetSettingsProvider $this$getAndCacheLanguageLevelByDependencies_u24lambda_u241 = facetSettings;
            boolean bl = false;
            if ($this$getAndCacheLanguageLevelByDependencies_u24lambda_u241.getLanguageLevel() == null) {
                $this$getAndCacheLanguageLevelByDependencies_u24lambda_u241.setLanguageLevel(newLanguageLevel);
            }
            if ($this$getAndCacheLanguageLevelByDependencies_u24lambda_u241.getApiLevel() == null) {
                $this$getAndCacheLanguageLevelByDependencies_u24lambda_u241.setApiLevel(newLanguageLevel);
            }
        }
    }

    public final boolean isSyncing() {
        return this.syncDepth.get() > 0;
    }

    public final void syncStarted() {
        this.syncDepth.incrementAndGet();
    }

    public final void syncDone() {
        this.syncDepth.decrementAndGet();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService$Companion;", "", "()V", "CONFIGURE_NOTIFICATION_GROUP_ID", "", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/ui/KotlinConfigurationCheckerService;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinConfigurationCheckerService getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinConfigurationCheckerService> serviceClass$iv = KotlinConfigurationCheckerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinConfigurationCheckerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

