/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.projectStructure.ExternalCompilerVersionProvider;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationBundle;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003\u001a\n\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002\u001a \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0016H\u0007\u001a\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0003H\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\u00a8\u0006\u001b"}, d2={"LAST_BUNDLED_KOTLIN_COMPILER_VERSION_PROPERTY_NAME", "", "campaignVersion", "Lkotlin/KotlinVersion;", "getCampaignVersion", "(Lkotlin/KotlinVersion;)Ljava/lang/String;", "dropHotfixPart", "getDropHotfixPart", "(Lkotlin/KotlinVersion;)Lkotlin/KotlinVersion;", "whatIsNewPageVersion", "getWhatIsNewPageVersion", "createWhatIsNewAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlinVersion", "disableNewKotlinCompilerAvailableNotification", "", "version", "findLastBundledCompilerVersion", "newExternalKotlinCompilerShouldBePromoted", "", "bundledCompilerVersion", "externalCompilerVersion", "Lkotlin/Function0;", "showNewKotlinCompilerAvailableNotificationIfNeeded", "project", "Lcom/intellij/openapi/project/Project;", "whatIsNewPageUrl", "kotlin.migration"})
public final class NewExternalKotlinCompilerNotificationKt {
    @VisibleForTesting
    @NotNull
    public static final String LAST_BUNDLED_KOTLIN_COMPILER_VERSION_PROPERTY_NAME = "kotlin.updates.whats.new.shown.for";

    public static final void showNewKotlinCompilerAvailableNotificationIfNeeded(@NotNull Project project) {
        IdeKotlinVersion bundledCompilerVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        if (!bundledCompilerVersion.isRelease()) {
            return;
        }
        Object[] objectArray = new Object[]{bundledCompilerVersion};
        ReadAction.nonBlocking(() -> NewExternalKotlinCompilerNotificationKt.showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0(project, bundledCompilerVersion)).inSmartMode(project).coalesceBy(objectArray).expireWith((Disposable)KotlinPluginDisposable.Companion.getInstance(project)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> NewExternalKotlinCompilerNotificationKt.showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$1((Function1)new Function1<KotlinVersion, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@Nullable KotlinVersion bundledKotlinVersion) {
                if (bundledKotlinVersion == null) {
                    return;
                }
                NewExternalKotlinCompilerNotificationKt.disableNewKotlinCompilerAvailableNotification(bundledKotlinVersion);
                Object[] objectArray = new Object[]{bundledKotlinVersion};
                NotificationGroupManager.getInstance().getNotificationGroup("kotlin.external.compiler.updates").createNotification(KotlinMigrationBundle.message("kotlin.external.compiler.updates.notification.content.0", objectArray), NotificationType.INFORMATION).setSuggestionType(true).addAction(NewExternalKotlinCompilerNotificationKt.access$createWhatIsNewAction(bundledKotlinVersion)).setIcon(KotlinIcons.SMALL_LOGO).setImportant(true).notify(this.$project);
            }
        }, arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    public static final void disableNewKotlinCompilerAvailableNotification(@NotNull KotlinVersion version2) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(version2){
            final /* synthetic */ KotlinVersion $version$inlined;
            {
                this.$version$inlined = kotlinVersion2;
            }

            public final T compute() {
                boolean bl = false;
                PropertiesComponent.getInstance().setValue("kotlin.updates.whats.new.shown.for", this.$version$inlined.toString());
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final KotlinVersion getDropHotfixPart(@NotNull KotlinVersion $this$dropHotfixPart) {
        void it;
        int n = $this$dropHotfixPart.getPatch() / 10;
        int n2 = $this$dropHotfixPart.getMinor();
        int n3 = $this$dropHotfixPart.getMajor();
        boolean bl = false;
        int n4 = it == true ? 0 : n;
        int n5 = n4 * 10;
        int n6 = n2;
        int n7 = n3;
        return new KotlinVersion(n7, n6, n5);
    }

    @VisibleForTesting
    public static final boolean newExternalKotlinCompilerShouldBePromoted(@NotNull KotlinVersion bundledCompilerVersion, @NotNull Function0<KotlinVersion> externalCompilerVersion) {
        KotlinVersion downgradedBundledKotlinCompilerVersion = NewExternalKotlinCompilerNotificationKt.getDropHotfixPart(bundledCompilerVersion);
        KotlinVersion lastBundledVersion = NewExternalKotlinCompilerNotificationKt.findLastBundledCompilerVersion();
        if (lastBundledVersion != null && lastBundledVersion.compareTo(downgradedBundledKotlinCompilerVersion) >= 0) {
            return false;
        }
        KotlinVersion kotlinVersion2 = (KotlinVersion)externalCompilerVersion.invoke();
        if (kotlinVersion2 == null) {
            return false;
        }
        KotlinVersion externalKotlinCompilerVersion = kotlinVersion2;
        return externalKotlinCompilerVersion.compareTo(downgradedBundledKotlinCompilerVersion) < 0;
    }

    private static final KotlinVersion findLastBundledCompilerVersion() {
        boolean $i$f$runReadAction = false;
        String string2 = (String)ApplicationManager.getApplication().runReadAction(new Computable(){

            public final T compute() {
                boolean bl = false;
                return (T)PropertiesComponent.getInstance().getValue("kotlin.updates.whats.new.shown.for");
            }
        });
        if (string2 == null) {
            return null;
        }
        String lastVersionValue = string2;
        IdeKotlinVersion ideKotlinVersion = IdeKotlinVersion.Companion.opt(lastVersionValue);
        return ideKotlinVersion != null ? ideKotlinVersion.getKotlinVersion() : null;
    }

    private static final AnAction createWhatIsNewAction(KotlinVersion kotlinVersion2) {
        return (AnAction)new BrowseNotificationAction(KotlinMigrationBundle.message("kotlin.external.compiler.updates.notification.learn.what.is.new.action", new Object[0]), NewExternalKotlinCompilerNotificationKt.whatIsNewPageUrl(kotlinVersion2));
    }

    private static final String whatIsNewPageUrl(KotlinVersion kotlinVersion2) {
        return "https://kotlinlang.org/docs/whatsnew" + NewExternalKotlinCompilerNotificationKt.getWhatIsNewPageVersion(kotlinVersion2) + ".html?utm_source=ide&utm_medium=release-notification&utm_campaign=" + NewExternalKotlinCompilerNotificationKt.getCampaignVersion(kotlinVersion2) + "-release";
    }

    @VisibleForTesting
    @NotNull
    public static final String getWhatIsNewPageVersion(@NotNull KotlinVersion $this$whatIsNewPageVersion) {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_whatIsNewPageVersion__u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_whatIsNewPageVersion__u24lambda_u245.append($this$whatIsNewPageVersion.getMajor());
        $this$_get_whatIsNewPageVersion__u24lambda_u245.append($this$whatIsNewPageVersion.getMinor());
        int majorPartOfPath = $this$whatIsNewPageVersion.getPatch() / 10;
        if (majorPartOfPath > 1) {
            $this$_get_whatIsNewPageVersion__u24lambda_u245.append(majorPartOfPath);
            $this$_get_whatIsNewPageVersion__u24lambda_u245.append('0');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @VisibleForTesting
    @NotNull
    public static final String getCampaignVersion(@NotNull KotlinVersion $this$campaignVersion) {
        return $this$campaignVersion.getMajor() + "-" + $this$campaignVersion.getMinor() + "-" + $this$campaignVersion.getPatch();
    }

    private static final KotlinVersion showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0$findExternalVersion(Project $project) {
        IdeKotlinVersion ideKotlinVersion = ExternalCompilerVersionProvider.INSTANCE.findLatest($project);
        if (ideKotlinVersion == null) {
            ideKotlinVersion = KotlinPluginLayout.getStandaloneCompilerVersion();
        }
        return ideKotlinVersion.getKotlinVersion();
    }

    private static final KotlinVersion showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0(Project $project, IdeKotlinVersion $bundledCompilerVersion) {
        if (!ProjectStructureUtils.containsNonScriptKotlinFile($project)) {
            return null;
        }
        KotlinVersion bundledKotlinVersion = $bundledCompilerVersion.getKotlinVersion();
        if (!NewExternalKotlinCompilerNotificationKt.newExternalKotlinCompilerShouldBePromoted(bundledKotlinVersion, (Function0<KotlinVersion>)((Function0)new Function0<KotlinVersion>($project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0, Intrinsics.Kotlin.class, "findExternalVersion", "showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0$findExternalVersion(Lcom/intellij/openapi/project/Project;)Lkotlin/KotlinVersion;", 0);
            }

            @NotNull
            public final KotlinVersion invoke() {
                return NewExternalKotlinCompilerNotificationKt.access$showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0$findExternalVersion(this.$project);
            }
        }))) {
            return null;
        }
        return bundledKotlinVersion;
    }

    private static final void showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ AnAction access$createWhatIsNewAction(KotlinVersion kotlinVersion2) {
        return NewExternalKotlinCompilerNotificationKt.createWhatIsNewAction(kotlinVersion2);
    }

    public static final /* synthetic */ KotlinVersion access$showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0$findExternalVersion(Project $project) {
        return NewExternalKotlinCompilerNotificationKt.showNewKotlinCompilerAvailableNotificationIfNeeded$lambda$0$findExternalVersion($project);
    }
}

