/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.notifications;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.configuration.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.configuration.notifications.SuppressKotlinCodeStyleComponent;
import org.jetbrains.kotlin.idea.configuration.notifications.SuppressKotlinCodeStyleState;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.migration.KotlinMigrationBundle;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\r\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\r\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"applyCodeStyleAction", "Lcom/intellij/notification/NotificationAction;", "Lorg/jetbrains/annotations/NotNull;", "applyKotlinCodeStyleSetting", "", "project", "Lcom/intellij/openapi/project/Project;", "dontAskAgainAction", "notifyKotlinStyleUpdateIfNeeded", "kotlin.migration"})
public final class NewCodeStyleNotificationKt {
    @ApiStatus.Internal
    public static final void notifyKotlinStyleUpdateIfNeeded(@NotNull Project project) {
        if (Intrinsics.areEqual((Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults(CodeStyle.getSettings((Project)project)), (Object)"KOTLIN_OFFICIAL")) {
            return;
        }
        if (((SuppressKotlinCodeStyleState)SuppressKotlinCodeStyleComponent.Companion.getInstance(project).getState()).getDisableForAll()) {
            return;
        }
        if (Intrinsics.areEqual((Object)project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT), (Object)Boolean.TRUE)) {
            NewCodeStyleNotificationKt.applyKotlinCodeStyleSetting(project);
            return;
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Update Kotlin code style").createNotification(KotlinMigrationBundle.message("configuration.kotlin.code.style", new Object[0]), KotlinMigrationBundle.htmlMessage("configuration.notification.update.code.style.to.official", new Object[0]), NotificationType.WARNING).setSuggestionType(true).addAction((AnAction)NewCodeStyleNotificationKt.applyCodeStyleAction()).addAction((AnAction)NewCodeStyleNotificationKt.dontAskAgainAction()).setImportant(true).setIcon(KotlinIcons.SMALL_LOGO).notify(project);
    }

    private static final NotificationAction dontAskAgainAction() {
        return NotificationAction.createExpiring((String)IdeCoreBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]), (arg_0, arg_1) -> NewCodeStyleNotificationKt.dontAskAgainAction$lambda$0(dontAskAgainAction.1.INSTANCE, arg_0, arg_1));
    }

    private static final NotificationAction applyCodeStyleAction() {
        return NotificationAction.createExpiring((String)KotlinMigrationBundle.message("configuration.apply.new.code.style", new Object[0]), (arg_0, arg_1) -> NewCodeStyleNotificationKt.applyCodeStyleAction$lambda$1(applyCodeStyleAction.1.INSTANCE, arg_0, arg_1));
    }

    private static final void applyKotlinCodeStyleSetting(Project project) {
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                ProjectCodeStyleImporter.INSTANCE.apply(this.$project$inlined, KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                return (T)Unit.INSTANCE;
            }
        });
    }

    private static final void dontAskAgainAction$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void applyCodeStyleAction$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$applyKotlinCodeStyleSetting(Project project) {
        NewCodeStyleNotificationKt.applyKotlinCodeStyleSetting(project);
    }
}

