/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinNotConfiguredSuppressedModulesState;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0005\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "kotlin.project-configuration"})
public final class KotlinSetupEnvironmentNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file2) {
        if (!FileUtils.isKotlinFileType(file2)) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file2);
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return null;
        }
        KtFile psiFile3 = ktFile;
        if (psiFile3.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile3));
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        if (!ModuleRootManager.getInstance((Module)module3).getFileIndex().isInSourceContent(file2)) {
            return null;
        }
        if (ModuleRootManager.getInstance((Module)module3).getSdk() == null && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile3))) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(project, (PsiFile)psiFile3);
        }
        KotlinConfigurationCheckerService configurationChecker = KotlinConfigurationCheckerService.Companion.getInstance(module3.getProject());
        if (!configurationChecker.isSyncing() && ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(ModuleSourceRootGroupUtils.toModuleGroup(module3)) && !ConfigureKotlinInProjectUtilsKt.hasAnyKotlinRuntimeInScope(module3) && !ConfigureKotlinInProjectUtilsKt.isStdlibModule(module3) && KotlinRuntimeLibraryUtilKt.getLibraryRootsWithIncompatibleAbi(module3).isEmpty()) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module3, CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module3)));
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ0\u0010\n\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J*\u0010\u0010\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "()V", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "createKotlinNotConfiguredPanel", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "module", "Lcom/intellij/openapi/module/Module;", "createSetupSdkPanel", "file", "Lcom/intellij/psi/PsiFile;", "apply", "", "kotlin.project-configuration"})
    public static final class Companion {
        private Companion() {
        }

        private final Function<? super FileEditor, ? extends JComponent> createSetupSdkPanel(Project project, PsiFile file2) {
            return arg_0 -> Companion.createSetupSdkPanel$lambda$3(project, file2, arg_0);
        }

        private final Function<? super FileEditor, ? extends JComponent> createKotlinNotConfiguredPanel(Module module2, List<? extends KotlinProjectConfigurator> configurators) {
            return arg_0 -> Companion.createKotlinNotConfiguredPanel$lambda$5(configurators, module2, arg_0);
        }

        private final void apply(KotlinProjectConfigurator $this$apply, Project project) {
            $this$apply.configure(project, CollectionsKt.emptyList());
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(project);
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators) {
            String string2 = KotlinProjectConfigurationBundle.message("title.choose.configurator", new Object[0]);
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(configurators, project, string2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super($super_call_param$1, $configurators);
                }

                @NotNull
                public String getTextFor(@Nullable KotlinProjectConfigurator value2) {
                    Object object = value2;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                @Nullable
                public PopupStep<?> onChosen(@Nullable KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> createConfiguratorsPopup.step.1.onChosen$lambda$0(selectedValue, this.$project));
                }

                private static final void onChosen$lambda$0(KotlinProjectConfigurator $selectedValue, Project $project) {
                    block0: {
                        KotlinProjectConfigurator kotlinProjectConfigurator = $selectedValue;
                        if (kotlinProjectConfigurator == null) break block0;
                        org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, kotlinProjectConfigurator, $project);
                    }
                }
            };
            return JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        }

        private static final void createSetupSdkPanel$lambda$3$lambda$2$lambda$1(Project $project, PsiFile $file) {
            if (ProjectSettingsService.getInstance((Project)$project).chooseAndSetSdk() == null) {
                return;
            }
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable($file){
                final /* synthetic */ PsiFile $file$inlined;
                {
                    this.$file$inlined = psiFile2;
                }

                public final T compute() {
                    boolean bl = false;
                    Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.$file$inlined));
                    if (module2 != null) {
                        ModuleRootModificationUtil.setSdkInherited((Module)module2);
                    }
                    return (T)Unit.INSTANCE;
                }
            });
        }

        private static final EditorNotificationPanel createSetupSdkPanel$lambda$3(Project $project, PsiFile $file, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            EditorNotificationPanel $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242.setText(JavaUiBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            $this$createSetupSdkPanel_u24lambda_u243_u24lambda_u242.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), () -> Companion.createSetupSdkPanel$lambda$3$lambda$2$lambda$1($project, $file));
            return editorNotificationPanel;
        }

        private static final EditorNotificationPanel createKotlinNotConfiguredPanel$lambda$5(List $configurators, Module $module, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            EditorNotificationPanel $this$createKotlinNotConfiguredPanel_u24lambda_u245_u24lambda_u244 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createKotlinNotConfiguredPanel_u24lambda_u245_u24lambda_u244.setText(KotlinProjectConfigurationBundle.message("kotlin.not.configured", new Object[0]));
            if (!((Collection)$configurators).isEmpty()) {
                Project project = $module.getProject();
                UiUtils.createComponentActionLabel($this$createKotlinNotConfiguredPanel_u24lambda_u245_u24lambda_u244, KotlinProjectConfigurationBundle.message("action.text.configure", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>((List<? extends KotlinProjectConfigurator>)$configurators, project){
                    final /* synthetic */ List<KotlinProjectConfigurator> $configurators;
                    final /* synthetic */ Project $project;
                    {
                        this.$configurators = $configurators;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkLabel label2) {
                        KotlinProjectConfigurator singleConfigurator = (KotlinProjectConfigurator)CollectionsKt.singleOrNull(this.$configurators);
                        if (singleConfigurator != null) {
                            org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, singleConfigurator, this.$project);
                        } else {
                            ListPopup configuratorsPopup = KotlinSetupEnvironmentNotificationProvider.Companion.createConfiguratorsPopup(this.$project, this.$configurators);
                            configuratorsPopup.showUnderneathOf((Component)label2);
                        }
                    }
                }));
                UiUtils.createComponentActionLabel($this$createKotlinNotConfiguredPanel_u24lambda_u245_u24lambda_u244, KotlinProjectConfigurationBundle.message("action.text.ignore", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)new Function1<HyperlinkLabel, Unit>($module, project){
                    final /* synthetic */ Module $module;
                    final /* synthetic */ Project $project;
                    {
                        this.$module = $module;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull HyperlinkLabel it) {
                        KotlinNotConfiguredSuppressedModulesState.Companion.suppressConfiguration$kotlin_project_configuration(this.$module);
                        EditorNotifications.getInstance((Project)this.$project).updateAllNotifications();
                    }
                }));
            }
            return editorNotificationPanel;
        }

        public static final /* synthetic */ void access$apply(Companion $this, KotlinProjectConfigurator $receiver, Project project) {
            $this.apply($receiver, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

