/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootMap;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkHideNonConfiguredNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.project-configuration"})
public final class ConfigureKotlinNotificationManagerKt {
    @NotNull
    private static final AtomicBoolean checkInProgress = new AtomicBoolean(false);
    @NotNull
    private static final Logger LOG = Logger.getInstance(ConfigureKotlinNotificationManager.class);

    public static final void checkHideNonConfiguredNotifications(@NotNull Project project) {
        if (checkInProgress.get()) {
            return;
        }
        ConfigureKotlinNotification configureKotlinNotification = (ConfigureKotlinNotification)((Object)ArraysKt.firstOrNull((Object[])ConfigureKotlinNotificationManager.INSTANCE.getVisibleNotifications(project)));
        if (configureKotlinNotification == null) {
            return;
        }
        ConfigureKotlinNotification notification2 = configureKotlinNotification;
        ApplicationManager.getApplication().executeOnPooledThread(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4(project, notification2));
    }

    private static final void checkHideNonConfiguredNotifications$lambda$4$lambda$2(Project $project) {
        ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications($project);
    }

    private static final void checkHideNonConfiguredNotifications$lambda$4$lambda$3(Project $project) {
        ConfigureKotlinNotificationManager.INSTANCE.expireOldNotifications($project);
        checkInProgress.set(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkHideNonConfiguredNotifications$lambda$4(Project $project, ConfigureKotlinNotification $notification) {
        boolean hideNotification;
        if (!checkInProgress.compareAndSet(false, true)) {
            return;
        }
        DumbService.getInstance((Project)$project).waitForSmartMode();
        ModuleSourceRootMap moduleSourceRootMap = new ModuleSourceRootMap($project);
        if (!Intrinsics.areEqual((Object)$notification.getNotificationState().getDebugProjectName(), (Object)$project.getName())) {
            LOG.error("Bad notification check for project: " + $project.getName() + "\n" + $notification.getNotificationState());
        }
        boolean $i$f$isUnitTestMode = false;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            boolean bl;
            try {
                boolean bl2;
                block13: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Iterable iterable = $notification.getNotificationState().getNotConfiguredModules();
                    boolean $i$f$mapNotNull = false;
                    Iterator iterator = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Module module2 = $this$forEach$iv$iv$iv.iterator();
                    while (module2.hasNext()) {
                        Module it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = module2.next();
                        boolean bl3 = false;
                        String it = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (ModuleManager.Companion.getInstance($project).findModuleByName(it) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        module2 = (Module)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl6 = false;
                        collection.add(moduleSourceRootMap.getWholeModuleGroup((Module)it));
                    }
                    List moduleSourceRootGroups = (List)destination$iv$iv;
                    Iterable $this$none$iv = moduleSourceRootGroups;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            ModuleSourceRootGroup p0 = (ModuleSourceRootGroup)element$iv;
                            boolean bl7 = false;
                            if (!ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(p0)) continue;
                            bl2 = false;
                            break block13;
                        }
                        bl2 = true;
                    }
                }
                bl = bl2;
            }
            catch (IndexNotReadyException e) {
                checkInProgress.set(false);
                ApplicationManager.getApplication().invokeLater(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4$lambda$2($project));
                return;
            }
            v1 = bl;
        } else {
            v1 = hideNotification = true;
        }
        if (hideNotification) {
            ApplicationManager.getApplication().invokeLater(() -> ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications$lambda$4$lambda$3($project));
        } else {
            checkInProgress.set(false);
        }
    }
}

