/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.handlers.KeywordConstructLookupObject;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.idea.formatter.DocumentUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u001a!\u0010\u0016\u001a\u0004\u0018\u00010\u000e*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001a\u001a\u001a\u0010\u001b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001a\u0010\u001c\u001a\u00020\b*\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u0012\u0010\u001e\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000e\u001a\u0012\u0010 \u001a\u00020\u000e*\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000e\u001a\u0014\u0010!\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006#"}, d2={"createKeywordConstructLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "project", "Lcom/intellij/openapi/project/Project;", "keyword", "", "fileTextToReformat", "trimSpacesAroundCaret", "", "adjustLineIndent", "detectIndent", "text", "", "offset", "", "removeRedundantBracesInStringTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "surroundWithBracesIfInStringTemplate", "indentLinesAfterFirst", "indent", "indexOfSkippingSpace", "c", "", "startIndex", "(Ljava/lang/CharSequence;CI)Ljava/lang/Integer;", "isCharAt", "isTextAt", "Lcom/intellij/openapi/editor/Document;", "skipSpaces", "index", "skipSpacesAndLineBreaks", "unindent", "withLineIndentAdjuster", "kotlin.completion.impl-shared"})
public final class HandlerUtilsKt {
    public static final boolean surroundWithBracesIfInStringTemplate(@NotNull InsertionContext context2) {
        int startOffset = context2.getStartOffset();
        Document document = context2.getDocument();
        if (startOffset > 0 && document.getCharsSequence().charAt(startOffset - 1) == '$') {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitDocument(document);
            PsiElement psiElement2 = context2.getFile().findElementAt(startOffset - 1);
            if (Intrinsics.areEqual((Object)(psiElement2 != null && (psiElement2 = psiElement2.getNode()) != null ? psiElement2.getElementType() : null), (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                document.insertString(startOffset, (CharSequence)"{");
                context2.getOffsetMap().addOffset(CompletionInitializationContext.START_OFFSET, startOffset + 1);
                int tailOffset = context2.getTailOffset();
                document.insertString(tailOffset, (CharSequence)"}");
                context2.setTailOffset(tailOffset);
                return true;
            }
        }
        return false;
    }

    public static final void removeRedundantBracesInStringTemplate(@NotNull InsertionContext context2) {
        Document document = context2.getDocument();
        int tailOffset = context2.getTailOffset();
        if (document.getCharsSequence().charAt(tailOffset) == '}') {
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(document);
            PsiElement token = context2.getFile().findElementAt(tailOffset);
            if (token != null && Intrinsics.areEqual((Object)token.getNode().getElementType(), (Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) {
                PsiElement psiElement2 = token.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry");
                KtBlockStringTemplateEntry entry = (KtBlockStringTemplateEntry)psiElement2;
                KtExpression ktExpression = entry.getExpression();
                KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression nameExpression2 = ktNameReferenceExpression;
                if (KtPsiUtilKt.canPlaceAfterSimpleNameEntry((PsiElement)entry.getNextSibling())) {
                    int n = context2.getTailOffset();
                    context2.setTailOffset(n + 1);
                    String name2 = nameExpression2.getReferencedName();
                    KtSimpleNameStringTemplateEntry newEntry = new KtPsiFactory((KtElement)entry, false, 2, null).createSimpleNameStringTemplateEntry(name2);
                    entry.replace((PsiElement)newEntry);
                }
            }
        }
    }

    @Nullable
    public static final Integer indexOfSkippingSpace(@NotNull CharSequence $this$indexOfSkippingSpace, char c, int startIndex) {
        int n = $this$indexOfSkippingSpace.length();
        for (int i2 = startIndex; i2 < n; ++i2) {
            char currentChar = $this$indexOfSkippingSpace.charAt(i2);
            if (c == currentChar) {
                return i2;
            }
            if (currentChar == ' ' || currentChar == '\t') continue;
            return null;
        }
        return null;
    }

    public static final int skipSpaces(@NotNull CharSequence $this$skipSpaces, int index) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)index, (int)$this$skipSpaces.length());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpaces.charAt(it);
                if (!(c != ' ' && c != '\t')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpaces.length();
    }

    public static final int skipSpacesAndLineBreaks(@NotNull CharSequence $this$skipSpacesAndLineBreaks, int index) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)index, (int)$this$skipSpacesAndLineBreaks.length());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                char c = $this$skipSpacesAndLineBreaks.charAt(it);
                if (!(c != ' ' && c != '\t' && c != '\n' && c != '\r')) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n.intValue() : $this$skipSpacesAndLineBreaks.length();
    }

    public static final boolean isCharAt(@NotNull CharSequence $this$isCharAt, int offset2, char c) {
        return offset2 < $this$isCharAt.length() && $this$isCharAt.charAt(offset2) == c;
    }

    public static final boolean isTextAt(@NotNull Document $this$isTextAt, int offset2, @NotNull String text2) {
        return offset2 + text2.length() <= $this$isTextAt.getTextLength() && Intrinsics.areEqual((Object)$this$isTextAt.getText(new TextRange(offset2, offset2 + text2.length())), (Object)text2);
    }

    @NotNull
    public static final LookupElement withLineIndentAdjuster(@NotNull LookupElement $this$withLineIndentAdjuster) {
        return (LookupElement)LookupElementDecorator.withDelegateInsertHandler((LookupElement)$this$withLineIndentAdjuster, HandlerUtilsKt::withLineIndentAdjuster$lambda$2);
    }

    @NotNull
    public static final LookupElement createKeywordConstructLookupElement(@NotNull Project project, @NotNull String keyword, @NotNull String fileTextToReformat, boolean trimSpacesAroundCaret, boolean adjustLineIndent) {
        boolean bl;
        boolean bl2;
        KtFile file2 = new KtPsiFactory(project, false, 2, null).createFile(fileTextToReformat);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
        String newFileText = file2.getText();
        int keywordOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)keyword, (int)0, (boolean)false, (int)6, null);
        boolean bl3 = bl2 = keywordOffset >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int keywordEndOffset = keywordOffset + keyword.length();
        String caretPlaceHolder = "caret";
        int caretOffset = StringsKt.indexOf$default((CharSequence)newFileText, (String)caretPlaceHolder, (int)0, (boolean)false, (int)6, null);
        boolean bl4 = bl = caretOffset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        boolean bl5 = bl = caretOffset >= keywordEndOffset;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        Ref.ObjectRef tailBeforeCaret = new Ref.ObjectRef();
        String string5 = newFileText.substring(keywordEndOffset, caretOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        tailBeforeCaret.element = string5;
        Ref.ObjectRef tailAfterCaret = new Ref.ObjectRef();
        String string6 = newFileText.substring(caretOffset + caretPlaceHolder.length());
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
        tailAfterCaret.element = string6;
        if (trimSpacesAroundCaret) {
            tailBeforeCaret.element = ((Object)StringsKt.trimEnd((CharSequence)((String)tailBeforeCaret.element))).toString();
            tailAfterCaret.element = ((Object)StringsKt.trimStart((CharSequence)((String)tailAfterCaret.element))).toString();
        }
        String indent = HandlerUtilsKt.detectIndent(newFileText, keywordOffset);
        tailBeforeCaret.element = HandlerUtilsKt.unindent((String)tailBeforeCaret.element, indent);
        tailAfterCaret.element = HandlerUtilsKt.unindent((String)tailAfterCaret.element, indent);
        String tailText = (StringsKt.contains$default((CharSequence)((CharSequence)tailBeforeCaret.element), (char)'\n', (boolean)false, (int)2, null) ? ((Object)StringsKt.trimEnd((CharSequence)StringsKt.replace$default((String)((String)tailBeforeCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null))).toString() : (String)tailBeforeCaret.element) + "..." + (StringsKt.contains$default((CharSequence)((CharSequence)tailAfterCaret.element), (char)'\n', (boolean)false, (int)2, null) ? ((Object)StringsKt.trimStart((CharSequence)StringsKt.replace$default((String)((String)tailAfterCaret.element), (String)"\n", (String)"", (boolean)false, (int)4, null))).toString() : (String)tailAfterCaret.element);
        KeywordConstructLookupObject lookupElement2 = new KeywordConstructLookupObject(keyword, fileTextToReformat);
        return (LookupElement)LookupElementBuilder.create((Object)lookupElement2, (String)keyword).bold().withTailText(tailText).withInsertHandler((arg_0, arg_1) -> HandlerUtilsKt.createKeywordConstructLookupElement$lambda$3(adjustLineIndent, keyword, tailBeforeCaret, tailAfterCaret, arg_0, arg_1));
    }

    public static /* synthetic */ LookupElement createKeywordConstructLookupElement$default(Project project, String string2, String string3, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return HandlerUtilsKt.createKeywordConstructLookupElement(project, string2, string3, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final String detectIndent(CharSequence text2, int offset2) {
        String string2;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = StringsKt.substringAfterLast$default((String)((Object)text2.subSequence(0, offset2)).toString(), (char)'\n', null, (int)2, null);
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char p0 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)p0)) continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string2 = var2_2;
        }
        return string2;
    }

    private static final String indentLinesAfterFirst(String $this$indentLinesAfterFirst, String indent) {
        StringBuilder stringBuilder;
        String text2 = $this$indentLinesAfterFirst;
        StringBuilder $this$indentLinesAfterFirst_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List lines = StringsKt.lines((CharSequence)text2);
        Iterator iterator = lines.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            if (index > 0) {
                $this$indentLinesAfterFirst_u24lambda_u244.append(indent);
            }
            $this$indentLinesAfterFirst_u24lambda_u244.append(line);
            if (index == CollectionsKt.getLastIndex((List)lines)) continue;
            $this$indentLinesAfterFirst_u24lambda_u244.append('\n');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final String unindent(String $this$unindent, String indent) {
        StringBuilder stringBuilder;
        String text2 = $this$unindent;
        StringBuilder $this$unindent_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List lines = StringsKt.lines((CharSequence)text2);
        Iterator iterator = lines.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            $this$unindent_u24lambda_u245.append(StringsKt.removePrefix((String)line, (CharSequence)indent));
            if (index == CollectionsKt.getLastIndex((List)lines)) continue;
            $this$unindent_u24lambda_u245.append('\n');
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private static final void withLineIndentAdjuster$lambda$2(InsertionContext context2, LookupElement item) {
        item.handleInsert(context2);
        DocumentUtilsKt.adjustLineIndent(context2.getDocument(), context2.getProject(), context2.getStartOffset());
    }

    private static final void createKeywordConstructLookupElement$lambda$3(boolean $adjustLineIndent, String $keyword, Ref.ObjectRef $tailBeforeCaret, Ref.ObjectRef $tailAfterCaret, InsertionContext insertionContext, LookupElement lookupElement2) {
        if (insertionContext.getCompletionChar() == '\n' || insertionContext.getCompletionChar() == '\t' || insertionContext.getCompletionChar() == '\u0000') {
            PsiElement sibling;
            int offset2;
            int n;
            if (!$adjustLineIndent) {
                n = insertionContext.getTailOffset() - $keyword.length();
            } else {
                offset2 = insertionContext.getTailOffset() - $keyword.length();
                DocumentUtilsKt.adjustLineIndent(insertionContext.getDocument(), insertionContext.getProject(), offset2);
                n = insertionContext.getTailOffset() - $keyword.length();
            }
            int keywordStartOffset = n;
            offset2 = keywordStartOffset + $keyword.length();
            String newIndent = HandlerUtilsKt.detectIndent(insertionContext.getDocument().getCharsSequence(), keywordStartOffset);
            String beforeCaret = HandlerUtilsKt.indentLinesAfterFirst((String)$tailBeforeCaret.element, newIndent);
            String afterCaret = HandlerUtilsKt.indentLinesAfterFirst((String)$tailAfterCaret.element, newIndent);
            PsiElement element3 = insertionContext.getFile().findElementAt(offset2);
            Object object = !(element3 instanceof PsiWhiteSpace) ? element3 : (sibling = ((PsiWhiteSpace)element3).textContains('\n') ? null : PsiUtilsKt.getNextSiblingIgnoringWhitespace((PsiElement)element3, (boolean)true));
            if (sibling != null && StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)beforeCaret)).toString(), (String)insertionContext.getDocument().getText(TextRange.from((int)PsiUtilsKt.getStartOffset((PsiElement)sibling), (int)1)), (boolean)false, (int)2, null)) {
                GenerateUtilsKt.moveCaret$default(insertionContext.getEditor(), PsiUtilsKt.getStartOffset((PsiElement)sibling) + 1, null, 2, null);
            } else {
                insertionContext.getDocument().insertString(offset2, (CharSequence)(beforeCaret + afterCaret));
                GenerateUtilsKt.moveCaret$default(insertionContext.getEditor(), offset2 + beforeCaret.length(), null, 2, null);
            }
        }
    }
}

