/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compilerPlugin.kotlinxSerialization.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/compilerPlugin/kotlinxSerialization/compiler/diagnostic/JsonFormatRedundantDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "jsonDefaultFqName", "Lorg/jetbrains/kotlin/name/FqName;", "jsonFqName", "parameterNameBuilderAction", "Lorg/jetbrains/kotlin/name/Name;", "parameterNameFrom", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "isDefaultFormat", "", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isDefaultFormatArgument", "arg", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "isEmptyFunctionArgument", "isJsonFormatCreation", "descriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "kotlin.compiler-plugins.kotlinx-serialization.common"})
public final class JsonFormatRedundantDiagnostic
implements CallChecker {
    @NotNull
    private final FqName jsonFqName = new FqName("kotlinx.serialization.json.Json");
    @NotNull
    private final FqName jsonDefaultFqName = new FqName("kotlinx.serialization.json.Json.Default");
    @NotNull
    private final Name parameterNameFrom = Name.identifier((String)"from");
    @NotNull
    private final Name parameterNameBuilderAction = Name.identifier((String)"builderAction");

    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor = callableDescriptor instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)callableDescriptor : null;
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor functionDescriptor2 = simpleFunctionDescriptor;
        BindingContext bindingContext2 = context2.getTrace().getBindingContext();
        if (this.isJsonFormatCreation(functionDescriptor2)) {
            if (this.isDefaultFormat(resolvedCall2, bindingContext2)) {
                context2.getTrace().report((Diagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT_DEFAULT.on((PsiElement)resolvedCall2.getCall().getCallElement()));
            }
            return;
        }
        KtExpression ktExpression = CallUtilKt.getReceiverExpression(resolvedCall2);
        if (ktExpression == null) {
            return;
        }
        KtExpression receiverExpression = ktExpression;
        ResolvedCall resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)((KtElement)receiverExpression), (BindingContext)bindingContext2);
        if (resolvedCall3 == null) {
            return;
        }
        ResolvedCall receiverResolvedCall = resolvedCall3;
        CallableDescriptor callableDescriptor2 = receiverResolvedCall.getResultingDescriptor();
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = callableDescriptor2 instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)callableDescriptor2 : null;
        if (simpleFunctionDescriptor2 == null) {
            return;
        }
        SimpleFunctionDescriptor receiverFunctionDescriptor = simpleFunctionDescriptor2;
        if (this.isJsonFormatCreation(receiverFunctionDescriptor) && !this.isDefaultFormat(receiverResolvedCall, bindingContext2)) {
            context2.getTrace().report((Diagnostic)SerializationErrors.JSON_FORMAT_REDUNDANT.on(receiverExpression.getOriginalElement()));
        }
    }

    private final boolean isJsonFormatCreation(SimpleFunctionDescriptor descriptor2) {
        return Intrinsics.areEqual((Object)ImportsUtils.getImportableFqName((DeclarationDescriptor)descriptor2), (Object)this.jsonFqName);
    }

    private final boolean isDefaultFormat(ResolvedCall<?> resolvedCall2, BindingContext context2) {
        boolean defaultFrom = false;
        boolean emptyBuilder = false;
        Map $this$forEach$iv = resolvedCall2.getValueArguments();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ValueParameterDescriptor paramDesc = (ValueParameterDescriptor)entry.getKey();
            ResolvedValueArgument arg = (ResolvedValueArgument)entry.getValue();
            Name name2 = paramDesc.getName();
            if (Intrinsics.areEqual((Object)name2, (Object)this.parameterNameFrom)) {
                defaultFrom = this.isDefaultFormatArgument(arg, context2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)this.parameterNameBuilderAction)) continue;
            emptyBuilder = this.isEmptyFunctionArgument(arg);
        }
        return defaultFrom && emptyBuilder;
    }

    private final boolean isDefaultFormatArgument(ResolvedValueArgument arg, BindingContext context2) {
        if (arg instanceof DefaultValueArgument) {
            return true;
        }
        if (!(arg instanceof ExpressionValueArgument)) {
            return false;
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)arg).getValueArgument();
        if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) {
            return false;
        }
        ValueArgument expression2 = valueArgument;
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)context2.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression2);
        if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null || (kotlinTypeInfo = FqNameUtilKt.getFqName((KotlinType)kotlinTypeInfo)) == null) {
            return false;
        }
        KotlinTypeInfo fqName2 = kotlinTypeInfo;
        return Intrinsics.areEqual((Object)fqName2, (Object)this.jsonDefaultFqName);
    }

    private final boolean isEmptyFunctionArgument(ResolvedValueArgument arg) {
        KtBlockExpression blockExpression2;
        Object object;
        Object object2;
        if (!(arg instanceof ExpressionValueArgument)) {
            return false;
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)arg).getValueArgument();
        if (valueArgument == null || (valueArgument = valueArgument.getArgumentExpression()) == null) {
            return false;
        }
        ValueArgument argumentExpression = valueArgument;
        if (argumentExpression instanceof KtNamedFunction) {
            object2 = ((KtNamedFunction)argumentExpression).getBodyBlockExpression();
            if (object2 == null) {
                return true;
            }
        } else {
            KtLambdaExpression ktLambdaExpression2 = KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)argumentExpression, (boolean)false, (int)1, null);
            object2 = ktLambdaExpression2 != null ? ktLambdaExpression2.getBodyExpression() : null;
        }
        return (object = (blockExpression2 = object2)) != null && (object = object.getStatements()) != null ? object.isEmpty() : false;
    }
}

