/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import java.io.File;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducer;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducerKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0014\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyDistDirLayoutProducer;", "Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer;", "", "Ljava/io/File;", "", "version", "", "unpackedDistDestination", "(Ljava/lang/String;Ljava/io/File;)V", "getDistJarNameFromMavenJar", "jarInMavenRepo", "lazyProduceDist", "jars", "produceOutput", "input", "computationContext", "(Ljava/util/List;Lkotlin/Unit;)Ljava/util/List;", "updateMessageDigestWithInput", "messageDigest", "Ljava/security/MessageDigest;", "buffer", "", "kotlin.base.plugin"})
final class LazyDistDirLayoutProducer
extends AbstractLazyFileOutputProducer<List<? extends File>, Unit> {
    @NotNull
    private final File unpackedDistDestination;

    public LazyDistDirLayoutProducer(@NotNull String version2, @NotNull File unpackedDistDestination) {
        super(LazyDistDirLayoutProducer.class.getName() + "-" + version2);
        this.unpackedDistDestination = unpackedDistDestination;
    }

    @Override
    @NotNull
    protected List<File> produceOutput(@NotNull List<? extends File> input, @NotNull Unit computationContext) {
        FilesKt.deleteRecursively((File)this.unpackedDistDestination);
        File lib = FilesKt.resolve((File)this.unpackedDistDestination, (String)"lib");
        if (!lib.mkdirs()) {
            boolean $i$a$-check-LazyDistDirLayoutProducer$produceOutput$22 = false;
            String $i$a$-check-LazyDistDirLayoutProducer$produceOutput$22 = "Can't create " + lib + " directory";
            throw new IllegalStateException($i$a$-check-LazyDistDirLayoutProducer$produceOutput$22.toString());
        }
        Iterator<? extends File> iterator = input.iterator();
        while (iterator.hasNext()) {
            File jarInMavenRepo;
            String string2 = this.getDistJarNameFromMavenJar(jarInMavenRepo);
            if (string2 == null) continue;
            jarInMavenRepo = iterator.next();
            FilesKt.copyTo$default((File)jarInMavenRepo, (File)FilesKt.resolve((File)lib, (String)string2), (boolean)false, (int)0, (int)6, null);
        }
        File jsEngines2 = KotlinPluginLayout.INSTANCE.getJsEngines();
        FilesKt.copyTo$default((File)jsEngines2, (File)FilesKt.resolve((File)lib, (String)jsEngines2.getName()), (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.listOf((Object)this.unpackedDistDestination);
    }

    @Override
    protected void updateMessageDigestWithInput(@NotNull MessageDigest messageDigest, @NotNull List<? extends File> input, @NotNull byte[] buffer) {
        AbstractLazyFileOutputProducerKt.update(messageDigest, input, buffer);
    }

    @NotNull
    public final File lazyProduceDist(@NotNull List<? extends File> jars) {
        File file2 = (File)CollectionsKt.singleOrNull(this.lazyProduceOutput(jars, Unit.INSTANCE));
        if (file2 == null) {
            throw new IllegalStateException("produceOutput returns single element".toString());
        }
        return file2;
    }

    private final String getDistJarNameFromMavenJar(File jarInMavenRepo) {
        String version2 = jarInMavenRepo.getParentFile().getName();
        String nameWithoutExtension = FilesKt.getNameWithoutExtension((File)jarInMavenRepo);
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"jline", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"jansi", (boolean)false, (int)2, null)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)jarInMavenRepo.getName(), (Object)"annotations-13.0.jar")) {
            return jarInMavenRepo.getName();
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-serialization", (boolean)false, (int)2, null)) {
            return "kotlinx-serialization-compiler-plugin.jar";
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-sam-with-receiver", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-allopen", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-lombok", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-noarg", (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)nameWithoutExtension, (CharSequence)"kotlin-maven-"), (CharSequence)("-" + version2)) + "-compiler-plugin.jar";
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-android-extensions-runtime", (boolean)false, (int)2, null)) {
            return "android-extensions-runtime.jar";
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-android-extensions", (boolean)false, (int)2, null)) {
            return "android-extensions-compiler.jar";
        }
        return StringsKt.removeSuffix((String)nameWithoutExtension, (CharSequence)("-" + version2)) + ".jar";
    }
}

