/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.JDOMUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenArtifactFinder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinMavenUtils;", "", "()V", "findArtifact", "Ljava/nio/file/Path;", "groupId", "", "artifactId", "version", "suffix", "findArtifactOrFail", "findLibraryVersion", "libraryFileName", "kotlin.base.plugin"})
public final class KotlinMavenUtils {
    @NotNull
    public static final KotlinMavenUtils INSTANCE = new KotlinMavenUtils();

    private KotlinMavenUtils() {
    }

    @NotNull
    public final String findLibraryVersion(@NotNull String libraryFileName) {
        List urlChunks;
        Object object;
        String firstRootUrl;
        Object mavenIdChunks;
        CharSequence mavenId;
        String[] stringArray = new String[]{".idea/libraries"};
        Path librariesDir = Paths.get(PathManager.getHomePath(), stringArray);
        Path libraryFile = librariesDir.resolve(libraryFileName);
        Element libraryDocument = JDOMUtil.load((Path)libraryFile);
        Element element3 = libraryDocument.getChild("library");
        if (element3 == null) {
            throw new IllegalStateException(("Invalid library file: " + libraryFile).toString());
        }
        Element libraryElement = element3;
        if (Intrinsics.areEqual((Object)libraryElement.getAttributeValue("type"), (Object)"repository")) {
            char[] cArray;
            Element propertiesElement;
            Element element4 = propertiesElement = libraryElement.getChild("properties");
            mavenId = element4 != null ? element4.getAttributeValue("maven-id") : null;
            CharSequence charSequence2 = mavenId;
            if (!(charSequence2 == null || charSequence2.length() == 0) && (mavenIdChunks = (Object)StringsKt.split$default((CharSequence)mavenId, (char[])(cArray = new char[]{':'}), (boolean)false, (int)0, (int)6, null)).size() == 3) {
                return (String)mavenIdChunks.get(2);
            }
        }
        if (!((mavenId = (CharSequence)(firstRootUrl = (object = libraryElement.getChild("CLASSES")) != null && (object = object.getChild("root")) != null && (object = object.getAttributeValue("url")) != null ? StringsKt.substringBefore$default((String)object, (String)"!/", null, (int)2, null) : null)) == null || mavenId.length() == 0) && (urlChunks = StringsKt.split$default((CharSequence)firstRootUrl, (char[])(mavenIdChunks = (Object)new char[]{'/'}), (boolean)false, (int)0, (int)6, null)).size() >= 3) {
            String fileName = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks));
            String version2 = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 1);
            String artifactId2 = (String)urlChunks.get(CollectionsKt.getLastIndex((List)urlChunks) - 2);
            if (StringsKt.startsWith$default((String)fileName, (String)(artifactId2 + "-" + version2), (boolean)false, (int)2, null) && StringsKt.endsWith((String)fileName, (String)".jar", (boolean)true)) {
                return version2;
            }
        }
        throw new IllegalStateException(("Can't get '" + libraryFileName + "' version").toString());
    }

    @NotNull
    public final Path findArtifactOrFail(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2) {
        Path path2 = KotlinMavenUtils.findArtifact$default(this, groupId2, artifactId2, version2, null, 8, null);
        if (path2 == null) {
            throw new IllegalStateException(("Artifact " + groupId2 + ":" + artifactId2 + ":" + version2 + " not found").toString());
        }
        return path2;
    }

    @Nullable
    public final Path findArtifact(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @NotNull String suffix2) {
        return KotlinMavenArtifactFinder.Companion.getInstance().findArtifact(groupId2, artifactId2, version2, suffix2);
    }

    public static /* synthetic */ Path findArtifact$default(KotlinMavenUtils kotlinMavenUtils, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            string5 = ".jar";
        }
        return kotlinMavenUtils.findArtifact(string2, string3, string4, string5);
    }
}

