/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00012\b\b\u0001\u0010\n\u001a\u00020\u0001H\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"versionWithFallback", "", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "getVersionWithFallback", "(Lorg/jetbrains/kotlin/config/JpsPluginSettings;)Ljava/lang/String;", "showNotificationUnsupportedJpsPluginVersion", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "content", "fileIsNotEmpty", "", "Ljava/nio/file/Path;", "kotlin.base.plugin"})
public final class KotlinJpsPluginSettingsKt {
    @NlsSafe
    @NotNull
    public static final String getVersionWithFallback(@NotNull JpsPluginSettings $this$versionWithFallback) {
        CharSequence charSequence2;
        CharSequence charSequence3 = $this$versionWithFallback.getVersion();
        if (charSequence3.length() == 0) {
            boolean bl = false;
            charSequence2 = KotlinJpsPluginSettings.Companion.getRawBundledVersion();
        } else {
            charSequence2 = charSequence3;
        }
        return (String)charSequence2;
    }

    private static final void showNotificationUnsupportedJpsPluginVersion(Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content2) {
        NotificationGroupManager.getInstance().getNotificationGroup("Kotlin JPS plugin").createNotification(title, content2, NotificationType.WARNING).setImportant(true).notify(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean fileIsNotEmpty(@NotNull Path $this$fileIsNotEmpty) {
        boolean bl;
        if (!PathKt.exists((Path)$this$fileIsNotEmpty)) return false;
        Object object = $this$fileIsNotEmpty;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl2 = false;
            bl = it.readLine() != null;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        if (!bl) return false;
        return true;
    }

    public static final /* synthetic */ void access$showNotificationUnsupportedJpsPluginVersion(Project project, String title, String content2) {
        KotlinJpsPluginSettingsKt.showNotificationUnsupportedJpsPluginVersion(project, title, content2);
    }
}

