/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.nio.file.Path;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JpsPluginSettings;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsKt;
import org.jetbrains.kotlin.idea.base.plugin.KotlinBasePluginBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.BaseKotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettingsKt;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.compiler.configuration.NewCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.OutdatedCompilerVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.ParsingError;
import org.jetbrains.kotlin.idea.compiler.configuration.UnsupportedJpsVersionError;

@State(name="KotlinJpsPluginSettings", storages={@Storage(value="kotlinc.xml")})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0014J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/BaseKotlinCompilerSettings;", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createSettings", "dropExplicitVersion", "", "setVersion", "jpsVersion", "", "Companion", "kotlin.base.plugin"})
public final class KotlinJpsPluginSettings
extends BaseKotlinCompilerSettings<JpsPluginSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KotlinVersion jpsMinimumSupportedVersion = IdeKotlinVersion.Companion.get("1.6.0").getKotlinVersion();
    @NotNull
    private static final KotlinVersion jpsMaximumSupportedVersion = LanguageVersionSettingsKt.toKotlinVersion((LanguageVersion)((LanguageVersion)ArraysKt.last((Object[])LanguageVersion.values())));

    public KotlinJpsPluginSettings(@NotNull Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected JpsPluginSettings createSettings() {
        return new JpsPluginSettings();
    }

    public final void setVersion(@NotNull String jpsVersion) {
        if (Intrinsics.areEqual((Object)jpsVersion, (Object)((JpsPluginSettings)this.getSettings()).getVersion())) {
            return;
        }
        this.update((Function1)new Function1<JpsPluginSettings, Unit>(jpsVersion){
            final /* synthetic */ String $jpsVersion;
            {
                this.$jpsVersion = $jpsVersion;
                super(1);
            }

            public final void invoke(@NotNull JpsPluginSettings $this$update) {
                $this$update.setVersion(this.$jpsVersion);
            }
        });
    }

    public final void dropExplicitVersion() {
        this.setVersion("");
    }

    @NotNull
    public static final String getRawBundledVersion() {
        return Companion.getRawBundledVersion();
    }

    @NotNull
    public static final String getFallbackVersionForOutdatedCompiler() {
        return Companion.getFallbackVersionForOutdatedCompiler();
    }

    @NotNull
    public static final IdeKotlinVersion getBundledVersion() {
        return Companion.getBundledVersion();
    }

    @NotNull
    public static final KotlinVersion getJpsMinimumSupportedVersion() {
        return Companion.getJpsMinimumSupportedVersion();
    }

    @NotNull
    public static final KotlinVersion getJpsMaximumSupportedVersion() {
        return Companion.getJpsMaximumSupportedVersion();
    }

    @JvmStatic
    @NotNull
    public static final KotlinJpsPluginSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u001cJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0015\u0010+\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b,J$\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0/J\u000e\u00100\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\f\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings$Companion;", "", "()V", "bundledVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getBundledVersion$annotations", "getBundledVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "fallbackVersionForOutdatedCompiler", "", "getFallbackVersionForOutdatedCompiler$annotations", "getFallbackVersionForOutdatedCompiler", "()Ljava/lang/String;", "jpsMaximumSupportedVersion", "Lkotlin/KotlinVersion;", "getJpsMaximumSupportedVersion$annotations", "getJpsMaximumSupportedVersion", "()Lkotlin/KotlinVersion;", "jpsMinimumSupportedVersion", "getJpsMinimumSupportedVersion$annotations", "getJpsMinimumSupportedVersion", "rawBundledVersion", "getRawBundledVersion$annotations", "getRawBundledVersion", "checkJpsVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/UnsupportedJpsVersionError;", "jpsVersion", "fromFile", "", "downloadKotlinJpsInBackground", "", "project", "Lcom/intellij/openapi/project/Project;", "version", "getInstance", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinJpsPluginSettings;", "importKotlinJpsVersionFromExternalBuildSystem", "rawVersion", "isDelegatedToExtBuild", "readFromKotlincXmlOrIpr", "Lorg/jetbrains/kotlin/config/JpsPluginSettings;", "path", "Ljava/nio/file/Path;", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem", "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin", "supportedJpsVersion", "onUnsupportedVersion", "Lkotlin/Function1;", "validateSettings", "kotlin.base.plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRawBundledVersion() {
            return this.getBundledVersion().getRawVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getRawBundledVersion$annotations() {
        }

        @NotNull
        public final String getFallbackVersionForOutdatedCompiler() {
            return "1.6.21";
        }

        @JvmStatic
        public static /* synthetic */ void getFallbackVersionForOutdatedCompiler$annotations() {
        }

        @NotNull
        public final IdeKotlinVersion getBundledVersion() {
            return KotlinPluginLayout.getStandaloneCompilerVersion();
        }

        @JvmStatic
        public static /* synthetic */ void getBundledVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMinimumSupportedVersion() {
            return jpsMinimumSupportedVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMinimumSupportedVersion$annotations() {
        }

        @NotNull
        public final KotlinVersion getJpsMaximumSupportedVersion() {
            return jpsMaximumSupportedVersion;
        }

        @JvmStatic
        public static /* synthetic */ void getJpsMaximumSupportedVersion$annotations() {
        }

        public final void validateSettings(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinJpsPluginSettings> serviceClass$iv = KotlinJpsPluginSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            KotlinJpsPluginSettings jpsPluginSettings = (KotlinJpsPluginSettings)object;
            if (((CharSequence)((JpsPluginSettings)jpsPluginSettings.getSettings()).getVersion()).length() == 0 && this.getBundledVersion().getBuildNumber() == null) {
                jpsPluginSettings.setVersion(this.getRawBundledVersion());
            }
        }

        @NotNull
        public final String jpsVersion(@NotNull Project project) {
            return KotlinJpsPluginSettingsKt.getVersionWithFallback((JpsPluginSettings)this.getInstance(project).getSettings());
        }

        @JvmStatic
        @NotNull
        public final KotlinJpsPluginSettings getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinJpsPluginSettings> serviceClass$iv = KotlinJpsPluginSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinJpsPluginSettings)object;
        }

        @Nls
        @Nullable
        public final UnsupportedJpsVersionError checkJpsVersion(@NotNull String jpsVersion, boolean fromFile) {
            KotlinVersion parsedKotlinVersion;
            IdeKotlinVersion ideKotlinVersion = IdeKotlinVersion.Companion.opt(jpsVersion);
            Object object = parsedKotlinVersion = ideKotlinVersion != null ? ideKotlinVersion.getKotlinVersion() : null;
            if (parsedKotlinVersion == null) {
                String string2;
                if (fromFile) {
                    Object[] objectArray = new Object[]{jpsVersion, "kotlinc.xml"};
                    string2 = KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0.from.1", objectArray);
                } else {
                    Object[] objectArray = new Object[]{jpsVersion};
                    string2 = KotlinBasePluginBundle.message("failed.to.parse.kotlin.version.0", objectArray);
                }
                return new ParsingError(string2);
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMinimumSupportedVersion()) < 0) {
                Object[] objectArray = new Object[]{this.getJpsMinimumSupportedVersion(), jpsVersion};
                return new OutdatedCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.minimum.supported.version.not.satisfied", objectArray));
            }
            if (parsedKotlinVersion.compareTo(this.getJpsMaximumSupportedVersion()) > 0) {
                Object[] objectArray = new Object[]{this.getJpsMaximumSupportedVersion(), jpsVersion};
                return new NewCompilerVersion(KotlinBasePluginBundle.message("kotlin.jps.compiler.maximum.supported.version.not.satisfied", objectArray));
            }
            return null;
        }

        public static /* synthetic */ UnsupportedJpsVersionError checkJpsVersion$default(Companion companion, String string2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.checkJpsVersion(string2, bl);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final JpsPluginSettings readFromKotlincXmlOrIpr(@NotNull Path path2) {
            JpsPluginSettings jpsPluginSettings;
            Object v1;
            block2: {
                void $this$singleOrNull$iv;
                Path path3;
                Path it = path3 = path2;
                boolean bl = false;
                if (!KotlinJpsPluginSettingsKt.fileIsNotEmpty(it)) return null;
                Path path4 = path3;
                Path path5 = path4;
                if (path5 == null) return null;
                Path it2 = path5;
                boolean $i$a$-let-KotlinJpsPluginSettings$Companion$readFromKotlincXmlOrIpr$32 = false;
                path3 = JDOMUtil.load((Path)path2);
                if (path3 == null) return null;
                List list2 = path3.getChildren();
                if (list2 == null) return null;
                Iterable $i$a$-let-KotlinJpsPluginSettings$Companion$readFromKotlincXmlOrIpr$32 = list2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Element it3 = (Element)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it3.getAttributeValue("name"), (Object)KotlinJpsPluginSettings.class.getSimpleName())) continue;
                    if (found$iv) {
                        v1 = null;
                        break block2;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            Element element3 = v1;
            if (element3 == null) return null;
            Element xmlElement = element3;
            boolean bl = false;
            JpsPluginSettings $this$readFromKotlincXmlOrIpr_u24lambda_u244_u24lambda_u243 = jpsPluginSettings = new JpsPluginSettings();
            boolean bl3 = false;
            XmlSerializer.deserializeInto((Object)$this$readFromKotlincXmlOrIpr_u24lambda_u244_u24lambda_u243, (Element)xmlElement);
            JpsPluginSettings jpsPluginSettings2 = jpsPluginSettings;
            return jpsPluginSettings2;
        }

        @Nullable
        public final String supportedJpsVersion(@NotNull Project project, @NotNull Function1<? super String, Unit> onUnsupportedVersion) {
            String string2;
            String version2 = this.jpsVersion(project);
            UnsupportedJpsVersionError error2 = this.checkJpsVersion(version2, true);
            if (error2 instanceof OutdatedCompilerVersion) {
                string2 = this.getFallbackVersionForOutdatedCompiler();
            } else if (error2 instanceof NewCompilerVersion ? true : error2 instanceof ParsingError) {
                onUnsupportedVersion.invoke((Object)error2.getMessage());
                string2 = null;
            } else if (error2 == null) {
                string2 = version2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }

        public final void importKotlinJpsVersionFromExternalBuildSystem(@NotNull Project project, @NotNull String rawVersion, boolean isDelegatedToExtBuild) {
            String string2;
            KotlinJpsPluginSettings instance2 = this.getInstance(project);
            if (Intrinsics.areEqual((Object)rawVersion, (Object)this.getRawBundledVersion())) {
                instance2.setVersion(rawVersion);
                return;
            }
            Object[] error2 = org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings$Companion.checkJpsVersion$default(this, rawVersion, false, 2, null);
            Object[] objectArray = error2;
            if (objectArray instanceof OutdatedCompilerVersion) {
                string2 = this.getFallbackVersionForOutdatedCompiler();
            } else if (objectArray instanceof NewCompilerVersion ? true : objectArray instanceof ParsingError) {
                string2 = this.getRawBundledVersion();
            } else if (objectArray == null) {
                string2 = rawVersion;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            String version2 = string2;
            if (error2 != null && !isDelegatedToExtBuild) {
                objectArray = new Object[]{version2, error2.getMessage()};
                KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion(project, KotlinBasePluginBundle.message("notification.title.unsupported.kotlin.jps.plugin.version", new Object[0]), KotlinBasePluginBundle.message("notification.content.bundled.version.0.will.be.used.reason.1", objectArray));
            }
            if ((objectArray = error2) instanceof ParsingError ? true : objectArray instanceof NewCompilerVersion) {
                instance2.dropExplicitVersion();
                return;
            }
            if (objectArray == null ? true : objectArray instanceof OutdatedCompilerVersion) {
                // empty if block
            }
            if (!this.shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin(IdeKotlinVersion.Companion.get(version2))) {
                instance2.dropExplicitVersion();
                return;
            }
            if (!isDelegatedToExtBuild) {
                this.downloadKotlinJpsInBackground(project, version2);
            }
            instance2.setVersion(version2);
        }

        private final void downloadKotlinJpsInBackground(Project project, String version2) {
            String string2 = KotlinBasePluginBundle.INSTANCE.getMessage("progress.text.downloading.kotlinc.dist", new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, version2, string2){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $version;
                {
                    this.$project = $project;
                    this.$version = $version;
                    super($project, $super_call_param$1, true);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    KotlinArtifactsDownloader.INSTANCE.lazyDownloadMissingJpsPluginDependencies(this.$project, this.$version, indicator, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$project){
                        final /* synthetic */ Project $project;
                        {
                            this.$project = $project;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            KotlinJpsPluginSettingsKt.access$showNotificationUnsupportedJpsPluginVersion(this.$project, KotlinBasePluginBundle.message("kotlin.dist.downloading.failed", new Object[0]), it);
                        }
                    }));
                }
            });
        }

        public final boolean shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$kotlin_base_plugin(@NotNull IdeKotlinVersion version2) {
            if (!(this.getJpsMinimumSupportedVersion().compareTo(IdeKotlinVersion.Companion.get("1.7.10").getKotlinVersion()) < 0)) {
                boolean $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = false;
                String $i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22 = "shouldImportKotlinJpsPluginVersionFromExternalBuildSystem makes sense when minimum supported version is lower than 1.7.20. If minimum supported version is already 1.7.20 then you can drop this function.";
                throw new IllegalStateException($i$a$-check-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$22.toString());
            }
            if (!(version2.getKotlinVersion().compareTo(this.getJpsMinimumSupportedVersion()) >= 0)) {
                boolean $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = false;
                String $i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32 = version2.getKotlinVersion() + " is lower than " + Companion.getJpsMinimumSupportedVersion();
                throw new IllegalArgumentException($i$a$-require-KotlinJpsPluginSettings$Companion$shouldImportKotlinJpsPluginVersionFromExternalBuildSystem$32.toString());
            }
            IdeKotlinVersion kt160 = IdeKotlinVersion.Companion.get("1.6.0");
            IdeKotlinVersion kt170 = IdeKotlinVersion.Companion.get("1.7.0");
            return version2.compareTo(kt170) > 0 || version2.compareTo(kt160) >= 0 && version2.isRelease() && version2.getBuildNumber() == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

