/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.codeinsight.utils.RedundantSemicolonUtilsKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\t\u001a\u00020\u0004*\u0004\u0018\u00010\u0006H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"softModifierKeywords", "", "", "isRedundantSemicolon", "", "semicolon", "Lcom/intellij/psi/PsiElement;", "isRequiredForCompanion", "isSemicolonRequired", "isBeforeLeftBrace", "kotlin.code-insight.utils"})
public final class RedundantSemicolonUtilsKt {
    @NotNull
    private static final List<String> softModifierKeywords;

    public static final boolean isRedundantSemicolon(@NotNull PsiElement semicolon) {
        PsiElement psiElement2;
        boolean isAtEndOfLine;
        PsiElement nextLeaf2 = PsiUtilsKt.nextLeaf((PsiElement)semicolon, (Function1)isRedundantSemicolon.nextLeaf.1.INSTANCE);
        boolean bl = isAtEndOfLine = nextLeaf2 == null || FormatterUtilKt.isLineBreak(nextLeaf2);
        if (!isAtEndOfLine) {
            if (semicolon.getParent() instanceof KtPackageDirective) {
                Object object = nextLeaf2 instanceof KtImportList ? (KtImportList)nextLeaf2 : null;
                boolean bl2 = object != null && (object = object.getImports()) != null ? object.isEmpty() : false;
                if (bl2) {
                    return true;
                }
            }
            return PsiUtilsKt.prevLeaf((PsiElement)semicolon, (Function1)isRedundantSemicolon.1.INSTANCE) instanceof PsiWhiteSpace && !RedundantSemicolonUtilsKt.isBeforeLeftBrace(semicolon);
        }
        PsiElement psiElement3 = PsiUtilsKt.prevLeaf$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        if (Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)KtNodeTypes.ELSE)) {
            return false;
        }
        if (semicolon.getParent() instanceof KtEnumEntry) {
            return false;
        }
        PsiElement psiElement4 = semicolon.getParent().getParent();
        KtClass ktClass = psiElement4 instanceof KtClass ? (KtClass)psiElement4 : null;
        if (ktClass != null) {
            KtClass clazz = ktClass;
            boolean bl3 = false;
            if (clazz.isEnum()) {
                PsiElement $this$getChildrenOfType$iv = (PsiElement)clazz;
                boolean $i$f$getChildrenOfType = false;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtEnumEntry.class);
                if (psiElementArray == null) {
                    psiElementArray = (PsiElement[])new KtEnumEntry[0];
                }
                if (psiElementArray.length == 0 && Intrinsics.areEqual(($this$getChildrenOfType$iv = PsiUtilsKt.prevLeaf((PsiElement)semicolon, (Function1)isRedundantSemicolon.2.1.INSTANCE)) != null && ($i$f$getChildrenOfType = $this$getChildrenOfType$iv.getNode()) != null ? $i$f$getChildrenOfType.getElementType() : null, (Object)KtTokens.LBRACE) && !((Collection)clazz.getDeclarations()).isEmpty()) {
                    return false;
                }
            }
        }
        PsiElement psiElement5 = PsiUtilsKt.prevLeaf$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        psiElement4 = psiElement5 != null ? psiElement5.getParent() : null;
        KtLoopExpression ktLoopExpression = psiElement4 instanceof KtLoopExpression ? (KtLoopExpression)psiElement4 : null;
        if (ktLoopExpression != null) {
            KtLoopExpression it = ktLoopExpression;
            boolean bl4 = false;
            if (!(it instanceof KtDoWhileExpression) && it.getBody() == null) {
                return false;
            }
        }
        if ((psiElement2 = PsiUtilsKt.prevLeaf$default((PsiElement)semicolon, (boolean)false, (int)1, null)) != null && (psiElement2 = psiElement2.getParent()) != null) {
            PsiElement $this$safeAs$iv = psiElement2;
            boolean $i$f$safeAs = false;
            PsiElement psiElement6 = $this$safeAs$iv;
            if (!(psiElement6 instanceof KtIfExpression)) {
                psiElement6 = null;
            }
            if ((psiElement2 = (KtIfExpression)psiElement6) != null) {
                PsiElement psiElement7;
                PsiElement ifExpression2 = psiElement7 = psiElement2;
                boolean bl5 = false;
                if (ifExpression2.getThen() == null) {
                    return false;
                }
            }
        }
        if (RedundantSemicolonUtilsKt.isBeforeLeftBrace(nextLeaf2)) {
            return false;
        }
        return !RedundantSemicolonUtilsKt.isSemicolonRequired(semicolon);
    }

    private static final boolean isBeforeLeftBrace(PsiElement $this$isBeforeLeftBrace) {
        ASTNode aSTNode;
        PsiElement psiElement2;
        return Intrinsics.areEqual($this$isBeforeLeftBrace != null && (psiElement2 = PsiUtilsKt.nextLeaf((PsiElement)$this$isBeforeLeftBrace, (Function1)isBeforeLeftBrace.1.INSTANCE)) != null && (aSTNode = psiElement2.getNode()) != null ? aSTNode.getElementType() : null, (Object)KtTokens.LBRACE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSemicolonRequired(PsiElement semicolon) {
        if (RedundantSemicolonUtilsKt.isRequiredForCompanion(semicolon)) {
            return true;
        }
        PsiElement prevSibling2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        PsiElement nextSibling = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        Iterable iterable = softModifierKeywords;
        PsiElement $this$safeAs$iv = prevSibling2;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtNameReferenceExpression)) {
            psiElement2 = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)psiElement2;
        if (CollectionsKt.contains((Iterable)iterable, (Object)(ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null)) && nextSibling instanceof KtDeclaration) {
            return true;
        }
        if (!(nextSibling instanceof KtPrefixExpression)) return false;
        if (!Intrinsics.areEqual((Object)((KtPrefixExpression)nextSibling).getOperationToken(), (Object)KtTokens.EXCL)) return false;
        PsiElement psiElement3 = PsiUtilsKt.prevLeaf$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        PsiElement psiElement4 = psiElement3;
        if (psiElement3 == null) return false;
        PsiElement $this$getStrictParentOfType$iv = psiElement4;
        boolean $i$f$getStrictParentOfType = false;
        KtTypeReference ktTypeReference = (KtTypeReference)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeReference.class, (boolean)true);
        psiElement4 = ktTypeReference;
        if (ktTypeReference == null) return false;
        KtTypeElement ktTypeElement = psiElement4.getTypeElement();
        KtTypeElement typeElement = ktTypeElement;
        if (typeElement == null) return false;
        if (typeElement instanceof KtNullableType) return false;
        return true;
    }

    private static final boolean isRequiredForCompanion(PsiElement semicolon) {
        block8: {
            block7: {
                PsiElement psiElement2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)semicolon, (boolean)false, (int)1, null);
                KtObjectDeclaration ktObjectDeclaration = psiElement2 instanceof KtObjectDeclaration ? (KtObjectDeclaration)psiElement2 : null;
                if (ktObjectDeclaration == null) {
                    return false;
                }
                KtObjectDeclaration prev2 = ktObjectDeclaration;
                if (!prev2.isCompanion()) {
                    return false;
                }
                if (prev2.getNameIdentifier() != null) break block7;
                PsiElement $this$getChildOfType$iv = (PsiElement)prev2;
                boolean $i$f$getChildOfType = false;
                if (PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtClassBody.class) == null) break block8;
            }
            return false;
        }
        PsiElement psiElement3 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)semicolon, (boolean)false, (int)1, null);
        if (psiElement3 == null) {
            return false;
        }
        PsiElement next2 = psiElement3;
        PsiElement psiElement4 = next2.getFirstChild();
        if (psiElement4 == null || (psiElement4 = psiElement4.getNode()) == null) {
            return false;
        }
        PsiElement firstChildNode = psiElement4;
        return !KtTokens.KEYWORDS.contains(firstChildNode.getElementType());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapNotNullTo$iv$iv;
        IElementType[] $this$mapNotNull$iv = KtTokens.SOFT_KEYWORDS.getTypes();
        boolean $i$f$mapNotNull = false;
        IElementType[] iElementTypeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            KtModifierKeywordToken ktModifierKeywordToken = it instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)it : null;
            if ((ktModifierKeywordToken != null ? ktModifierKeywordToken.toString() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        softModifierKeywords = (List)var3_3;
    }
}

