/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.NegatedBinaryExpressionSimplificationUtils;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012\u001a\n\u0010\u0015\u001a\u00020\u0005*\u00020\u0012\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\t*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a\u0012\u0010\u001b\u001a\u00020\u0005*\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000f\u001a\n\u0010\u001d\u001a\u00020\u0005*\u00020\u0012\u001a\n\u0010\u001e\u001a\u00020\u0005*\u00020\u0012\u001a(\u0010\u001f\u001a\u00020\u0019*\u00020\u00192\b\b\u0002\u0010 \u001a\u00020\u00052\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\"\u001a$\u0010#\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\b\b\u0002\u0010'\u001a\u00020\u0005\u001a*\u0010(\u001a\u0004\u0018\u00010\u0019*\u00020\u00192\u0006\u0010 \u001a\u00020\u00052\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\"H\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006)"}, d2={"NEGATABLE_OPERATORS", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "isSetterParameter", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;)Z", "getNegatedOperatorText", "", "token", "Lcom/intellij/psi/tree/IElementType;", "removeProperty", "", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "removeRedundantGetter", "getter", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "removeRedundantSetter", "setter", "canBeCompletelyDeleted", "getControlFlowElementDescription", "Lorg/jetbrains/kotlin/psi/KtContainerNode;", "getLeftMostReceiverExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "isBackingFieldReferenceTo", "property", "isRedundantGetter", "isRedundantSetter", "negate", "reformat", "isBooleanExpression", "Lkotlin/Function1;", "replaceFirstReceiver", "factory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "newReceiver", "safeAccess", "specialNegation", "kotlin.code-insight.utils"})
public final class KotlinPsiUtilsKt {
    @NotNull
    private static final Set<KtSingleValueToken> NEGATABLE_OPERATORS;

    @Nullable
    public static final String getControlFlowElementDescription(@NotNull KtContainerNode $this$getControlFlowElementDescription) {
        IElementType iElementType = $this$getControlFlowElementDescription.getNode().getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.THEN)) {
            return "if";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.ELSE)) {
            return "else";
        }
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BODY)) {
            PsiElement psiElement2 = $this$getControlFlowElementDescription.getParent();
            if (psiElement2 instanceof KtWhileExpression) {
                return "while";
            }
            if (psiElement2 instanceof KtDoWhileExpression) {
                return "do...while";
            }
            if (psiElement2 instanceof KtForExpression) {
                return "for";
            }
        }
        return null;
    }

    public static final boolean isRedundantGetter(@NotNull KtPropertyAccessor $this$isRedundantGetter) {
        if (!$this$isRedundantGetter.isGetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantGetter.getBodyExpression();
        if (ktExpression == null) {
            return KotlinPsiUtilsKt.canBeCompletelyDeleted($this$isRedundantGetter);
        }
        KtExpression expression2 = ktExpression;
        if (KotlinPsiUtilsKt.isBackingFieldReferenceTo(expression2, $this$isRedundantGetter.getProperty())) {
            return true;
        }
        if (expression2 instanceof KtBlockExpression) {
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)((KtBlockExpression)expression2).getStatements());
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement2 = ktExpression2;
            KtReturnExpression ktReturnExpression = statement2 instanceof KtReturnExpression ? (KtReturnExpression)statement2 : null;
            if (ktReturnExpression == null) {
                return false;
            }
            KtReturnExpression returnExpression2 = ktReturnExpression;
            KtExpression ktExpression3 = returnExpression2.getReturnedExpression();
            return ktExpression3 != null ? KotlinPsiUtilsKt.isBackingFieldReferenceTo(ktExpression3, $this$isRedundantGetter.getProperty()) : false;
        }
        return false;
    }

    public static final boolean isBackingFieldReferenceTo(@NotNull KtExpression $this$isBackingFieldReferenceTo, @NotNull KtProperty property2) {
        return $this$isBackingFieldReferenceTo instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((KtNameReferenceExpression)$this$isBackingFieldReferenceTo).getText(), (Object)KtTokens.FIELD_KEYWORD.getValue()) && PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)property2), (PsiElement)((PsiElement)$this$isBackingFieldReferenceTo), (boolean)false, (int)2, null);
    }

    public static final boolean canBeCompletelyDeleted(@NotNull KtPropertyAccessor $this$canBeCompletelyDeleted) {
        if ($this$canBeCompletelyDeleted.getModifierList() == null) {
            return true;
        }
        if (!((Collection)$this$canBeCompletelyDeleted.getAnnotationEntries()).isEmpty()) {
            return false;
        }
        if ($this$canBeCompletelyDeleted.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
            return false;
        }
        return Intrinsics.areEqual((Object)KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)$this$canBeCompletelyDeleted)), (Object)KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)$this$canBeCompletelyDeleted.getProperty())));
    }

    public static final void removeRedundantGetter(@NotNull KtPropertyAccessor getter2) {
        KtProperty property2 = getter2.getProperty();
        KtTypeReference accessorTypeReference = getter2.getReturnTypeReference();
        if (accessorTypeReference != null && property2.getTypeReference() == null && property2.getInitializer() == null) {
            property2.setTypeReference(accessorTypeReference);
        }
        if (KotlinPsiUtilsKt.canBeCompletelyDeleted(getter2)) {
            getter2.delete();
        } else {
            KotlinPsiUtils.deleteBody(getter2);
        }
    }

    public static final void removeProperty(@NotNull KtProperty ktProperty) {
        KtExpression initializer2 = ktProperty.getInitializer();
        if (initializer2 != null && !(initializer2 instanceof KtConstantExpression)) {
            CommentSaver commentSaver = new CommentSaver((PsiElement)ktProperty, false, 2, null);
            PsiElement replaced2 = ktProperty.replace((PsiElement)initializer2);
            CommentSaver.restore$default(commentSaver, replaced2, false, 2, null);
        } else {
            ktProperty.delete();
        }
    }

    public static final boolean isSetterParameter(@NotNull KtParameter $this$isSetterParameter) {
        PsiElement psiElement2 = $this$isSetterParameter.getParent().getParent();
        KtPropertyAccessor ktPropertyAccessor = psiElement2 instanceof KtPropertyAccessor ? (KtPropertyAccessor)psiElement2 : null;
        return ktPropertyAccessor != null ? ktPropertyAccessor.isSetter() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRedundantSetter(@NotNull KtPropertyAccessor $this$isRedundantSetter) {
        if (!$this$isRedundantSetter.isSetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantSetter.getBodyExpression();
        if (ktExpression == null) {
            return KotlinPsiUtilsKt.canBeCompletelyDeleted($this$isRedundantSetter);
        }
        KtExpression expression2 = ktExpression;
        if (!(expression2 instanceof KtBlockExpression)) return false;
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)((KtBlockExpression)expression2).getStatements());
        if (ktExpression2 == null) {
            return false;
        }
        KtExpression statement2 = ktExpression2;
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)$this$isRedundantSetter.getValueParameters());
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter2 = ktParameter;
        if (!(statement2 instanceof KtBinaryExpression)) return false;
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)statement2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQ)) return false;
        KtExpression ktExpression3 = binaryExpression.getLeft();
        if (ktExpression3 == null) return false;
        if (!KotlinPsiUtilsKt.isBackingFieldReferenceTo(ktExpression3, $this$isRedundantSetter.getProperty())) return false;
        boolean bl = true;
        if (!bl) return false;
        KtExpression ktExpression4 = binaryExpression.getRight();
        if (!Intrinsics.areEqual(ktExpression4 != null && (ktExpression4 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression4))) != null ? ktExpression4.resolve() : null, (Object)parameter2)) return false;
        return true;
    }

    public static final void removeRedundantSetter(@NotNull KtPropertyAccessor setter2) {
        if (KotlinPsiUtilsKt.canBeCompletelyDeleted(setter2)) {
            setter2.delete();
        } else {
            KotlinPsiUtils.deleteBody(setter2);
        }
    }

    @NotNull
    public static final KtExpression negate(@NotNull KtExpression $this$negate, boolean reformat, @NotNull Function1<? super KtExpression, Boolean> isBooleanExpression) {
        KtExpression specialNegation = KotlinPsiUtilsKt.specialNegation($this$negate, reformat, isBooleanExpression);
        if (specialNegation != null) {
            return specialNegation;
        }
        Object[] objectArray = new Object[]{$this$negate};
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory((KtElement)$this$negate, false, 2, null), (String)"!$0", (Object[])objectArray, (boolean)reformat);
    }

    public static /* synthetic */ KtExpression negate$default(KtExpression ktExpression, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPsiUtilsKt.negate(ktExpression, bl, (Function1<? super KtExpression, Boolean>)function1);
    }

    private static final KtExpression specialNegation(KtExpression $this$specialNegation, boolean reformat, Function1<? super KtExpression, Boolean> isBooleanExpression) {
        KtPsiFactory factory2 = new KtPsiFactory((KtElement)$this$specialNegation, false, 2, null);
        KtExpression ktExpression = $this$specialNegation;
        if (ktExpression instanceof KtPrefixExpression) {
            KtExpression baseExpression;
            if (Intrinsics.areEqual((Object)((KtPrefixExpression)$this$specialNegation).getOperationReference().getReferencedName(), (Object)"!") && (baseExpression = ((KtPrefixExpression)$this$specialNegation).getBaseExpression()) != null && ((Boolean)isBooleanExpression.invoke((Object)baseExpression)).booleanValue()) {
                return KtPsiUtil.safeDeparenthesize((KtExpression)baseExpression);
            }
        } else {
            if (ktExpression instanceof KtBinaryExpression) {
                IElementType operator = ((KtBinaryExpression)$this$specialNegation).getOperationToken();
                if (!CollectionsKt.contains((Iterable)NEGATABLE_OPERATORS, (Object)operator)) {
                    return null;
                }
                KtExpression ktExpression2 = ((KtBinaryExpression)$this$specialNegation).getLeft();
                if (ktExpression2 == null) {
                    return null;
                }
                KtExpression left = ktExpression2;
                KtExpression ktExpression3 = ((KtBinaryExpression)$this$specialNegation).getRight();
                if (ktExpression3 == null) {
                    return null;
                }
                KtExpression right2 = ktExpression3;
                Object[] objectArray = new Object[]{left, KotlinPsiUtilsKt.getNegatedOperatorText(operator), right2};
                return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
            }
            if (ktExpression instanceof KtIsExpression) {
                Object[] objectArray = new Object[3];
                objectArray[0] = ((KtIsExpression)$this$specialNegation).getLeftHandSide();
                Object object = objectArray[1] = ((KtIsExpression)$this$specialNegation).isNegated() ? "is" : "!is";
                if (((KtIsExpression)$this$specialNegation).getTypeReference() == null) {
                    Object cfr_ignored_0 = objectArray[2];
                    return null;
                }
                return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)factory2, (String)"$0 $1 $2", (Object[])objectArray, (boolean)reformat);
            }
            if (ktExpression instanceof KtConstantExpression) {
                String string2 = ((KtConstantExpression)$this$specialNegation).getText();
                return Intrinsics.areEqual((Object)string2, (Object)"true") ? factory2.createExpression("false") : (Intrinsics.areEqual((Object)string2, (Object)"false") ? factory2.createExpression("true") : null);
            }
        }
        return null;
    }

    private static final String getNegatedOperatorText(IElementType token) {
        KtSingleValueToken ktSingleValueToken = NegatedBinaryExpressionSimplificationUtils.INSTANCE.negate(token);
        if (ktSingleValueToken == null) {
            throw new IllegalArgumentException("The token " + token + " does not have a negated equivalent.");
        }
        KtSingleValueToken negatedOperator = ktSingleValueToken;
        return negatedOperator.getValue();
    }

    @NotNull
    public static final KtExpression getLeftMostReceiverExpression(@NotNull KtDotQualifiedExpression $this$getLeftMostReceiverExpression) {
        KtExpression ktExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
        if (ktDotQualifiedExpression == null || (ktDotQualifiedExpression = KotlinPsiUtilsKt.getLeftMostReceiverExpression(ktDotQualifiedExpression)) == null) {
            ktDotQualifiedExpression = $this$getLeftMostReceiverExpression.getReceiverExpression();
        }
        return ktDotQualifiedExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression replaceFirstReceiver(@NotNull KtDotQualifiedExpression $this$replaceFirstReceiver, @NotNull KtPsiFactory factory2, @NotNull KtExpression newReceiver, boolean safeAccess) {
        KtExpression ktExpression;
        if (safeAccess) {
            PsiElement psiElement2;
            void $this$replaced$iv;
            PsiElement psiElement3 = (PsiElement)$this$replaceFirstReceiver;
            Object[] objectArray = new Object[2];
            objectArray[0] = $this$replaceFirstReceiver.getReceiverExpression();
            Intrinsics.checkNotNull((Object)$this$replaceFirstReceiver.getSelectorExpression());
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"$0?.$1", (Object[])objectArray, (boolean)false, (int)4, null);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement2 = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement2 = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression2 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement2 = (PsiElement)ktExpression2;
                }
            }
            ktExpression = (KtExpression)psiElement2;
        } else {
            ktExpression = (KtExpression)$this$replaceFirstReceiver;
        }
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
        KtQualifiedExpression replacedExpression = (KtQualifiedExpression)ktExpression;
        KtExpression receiver2 = replacedExpression.getReceiverExpression();
        if (receiver2 instanceof KtDotQualifiedExpression) {
            ((KtDotQualifiedExpression)receiver2).replace((PsiElement)KotlinPsiUtilsKt.replaceFirstReceiver((KtDotQualifiedExpression)receiver2, factory2, newReceiver, safeAccess));
        } else {
            receiver2.replace((PsiElement)newReceiver);
        }
        return (KtExpression)replacedExpression;
    }

    public static /* synthetic */ KtExpression replaceFirstReceiver$default(KtDotQualifiedExpression ktDotQualifiedExpression, KtPsiFactory ktPsiFactory, KtExpression ktExpression, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return KotlinPsiUtilsKt.replaceFirstReceiver(ktDotQualifiedExpression, ktPsiFactory, ktExpression, bl);
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, (KtSingleValueToken)KtTokens.IS_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IS, (KtSingleValueToken)KtTokens.IN_KEYWORD, (KtSingleValueToken)KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ};
        NEGATABLE_OPERATORS = SetsKt.setOf((Object[])objectArray);
    }
}

