/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

public abstract class AbstractKotlinUpDownMover
extends LineMover {
    protected AbstractKotlinUpDownMover() {
    }

    protected abstract boolean checkSourceElement(@NotNull PsiElement var1);

    protected abstract LineRange getElementSourceLineRange(@NotNull PsiElement var1, @NotNull Editor var2, @NotNull LineRange var3);

    @Nullable
    protected LineRange getSourceRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement, @NotNull Editor editor2, LineRange oldRange) {
        KtBlockExpression block2;
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        int topExtension = 0;
        int bottomExtension = 0;
        if (parent2 instanceof KtFunctionLiteral && (block2 = ((KtFunctionLiteral)parent2).getBodyExpression()) != null) {
            PsiElement comment2 = null;
            boolean extendDown = false;
            if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(firstElement, lastElement, block2)) {
                comment2 = lastElement;
                extendDown = true;
                lastElement = block2.getLastChild();
            } else if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(lastElement, firstElement, block2)) {
                comment2 = firstElement;
                firstElement = block2.getFirstChild();
            }
            if (comment2 != null) {
                int extension2 = PsiLinesUtilsKt.getLineCount(comment2);
                if (extendDown) {
                    bottomExtension = extension2;
                } else {
                    topExtension = extension2;
                }
            }
            parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        }
        if (parent2 == null) {
            return null;
        }
        Pair originalRange = AbstractKotlinUpDownMover.getElementRange((PsiElement)parent2, (PsiElement)firstElement, (PsiElement)lastElement);
        if (!this.checkSourceElement((PsiElement)originalRange.first) || !this.checkSourceElement((PsiElement)originalRange.second)) {
            return null;
        }
        LineRange lineRange1 = this.getElementSourceLineRange((PsiElement)originalRange.first, editor2, oldRange);
        if (lineRange1 == null) {
            return null;
        }
        LineRange lineRange2 = this.getElementSourceLineRange((PsiElement)originalRange.second, editor2, oldRange);
        if (lineRange2 == null) {
            return null;
        }
        LineRange parentLineRange = this.getElementSourceLineRange(parent2, editor2, oldRange);
        LineRange sourceRange = new LineRange(lineRange1.startLine - topExtension, lineRange2.endLine + bottomExtension);
        if (parentLineRange != null && sourceRange.startLine == parentLineRange.startLine && sourceRange.endLine == parentLineRange.endLine) {
            sourceRange.firstElement = sourceRange.lastElement = parent2;
        } else {
            sourceRange.firstElement = (PsiElement)originalRange.first;
            sourceRange.lastElement = (PsiElement)originalRange.second;
        }
        return sourceRange;
    }

    protected static int getElementLine(@Nullable PsiElement element3, @NotNull Editor editor2, boolean first2) {
        if (element3 == null) {
            return -1;
        }
        Document doc = editor2.getDocument();
        TextRange spaceRange = element3.getTextRange();
        return first2 ? doc.getLineNumber(spaceRange.getStartOffset()) : doc.getLineNumber(spaceRange.getEndOffset());
    }

    protected static PsiElement getLastNonWhiteSiblingInLine(@Nullable PsiElement element3, @NotNull Editor editor2, boolean down) {
        if (element3 == null) {
            return null;
        }
        int line = AbstractKotlinUpDownMover.getElementLine(element3, editor2, down);
        PsiElement lastElement = element3;
        while (true) {
            if (lastElement == null) {
                return null;
            }
            PsiElement sibling = AbstractKotlinUpDownMover.firstNonWhiteSibling(lastElement, down);
            if (AbstractKotlinUpDownMover.getElementLine(sibling, editor2, down) != line) break;
            lastElement = sibling;
        }
        return lastElement;
    }

    @Nullable
    protected static KtAnnotationEntry getParentFileAnnotationEntry(@Nullable PsiElement element3) {
        if (element3 == null) {
            return null;
        }
        KtAnnotationEntry annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)element3, KtAnnotationEntry.class);
        if (annotationEntry2 == null) {
            return null;
        }
        KtAnnotationUseSiteTarget useSiteTarget = annotationEntry2.getUseSiteTarget();
        if (useSiteTarget == null) {
            return null;
        }
        ASTNode node2 = useSiteTarget.getNode().getFirstChildNode();
        if (node2 == null) {
            return null;
        }
        if (node2.getElementType() != KtTokens.FILE_KEYWORD) {
            return null;
        }
        return annotationEntry2;
    }

    private static boolean checkCommentAtBlockBound(PsiElement blockElement, PsiElement comment2, KtBlockExpression block2) {
        return PsiTreeUtil.isAncestor((PsiElement)block2, (PsiElement)blockElement, (boolean)true) && comment2 instanceof PsiComment;
    }

    @Nullable
    protected static PsiElement getSiblingOfType(@NotNull PsiElement element3, boolean down, @NotNull Class<? extends PsiElement> type2) {
        return down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)element3, type2) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)element3, type2);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull LineRange lineRange, boolean down) {
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? lineRange.lastElement.getNextSibling() : lineRange.firstElement.getPrevSibling()), (boolean)down);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull PsiElement element3, boolean down) {
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? element3.getNextSibling() : element3.getPrevSibling()), (boolean)down);
    }

    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        return file2 instanceof KtFile && super.checkAvailable(editor2, file2, info2, down);
    }
}

