/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinComponentUnwrapper;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinRemover;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinUnwrappers {
    private KotlinUnwrappers() {
    }

    public static class KotlinFinallyRemover
    extends KotlinRemover {
        public KotlinFinallyRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtFinallySection;
        }
    }

    public static class KotlinFinallyUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinFinallyUnwrapper(String key) {
            super(key);
        }

        @Override
        public boolean isApplicableTo(PsiElement e) {
            return super.isApplicableTo(e) && this.getEnclosingElement((KtElement)e).getParent() instanceof KtBlockExpression;
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element3) {
            return (KtElement)element3.getParent();
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtFinallySection ? ((KtFinallySection)target2).getFinalExpression() : null;
        }
    }

    public static class KotlinCatchRemover
    extends KotlinRemover {
        public KotlinCatchRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtCatchClause;
        }
    }

    public static class KotlinCatchUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinCatchUnwrapper(String key) {
            super(key);
        }

        @Override
        @NotNull
        protected KtElement getEnclosingElement(@NotNull KtElement element3) {
            return (KtElement)element3.getParent();
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtCatchClause ? ((KtCatchClause)target2).getCatchBody() : null;
        }
    }

    public static class KotlinTryUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinTryUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtTryExpression ? ((KtTryExpression)target2).getTryBlock() : null;
        }
    }

    public static class KotlinLoopUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinLoopUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtLoopExpression ? ((KtLoopExpression)target2).getBody() : null;
        }
    }

    public static class KotlinElseRemover
    extends KotlinUnwrapRemoveBase {
        public KotlinElseRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtIfExpression && ((KtIfExpression)e).getCondition() != null && ((KtIfExpression)e).getThen() != null && ((KtIfExpression)e).getElse() != null;
        }

        protected void doUnwrap(PsiElement element3, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
            KtIfExpression ifExpr = (KtIfExpression)element3;
            context2.replace((KtElement)ifExpr, (KtElement)KtPsiFactoryKt.KtPsiFactory((PsiElement)ifExpr).createIf(ifExpr.getCondition(), ifExpr.getThen(), null));
        }
    }

    public static class KotlinThenUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinThenUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtIfExpression ? ((KtIfExpression)target2).getThen() : null;
        }
    }

    public static class KotlinElseUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinElseUnwrapper(String key) {
            super(key);
        }

        @Override
        protected KtExpression getExpressionToUnwrap(@NotNull KtElement target2) {
            return target2 instanceof KtIfExpression ? ((KtIfExpression)target2).getElse() : null;
        }
    }

    public static class KotlinExpressionRemover
    extends KotlinRemover {
        public KotlinExpressionRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof KtExpression && e.getParent() instanceof KtBlockExpression;
        }
    }
}

