/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

public abstract class KotlinUnwrapRemoveBase
extends AbstractUnwrapper<Context> {
    private final String key;

    protected KotlinUnwrapRemoveBase(@NotNull String key) {
        super("");
        this.key = key;
    }

    public String getDescription(PsiElement e) {
        assert (e instanceof KtElement);
        return KotlinBundle.message(this.key, ElementSelectionUtilsKt.getExpressionShortText((KtElement)e));
    }

    protected boolean canExtractExpression(@NotNull KtExpression expression2, @NotNull KtElement parent2) {
        if (expression2 instanceof KtBlockExpression) {
            KtBlockExpression block2 = (KtBlockExpression)expression2;
            return block2.getStatements().size() <= 1 || parent2 instanceof KtBlockExpression;
        }
        return true;
    }

    protected Context createContext() {
        return new Context();
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        protected boolean isWhiteSpace(PsiElement element3) {
            return element3 instanceof PsiWhiteSpace;
        }

        public void extractFromBlock(@NotNull KtBlockExpression block2, @NotNull KtElement from) throws IncorrectOperationException {
            List expressions2 = block2.getStatements();
            if (!expressions2.isEmpty()) {
                this.extract((PsiElement)expressions2.get(0), (PsiElement)expressions2.get(expressions2.size() - 1), (PsiElement)from);
            }
        }

        public void extractFromExpression(@NotNull KtExpression expression2, @NotNull KtElement from) throws IncorrectOperationException {
            if (expression2 instanceof KtBlockExpression) {
                this.extractFromBlock((KtBlockExpression)expression2, from);
            } else {
                this.extract((PsiElement)expression2, (PsiElement)expression2, (PsiElement)from);
            }
        }

        public void replace(@NotNull KtElement originalElement, @NotNull KtElement newElement) {
            if (this.myIsEffective) {
                originalElement.replace((PsiElement)newElement);
            }
        }
    }
}

