/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

public class KotlinLambdaUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinLambdaUnwrapper(String key) {
        super(key);
    }

    private static KtElement getLambdaEnclosingElement(@NotNull KtLambdaExpression lambda2) {
        PsiElement parent2 = lambda2.getParent();
        if (parent2 instanceof KtValueArgument) {
            PsiElement parentParent;
            KtCallExpression callExpression2 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent2, KtCallExpression.class, (boolean)true);
            if (callExpression2 != null && (parentParent = callExpression2.getParent()) instanceof KtQualifiedExpression) {
                return (KtElement)parentParent;
            }
            return callExpression2;
        }
        if (parent2 instanceof KtCallExpression) {
            return (KtElement)parent2;
        }
        if (parent2 instanceof KtProperty && ((KtProperty)parent2).isLocal()) {
            return (KtElement)parent2;
        }
        return lambda2;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof KtLambdaExpression)) {
            return false;
        }
        KtLambdaExpression lambda2 = (KtLambdaExpression)e;
        KtBlockExpression body2 = lambda2.getBodyExpression();
        KtElement enclosingElement = KotlinLambdaUnwrapper.getLambdaEnclosingElement(lambda2);
        if (body2 == null || enclosingElement == null) {
            return false;
        }
        return this.canExtractExpression((KtExpression)body2, (KtElement)enclosingElement.getParent());
    }

    protected void doUnwrap(PsiElement element3, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
        KtLambdaExpression lambda2 = (KtLambdaExpression)element3;
        KtBlockExpression body2 = lambda2.getBodyExpression();
        KtElement enclosingExpression = KotlinLambdaUnwrapper.getLambdaEnclosingElement(lambda2);
        context2.extractFromBlock(body2, enclosingExpression);
        context2.delete((PsiElement)enclosingExpression);
    }

    public PsiElement collectAffectedElements(@NotNull PsiElement e, @NotNull List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return KotlinLambdaUnwrapper.getLambdaEnclosingElement((KtLambdaExpression)e);
    }
}

