/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

public abstract class KotlinComponentUnwrapper
extends KotlinUnwrapRemoveBase {
    public KotlinComponentUnwrapper(String key) {
        super(key);
    }

    @Nullable
    protected abstract KtExpression getExpressionToUnwrap(@NotNull KtElement var1);

    @NotNull
    protected KtElement getEnclosingElement(@NotNull KtElement element3) {
        return element3;
    }

    public boolean isApplicableTo(PsiElement e) {
        if (!(e instanceof KtElement)) {
            return false;
        }
        KtExpression expressionToUnwrap = this.getExpressionToUnwrap((KtElement)e);
        return expressionToUnwrap != null && this.canExtractExpression(expressionToUnwrap, (KtElement)this.getEnclosingElement((KtElement)e).getParent());
    }

    protected void doUnwrap(PsiElement element3, KotlinUnwrapRemoveBase.Context context2) throws IncorrectOperationException {
        KtElement targetElement = (KtElement)element3;
        KtExpression expressionToUnwrap = this.getExpressionToUnwrap(targetElement);
        assert (expressionToUnwrap != null);
        KtElement enclosingElement = this.getEnclosingElement(targetElement);
        context2.extractFromExpression(expressionToUnwrap, enclosingElement);
        context2.delete((PsiElement)enclosingElement);
    }
}

