/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelperKt;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;

public abstract class KotlinTrySurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    protected boolean isApplicableWhenUsedAsExpression() {
        return false;
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement container, @NotNull PsiElement[] statements2) {
        if ((statements2 = MoveDeclarationsOutHelperKt.move(container, statements2, true)).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor2, KotlinSurrounderUtils.SURROUND_WITH_ERROR());
            return null;
        }
        KtTryExpression tryExpression = (KtTryExpression)KtPsiFactoryKt.KtPsiFactory((Project)project).createExpression(this.getCodeTemplate());
        tryExpression = (KtTryExpression)container.addAfter((PsiElement)tryExpression, statements2[statements2.length - 1]);
        KtBlockExpression tryBlock = tryExpression.getTryBlock();
        KotlinSurrounderUtils.addStatementsInBlock(tryBlock, statements2);
        container.deleteChildRange(statements2[0], statements2[statements2.length - 1]);
        tryExpression = (KtTryExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)tryExpression);
        if (tryExpression == null) {
            return null;
        }
        return this.getTextRangeForCaret(tryExpression);
    }

    protected abstract String getCodeTemplate();

    @NotNull
    protected abstract TextRange getTextRangeForCaret(@NotNull KtTryExpression var1);

    public static TextRange getCatchTypeParameterTextRange(@NotNull KtTryExpression expression2) {
        KtParameter parameter2 = ((KtCatchClause)expression2.getCatchClauses().get(0)).getCatchParameter();
        assert (parameter2 != null) : "Catch parameter should exists for " + expression2.getText();
        KtTypeReference typeReference2 = parameter2.getTypeReference();
        assert (typeReference2 != null) : "Type reference for parameter should exists for " + expression2.getText();
        return typeReference2.getTextRange();
    }
}

