/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinTrySurrounderBase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtTryExpression;

public class KotlinTryFinallySurrounder
extends KotlinTrySurrounderBase {
    @Override
    protected String getCodeTemplate() {
        return "try { \n} finally {\nb\n}";
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement container, @NotNull PsiElement[] statements2) {
        TextRange textRange = super.surroundStatements(project, editor2, container, statements2);
        if (textRange == null) {
            return null;
        }
        editor2.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
        return new TextRange(textRange.getStartOffset(), textRange.getStartOffset());
    }

    @Override
    @NotNull
    protected TextRange getTextRangeForCaret(@NotNull KtTryExpression expression2) {
        KtFinallySection block2 = expression2.getFinallyBlock();
        assert (block2 != null) : "Finally block should exists for " + expression2.getText();
        KtExpression blockExpression2 = (KtExpression)block2.getFinalExpression().getStatements().get(0);
        return blockExpression2.getTextRange();
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }
}

