/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.MoveDeclarationsOutHelperKt;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinStatementsSurrounder;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinSurrounderUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

public abstract class KotlinIfSurrounderBase
extends KotlinStatementsSurrounder {
    @Override
    protected boolean isApplicableWhenUsedAsExpression() {
        return false;
    }

    @Override
    @Nullable
    protected TextRange surroundStatements(Project project, Editor editor2, PsiElement container, PsiElement[] statements2) {
        if ((statements2 = MoveDeclarationsOutHelperKt.move(container, statements2, this.isGenerateDefaultInitializers())).length == 0) {
            KotlinSurrounderUtils.showErrorHint(project, editor2, KotlinSurrounderUtils.SURROUND_WITH_ERROR());
            return null;
        }
        KtIfExpression ifExpression2 = (KtIfExpression)KtPsiFactoryKt.KtPsiFactory((Project)project).createExpression(this.getCodeTemplate());
        ifExpression2 = (KtIfExpression)container.addAfter((PsiElement)ifExpression2, statements2[statements2.length - 1]);
        KtBlockExpression thenBranch = (KtBlockExpression)ifExpression2.getThen();
        assert (thenBranch != null) : "Then branch should exist for created if expression: " + ifExpression2.getText();
        KotlinSurrounderUtils.addStatementsInBlock(thenBranch, statements2);
        container.deleteChildRange(statements2[0], statements2[statements2.length - 1]);
        ifExpression2 = (KtIfExpression)CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)ifExpression2);
        if (ifExpression2 == null) {
            return null;
        }
        return KotlinIfSurrounderBase.getRange(editor2, ifExpression2);
    }

    @NotNull
    public static TextRange getRange(Editor editor2, @NotNull KtIfExpression ifExpression2) {
        KtExpression condition2 = ifExpression2.getCondition();
        assert (condition2 != null) : "Condition should exists for created if expression: " + ifExpression2.getText();
        TextRange range2 = condition2.getTextRange();
        TextRange textRange = new TextRange(range2.getStartOffset(), range2.getStartOffset());
        editor2.getDocument().deleteString(range2.getStartOffset(), range2.getEndOffset());
        return textRange;
    }

    @NotNull
    protected abstract String getCodeTemplate();

    protected abstract boolean isGenerateDefaultInitializers();
}

