/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.idea.quickfix.AddWhenRemainingBranchesFix;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder;", "Lorg/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder;", "()V", "getTemplateDescription", "", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class KotlinWhenSurrounder
extends KotlinExpressionSurrounder {
    @NlsSafe
    @NotNull
    public String getTemplateDescription() {
        return "when (expr) {}";
    }

    @Override
    @NotNull
    protected TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        int n;
        KtWhenExpression whenExpression2;
        boolean hasRemainingBranches;
        PsiElement psiElement2;
        String template2 = "when(a) { \nb -> {}\n else -> {}\n}";
        KtExpression ktExpression = new KtPsiFactory((KtElement)expression2, false, 2, null).createExpression(template2);
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        Object it = (KtWhenExpression)ktExpression;
        boolean bl = false;
        KtExpression ktExpression2 = it.getSubjectExpression();
        if (ktExpression2 != null) {
            ktExpression2.replace((PsiElement)expression2);
        }
        PsiElement $this$replaced$iv = (PsiElement)expression2;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)it))) {
            psiElement2 = (PsiElement)it;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)it);
            if (result$iv instanceof KtWhenExpression) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
                }
                psiElement2 = (PsiElement)((KtWhenExpression)ktExpression3);
            }
        }
        if (hasRemainingBranches = AddWhenRemainingBranchesFix.Companion.isAvailable(whenExpression2 = (KtWhenExpression)psiElement2)) {
            AddWhenRemainingBranchesFix.Companion.addRemainingBranches$default(AddWhenRemainingBranchesFix.Companion, whenExpression2, false, 2, null);
            Object it2 = it = whenExpression2.getEntries();
            boolean bl2 = false;
            ((KtWhenEntry)CollectionsKt.first((List)it2)).delete();
            ((KtWhenEntry)CollectionsKt.last((List)it2)).delete();
        }
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)whenExpression2));
        KtWhenEntry firstEntry2 = (KtWhenEntry)CollectionsKt.first((List)whenExpression2.getEntries());
        if (hasRemainingBranches) {
            KtExpression ktExpression4 = firstEntry2.getExpression();
            n = ktExpression4 != null ? UtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression4)) : UtilsKt.getStartOffset((PsiElement)((PsiElement)firstEntry2));
        } else {
            TextRange conditionRange = ((KtWhenCondition)ArraysKt.first((Object[])firstEntry2.getConditions())).getTextRange();
            editor2.getDocument().deleteString(conditionRange.getStartOffset(), conditionRange.getEndOffset());
            n = conditionRange.getStartOffset();
        }
        int offset2 = n;
        return new TextRange(offset2, offset2);
    }
}

