/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

public class KotlinStringTemplateSurrounder
extends KotlinExpressionSurrounder {
    @NlsSafe
    public String getTemplateDescription() {
        return "\"${expr}\"";
    }

    @Override
    public boolean isApplicable(@NotNull KtExpression expression2) {
        return !(expression2 instanceof KtStringTemplateExpression) && super.isApplicable(expression2);
    }

    @Override
    @Nullable
    public TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        KtStringTemplateExpression stringTemplateExpression = (KtStringTemplateExpression)KtPsiFactoryKt.KtPsiFactory((PsiElement)expression2).createExpression(this.getCodeTemplate(expression2));
        KtStringTemplateEntry templateEntry = stringTemplateExpression.getEntries()[0];
        KtExpression innerExpression = templateEntry.getExpression();
        assert (innerExpression != null) : "KtExpression should exists for " + stringTemplateExpression;
        innerExpression.replace((PsiElement)expression2);
        expression2 = (KtExpression)expression2.replace((PsiElement)stringTemplateExpression);
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)expression2);
        int offset2 = expression2.getTextRange().getEndOffset();
        return new TextRange(offset2, offset2);
    }

    private String getCodeTemplate(KtExpression expression2) {
        if (expression2.getChildren().length > 0 || expression2 instanceof KtConstantExpression) {
            return "\"${a}\"";
        }
        return "\"$a\"";
    }
}

