/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.project.LibraryModificationTrackerKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J+\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0012H\u0082\bR\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "isLibraryArchiveRoot", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "processBulk", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "check", "Lkotlin/Function1;", "Companion", "kotlin.base.analysis"})
public final class LibraryModificationTracker
extends SimpleModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectFileIndex projectFileIndex;

    public LibraryModificationTracker(final @NotNull Project project) {
        KotlinPluginDisposable disposable = KotlinPluginDisposable.Companion.getInstance(project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)disposable);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                void $this$ifNotEmpty$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = events;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    VFileEvent p0 = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!LibraryModificationTrackerKt.access$isRelevantEvent(p0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Project project2 = project;
                object = this;
                boolean $i$f$ifNotEmpty = false;
                if (!$this$ifNotEmpty$iv.isEmpty()) {
                    List $this$after_u24lambda_u242 = (List)$this$ifNotEmpty$iv;
                    boolean bl = false;
                    List createEvents = $this$after_u24lambda_u242;
                    ApplicationManager.getApplication().invokeLater(() -> 1.after$lambda$2$lambda$1((LibraryModificationTracker)((Object)object), createEvents), project2.getDisposed());
                }
            }

            /*
             * WARNING - void declaration
             */
            public void before(@NotNull List<? extends VFileEvent> events) {
                LibraryModificationTracker libraryModificationTracker = this;
                LibraryModificationTracker libraryModificationTracker2 = this;
                boolean $i$f$processBulk = false;
                Iterable $this$forEach$iv$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    void this_$iv;
                    VirtualFile file$iv;
                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                    VirtualFile it = file$iv;
                    boolean bl2 = false;
                    if (!libraryModificationTracker2.projectFileIndex.isInLibraryClasses(it)) continue;
                    this_$iv.incModificationCount();
                    break;
                }
            }

            private static final void after$lambda$2$lambda$1(LibraryModificationTracker this$0, List $createEvents) {
                LibraryModificationTracker this_$iv = this$0;
                boolean $i$f$processBulk = false;
                Iterable $this$forEach$iv$iv = $createEvents;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    VirtualFile file$iv;
                    VFileEvent event$iv = (VFileEvent)element$iv$iv;
                    boolean bl = false;
                    if (!event$iv.isValid() || (file$iv = event$iv.getFile()) == null) continue;
                    VirtualFile it = file$iv;
                    boolean bl2 = false;
                    boolean bl3 = this$0.projectFileIndex.isInLibraryClasses(it) || this$0.isLibraryArchiveRoot(it);
                    if (!bl3) continue;
                    this_$iv.incModificationCount();
                    break;
                }
            }
        });
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                Collection collection = event.getChanges(LibraryEntity.class);
                if (collection.isEmpty()) {
                    boolean bl = false;
                    return;
                }
                this.incModificationCount();
            }
        });
        this.projectFileIndex = ProjectFileIndex.getInstance((Project)project);
    }

    private final void processBulk(List<? extends VFileEvent> events, Function1<? super VirtualFile, Boolean> check2) {
        boolean $i$f$processBulk = false;
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file2;
            VFileEvent event = (VFileEvent)element$iv;
            boolean bl = false;
            if (!event.isValid() || (file2 = event.getFile()) == null || !((Boolean)check2.invoke((Object)file2)).booleanValue()) continue;
            this.incModificationCount();
            return;
        }
    }

    private final boolean isLibraryArchiveRoot(VirtualFile virtualFile) {
        if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)ArchiveFileType.INSTANCE)) {
            return false;
        }
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getRootByLocal(virtualFile);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile archiveRoot = virtualFile2;
        return this.projectFileIndex.isInLibraryClasses(archiveRoot);
    }

    @JvmStatic
    @NotNull
    public static final LibraryModificationTracker getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LibraryModificationTracker getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LibraryModificationTracker> serviceClass$iv = LibraryModificationTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (LibraryModificationTracker)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

