/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\b2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J\r\u0010\u0012\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u0018J*\u0010\u001b\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J2\u0010\u001c\u001a\u00020\u001d*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J*\u0010\u001f\u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J*\u0010 \u001a\u00020\u000f*\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u001aH\u0002R0\u0010\u0005\u001a$\u0012\u0004\u0012\u00020\u0007\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\n0\bj\u0002`\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "implicitPackageCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackageData;", "analyzeImplicitPackagePrefixes", "sourceRoot", "checkDeletedFileInSourceRoot", "", "file", "checkNewFileInSourceRoot", "clear", "clear$kotlin_base_analysis", "getPrefix", "update", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "update$kotlin_base_analysis", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "addFile", "addPsiFile", "", "psiFile", "removeFile", "updateFile", "kotlin.base.analysis"})
public final class ImplicitPackagePrefixCache {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<VirtualFile, Map<FqName, List<VirtualFile>>> implicitPackageCache;

    public ImplicitPackagePrefixCache(@NotNull Project project) {
        this.project = project;
        this.implicitPackageCache = new ConcurrentHashMap();
    }

    @NotNull
    public final FqName getPrefix(@NotNull VirtualFile sourceRoot) {
        Map implicitPackageMap;
        FqName fqName2;
        ConcurrentMap $this$getOrPut$iv = this.implicitPackageCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(sourceRoot);
        if (object == null) {
            boolean bl = false;
            Map<FqName, List<VirtualFile>> default$iv = this.analyzeImplicitPackagePrefixes(sourceRoot);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(sourceRoot, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        if ((fqName2 = (FqName)CollectionsKt.singleOrNull((Iterable)(implicitPackageMap = (Map)object).keySet())) == null) {
            fqName2 = FqName.ROOT;
        }
        return fqName2;
    }

    public final void clear$kotlin_base_analysis() {
        this.implicitPackageCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FqName, List<VirtualFile>> analyzeImplicitPackagePrefixes(VirtualFile sourceRoot) {
        void $this$filterTo$iv$iv;
        Map result2 = new LinkedHashMap();
        VirtualFile[] $this$filter$iv = sourceRoot.getChildren();
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void p0 = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!FileUtils.isKotlinFileType((VirtualFile)p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles2 = (List)destination$iv$iv;
        for (VirtualFile ktFile : ktFiles2) {
            this.addFile(result2, ktFile);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addFile(Map<FqName, List<VirtualFile>> $this$addFile, VirtualFile ktFile) {
        Map<FqName, List<VirtualFile>> map2 = $this$addFile;
        synchronized (map2) {
            boolean bl = false;
            PsiFile psiFile2 = PsiManager.getInstance((Project)this.project).findFile(ktFile);
            KtFile ktFile2 = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile2 == null) {
                return;
            }
            KtFile psiFile3 = ktFile2;
            boolean bl2 = this.addPsiFile($this$addFile, psiFile3, ktFile);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addPsiFile(Map<FqName, List<VirtualFile>> $this$addPsiFile, KtFile psiFile2, VirtualFile ktFile) {
        Object object;
        void $this$getOrPut$iv;
        Map<FqName, List<VirtualFile>> map2 = $this$addPsiFile;
        FqName key$iv = psiFile2.getPackageFqName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((List)object).add(ktFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeFile(Map<FqName, List<VirtualFile>> $this$removeFile, VirtualFile file2) {
        Map<FqName, List<VirtualFile>> map2 = $this$removeFile;
        synchronized (map2) {
            boolean bl = false;
            for (Map.Entry<FqName, List<VirtualFile>> entry : $this$removeFile.entrySet()) {
                FqName key = entry.getKey();
                List<VirtualFile> value2 = entry.getValue();
                if (!value2.remove(file2)) continue;
                if (!value2.isEmpty()) break;
                $this$removeFile.remove(key);
                break;
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFile(Map<FqName, List<VirtualFile>> $this$updateFile, KtFile file2) {
        Map<FqName, List<VirtualFile>> map2 = $this$updateFile;
        synchronized (map2) {
            boolean bl = false;
            this.removeFile($this$updateFile, file2.getVirtualFile());
            boolean bl2 = this.addPsiFile($this$updateFile, file2, file2.getVirtualFile());
        }
    }

    public final void update$kotlin_base_analysis(@NotNull VFileEvent event) {
        block3: {
            VFileEvent vFileEvent;
            block5: {
                block4: {
                    block2: {
                        vFileEvent = event;
                        if (!(vFileEvent instanceof VFileCreateEvent)) break block2;
                        this.checkNewFileInSourceRoot(((VFileCreateEvent)event).getFile());
                        break block3;
                    }
                    if (!(vFileEvent instanceof VFileDeleteEvent)) break block4;
                    this.checkDeletedFileInSourceRoot(((VFileDeleteEvent)event).getFile());
                    break block3;
                }
                if (!(vFileEvent instanceof VFileCopyEvent)) break block5;
                VirtualFile newParent = ((VFileCopyEvent)event).getNewParent();
                if (!newParent.isValid()) break block3;
                this.checkNewFileInSourceRoot(newParent.findChild(((VFileCopyEvent)event).getNewChildName()));
                break block3;
            }
            if (!(vFileEvent instanceof VFileMoveEvent)) break block3;
            this.checkNewFileInSourceRoot(((VFileMoveEvent)event).getFile());
            if (Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(((VFileMoveEvent)event).getOldParent(), this.project), (Object)((VFileMoveEvent)event).getOldParent())) {
                Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(((VFileMoveEvent)event).getOldParent());
                if (map2 != null) {
                    this.removeFile(map2, ((VFileMoveEvent)event).getFile());
                }
            }
        }
    }

    private final void checkNewFileInSourceRoot(VirtualFile file2) {
        block2: {
            if (file2 == null) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(file2, this.project), (Object)file2.getParent())) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(file2.getParent());
            if (map2 != null) {
                this.addFile(map2, file2);
            }
        }
    }

    private final void checkDeletedFileInSourceRoot(VirtualFile file2) {
        block2: {
            VirtualFile directory;
            VirtualFile virtualFile = file2;
            Object object = directory = virtualFile != null ? virtualFile.getParent() : null;
            if (directory == null || !directory.isValid()) {
                return;
            }
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot(directory, this.project), (Object)directory)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(directory);
            if (map2 != null) {
                this.removeFile(map2, file2);
            }
        }
    }

    public final void update$kotlin_base_analysis(@NotNull KtFile ktFile) {
        block2: {
            VirtualFile virtualFile = ktFile.getVirtualFile();
            if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
                return;
            }
            VirtualFile parent2 = virtualFile;
            if (!Intrinsics.areEqual((Object)ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)ktFile), (Object)parent2)) break block2;
            Map<FqName, List<VirtualFile>> map2 = this.implicitPackageCache.get(parent2);
            if (map2 != null) {
                this.updateFile(map2, ktFile);
            }
        }
    }
}

