/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util.caching;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 ?*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0002?@B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J8\u0010\u0019\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u001a\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0004J\u0015\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u001fJ)\u0010 \u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u001fJ\b\u0010%\u001a\u00020\u0018H\u0016J0\u0010&\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010(H\u0014J)\u0010)\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\u001e\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\u001c\u0010*\u001a\u00020\u00182\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J0\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0014J\u0016\u0010.\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00028\u0000H\u00a6\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u0018H\u0004J@\u00101\u001a\u00020\u00182\u0018\u00102\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u001b2\u001c\b\u0002\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0004J4\u00103\u001a\u00020\u00182\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u001c\b\u0002\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0004J:\u00104\u001a\b\u0012\u0004\u0012\u00028\u00010,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u001c\b\u0002\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b\u0018\u00010\u001bH\u0004J\u001c\u00105\u001a\u00020\u00182\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000107H\u0004J\b\u00108\u001a\u00020\u0018H$J3\u00109\u001a\u0002H:\"\u0004\b\u0002\u0010:2\u001e\u0010;\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0004\u0012\u0002H:0<H$\u00a2\u0006\u0002\u0010=J\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00010,R\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache;", "Key", "", "Value", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cleanOnLowMemory", "", "(Lcom/intellij/openapi/project/Project;Z)V", "cache", "", "getCache", "()Ljava/util/Map;", "invalidationStamp", "Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "additionalEntitiesCheck", "", "checkEntities", "validityCondition", "Lkotlin/Function2;", "checkEntitiesIfRequired", "checkKeyAndDisposeIllegalEntry", "key", "(Ljava/lang/Object;)V", "checkKeyConsistency", "(Ljava/util/Map;Ljava/lang/Object;)V", "checkKeyValidity", "checkValueValidity", "value", "dispose", "disposeEntry", "entry", "", "disposeIllegalEntry", "doInvalidate", "doInvalidateKeysAndGetOutdatedValues", "", "keys", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "invalidate", "invalidateEntries", "condition", "invalidateKeys", "invalidateKeysAndGetOutdatedValues", "putAll", "map", "", "subscribe", "useCache", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "values", "Companion", "InvalidationStamp", "kotlin.base.util"})
public abstract class FineGrainedEntityCache<Key, Value>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final InvalidationStamp invalidationStamp;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Function2<Object, Object, Boolean> CHECK_ALL = Companion.CHECK_ALL.1.INSTANCE;
    @NotNull
    private static final Lazy<Boolean> isValidityChecksEnabled$delegate = LazyKt.lazy((Function0)Companion.isValidityChecksEnabled.2.INSTANCE);

    public FineGrainedEntityCache(@NotNull Project project, boolean cleanOnLowMemory) {
        this.project = project;
        this.invalidationStamp = new InvalidationStamp();
        this.logger = Logger.getInstance(this.getClass());
        if (cleanOnLowMemory) {
            LowMemoryWatcher.register(this::invalidate, (Disposable)this);
        }
        this.subscribe();
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected abstract Map<Key, Value> getCache();

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected abstract <T> T useCache(@NotNull Function1<? super Map<Key, Value>, ? extends T> var1);

    public void dispose() {
        this.invalidate();
    }

    @NotNull
    public abstract Value get(@NotNull Key var1);

    @NotNull
    public final Collection<Value> values() {
        return (Collection)this.useCache(values.1.INSTANCE);
    }

    protected final void checkEntitiesIfRequired(@NotNull Map<Key, Value> cache2) {
        if (Companion.isValidityChecksEnabled() && this.invalidationStamp.isCheckRequired()) {
            this.checkEntities(cache2, CHECK_ALL);
        }
    }

    protected final void checkKeyAndDisposeIllegalEntry(@NotNull Key key) {
        if (Companion.isValidityChecksEnabled()) {
            try {
                this.checkKeyValidity(key);
            }
            catch (Throwable e) {
                this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(this, key){
                    final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
                    final /* synthetic */ Key $key;
                    {
                        this.this$0 = $receiver;
                        this.$key = $key;
                        super(1);
                    }

                    public final void invoke(@NotNull Map<Key, Value> cache2) {
                        this.this$0.disposeIllegalEntry(cache2, this.$key);
                    }
                });
                this.logger.error(e);
            }
        }
    }

    protected void disposeIllegalEntry(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        cache2.remove(key);
    }

    protected final void putAll(@NotNull Map<Key, ? extends Value> map2) {
        if (Companion.isValidityChecksEnabled()) {
            for (Map.Entry<Key, Value> entry : map2.entrySet()) {
                Key key = entry.getKey();
                Value value2 = entry.getValue();
                this.checkKeyValidity(key);
                this.checkValueValidity(value2);
            }
        }
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(map2){
            final /* synthetic */ Map<Key, Value> $map;
            {
                this.$map = $map;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                for (Map.Entry<Key, Value> entry : this.$map.entrySet()) {
                    Key key = entry.getKey();
                    Value value2 = entry.getValue();
                    cache2.putIfAbsent(key, value2);
                }
            }
        });
    }

    protected final void invalidate() {
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(this){
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                this.this$0.doInvalidate(cache2);
            }
        });
    }

    protected void doInvalidate(@NotNull Map<Key, Value> cache2) {
        cache2.clear();
    }

    @NotNull
    protected final Collection<Value> invalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        return (Collection)this.useCache((Function1)new Function1<Map<Key, Value>, Collection<? extends Value>>(this, keys, validityCondition){
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Collection<Key> $keys;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.this$0 = $receiver;
                this.$keys = $keys;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            @NotNull
            public final Collection<Value> invoke(@NotNull Map<Key, Value> cache2) {
                Collection<Value> collection = this.this$0.doInvalidateKeysAndGetOutdatedValues(this.$keys, cache2);
                FineGrainedEntityCache<Key, Value> fineGrainedEntityCache = this.this$0;
                Function2<Key, Value, Boolean> function2 = this.$validityCondition;
                Collection<Value> it = collection;
                boolean bl = false;
                FineGrainedEntityCache.access$getInvalidationStamp$p(fineGrainedEntityCache).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(fineGrainedEntityCache, cache2, function2);
                return collection;
            }
        });
    }

    public static /* synthetic */ Collection invalidateKeysAndGetOutdatedValues$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeysAndGetOutdatedValues");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        return fineGrainedEntityCache.invalidateKeysAndGetOutdatedValues(collection, function2);
    }

    @NotNull
    protected Collection<Value> doInvalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends Key> keys, @NotNull Map<Key, Value> cache2) {
        List list2;
        List $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Key key : keys) {
            Value p0;
            if (cache2.remove(key) == null) continue;
            boolean bl2 = false;
            $this$doInvalidateKeysAndGetOutdatedValues_u24lambda_u240.add(p0);
        }
        return CollectionsKt.build((List)list2);
    }

    protected final void invalidateKeys(@NotNull Collection<? extends Key> keys, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(keys, this, validityCondition){
            final /* synthetic */ Collection<Key> $keys;
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.$keys = $keys;
                this.this$0 = $receiver;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                for (Key key : this.$keys) {
                    cache2.remove(key);
                }
                FineGrainedEntityCache.access$getInvalidationStamp$p(this.this$0).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(this.this$0, cache2, this.$validityCondition);
            }
        });
    }

    public static /* synthetic */ void invalidateKeys$default(FineGrainedEntityCache fineGrainedEntityCache, Collection collection, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateKeys");
        }
        if ((n & 2) != 0) {
            function2 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateKeys(collection, function2);
    }

    protected final void invalidateEntries(@NotNull Function2<? super Key, ? super Value, Boolean> condition2, @Nullable Function2<? super Key, ? super Value, Boolean> validityCondition) {
        this.useCache((Function1)new Function1<Map<Key, Value>, Unit>(condition2, this, validityCondition){
            final /* synthetic */ Function2<Key, Value, Boolean> $condition;
            final /* synthetic */ FineGrainedEntityCache<Key, Value> this$0;
            final /* synthetic */ Function2<Key, Value, Boolean> $validityCondition;
            {
                this.$condition = $condition;
                this.this$0 = $receiver;
                this.$validityCondition = $validityCondition;
                super(1);
            }

            public final void invoke(@NotNull Map<Key, Value> cache2) {
                Iterator<Map.Entry<Key, Value>> iterator = cache2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Value value2;
                    Map.Entry<Key, Value> entry = iterator.next();
                    Key key = entry.getKey();
                    if (!((Boolean)this.$condition.invoke(key, value2 = entry.getValue())).booleanValue()) continue;
                    iterator.remove();
                }
                FineGrainedEntityCache.access$getInvalidationStamp$p(this.this$0).incInvalidation();
                FineGrainedEntityCache.access$checkEntities(this.this$0, cache2, this.$validityCondition);
            }
        });
    }

    public static /* synthetic */ void invalidateEntries$default(FineGrainedEntityCache fineGrainedEntityCache, Function2 function2, Function2 function22, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: invalidateEntries");
        }
        if ((n & 2) != 0) {
            function22 = CHECK_ALL;
        }
        fineGrainedEntityCache.invalidateEntries(function2, function22);
    }

    private final void checkEntities(Map<Key, Value> cache2, Function2<? super Key, ? super Value, Boolean> validityCondition) {
        if (Companion.isValidityChecksEnabled() && validityCondition != null) {
            boolean allEntriesChecked = true;
            Iterator<Map.Entry<Key, Value>> iterator = cache2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Key, Value> entry = iterator.next();
                if (((Boolean)validityCondition.invoke(entry.getKey(), entry.getValue())).booleanValue()) {
                    try {
                        this.checkKeyConsistency(cache2, entry.getKey());
                        this.checkValueValidity(entry.getValue());
                    }
                    catch (Throwable e) {
                        iterator.remove();
                        this.disposeEntry(cache2, entry);
                        this.logger.error(e);
                    }
                    continue;
                }
                allEntriesChecked = false;
            }
            this.additionalEntitiesCheck(cache2);
            if (allEntriesChecked) {
                this.invalidationStamp.reset();
            }
        }
    }

    protected void additionalEntitiesCheck(@NotNull Map<Key, Value> cache2) {
    }

    protected void disposeEntry(@NotNull Map<Key, Value> cache2, @NotNull Map.Entry<Key, Value> entry) {
    }

    protected abstract void subscribe();

    protected abstract void checkKeyValidity(@NotNull Key var1);

    protected void checkKeyConsistency(@NotNull Map<Key, Value> cache2, @NotNull Key key) {
        this.checkKeyValidity(key);
    }

    protected void checkValueValidity(@NotNull Value value2) {
    }

    public static final /* synthetic */ InvalidationStamp access$getInvalidationStamp$p(FineGrainedEntityCache $this) {
        return $this.invalidationStamp;
    }

    public static final /* synthetic */ void access$checkEntities(FineGrainedEntityCache $this, Map cache2, Function2 validityCondition) {
        $this.checkEntities(cache2, validityCondition);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$InvalidationStamp;", "", "()V", "count", "", "currentCount", "incInvalidation", "", "isCheckRequired", "", "reset", "kotlin.base.util"})
    private static final class InvalidationStamp {
        private int currentCount;
        private int count;

        public final boolean isCheckRequired() {
            return this.currentCount > this.count;
        }

        public final void incInvalidation() {
            int n = this.currentCount;
            this.currentCount = n + 1;
        }

        public final void reset() {
            this.count = this.currentCount;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/base/util/caching/FineGrainedEntityCache$Companion;", "", "()V", "CHECK_ALL", "Lkotlin/Function2;", "", "getCHECK_ALL", "()Lkotlin/jvm/functions/Function2;", "isValidityChecksEnabled", "()Z", "isValidityChecksEnabled$delegate", "Lkotlin/Lazy;", "kotlin.base.util"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function2<Object, Object, Boolean> getCHECK_ALL() {
            return CHECK_ALL;
        }

        public final boolean isValidityChecksEnabled() {
            Lazy lazy = isValidityChecksEnabled$delegate;
            return (Boolean)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

