/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0007\u001a#\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a+\u0010\r\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0012\u001a\u0015\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0086\u0002\u001a\r\u0010\u0014\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\u0017\u0010\u0017\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000b\u001a\u0012\u0010\u0017\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b\u001a\u000f\u0010\u001a\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0018*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u001b\u001a\u00020\u0004*\u00020\u0007\u00a8\u0006\u001c"}, d2={"allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "and", "Lcom/intellij/psi/search/SearchScope;", "otherScope", "codeUsageScope", "Lcom/intellij/psi/PsiElement;", "everythingScopeExcludeFileTypes", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/GlobalSearchScope;", "excludeFileTypes", "project", "(Lcom/intellij/psi/search/SearchScope;Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/SearchScope;", "excludeKotlinSources", "fileScope", "Lcom/intellij/psi/PsiFile;", "minus", "not", "or", "projectScope", "restrictByFileType", "Lorg/jetbrains/annotations/NotNull;", "fileType", "restrictToKotlinSources", "useScope", "kotlin.base.util"})
@JvmName(name="KotlinScopeUtils")
public final class KotlinScopeUtils {
    @NotNull
    public static final SearchScope and(@NotNull SearchScope $this$and, @NotNull SearchScope otherScope) {
        return $this$and.intersectWith(otherScope);
    }

    @NotNull
    public static final SearchScope or(@NotNull SearchScope $this$or, @NotNull SearchScope otherScope) {
        return $this$or.union(otherScope);
    }

    @NotNull
    public static final GlobalSearchScope or(@NotNull GlobalSearchScope $this$or, @NotNull SearchScope otherScope) {
        return $this$or.union(otherScope);
    }

    @NotNull
    public static final SearchScope minus(@NotNull SearchScope $this$minus, @NotNull GlobalSearchScope otherScope) {
        return KotlinScopeUtils.and($this$minus, (SearchScope)KotlinScopeUtils.not(otherScope));
    }

    @NotNull
    public static final GlobalSearchScope not(@NotNull GlobalSearchScope $this$not) {
        return GlobalSearchScope.notScope((GlobalSearchScope)$this$not);
    }

    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        return GlobalSearchScope.allScope((Project)$this$allScope);
    }

    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        return GlobalSearchScope.projectScope((Project)$this$projectScope);
    }

    @NotNull
    public static final GlobalSearchScope fileScope(@NotNull PsiFile $this$fileScope) {
        return GlobalSearchScope.fileScope((PsiFile)$this$fileScope);
    }

    @NotNull
    public static final SearchScope useScope(@NotNull PsiElement $this$useScope) {
        return PsiSearchHelper.getInstance((Project)$this$useScope.getProject()).getUseScope($this$useScope);
    }

    @NotNull
    public static final SearchScope codeUsageScope(@NotNull PsiElement $this$codeUsageScope) {
        return PsiSearchHelper.getInstance((Project)$this$codeUsageScope.getProject()).getCodeUsageScope($this$codeUsageScope);
    }

    @NotNull
    public static final GlobalSearchScope everythingScopeExcludeFileTypes(@NotNull Project $this$everythingScopeExcludeFileTypes, FileType ... fileTypes) {
        return KotlinScopeUtils.not(GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.everythingScope((Project)$this$everythingScopeExcludeFileTypes), (FileType[])Arrays.copyOf(fileTypes, fileTypes.length)));
    }

    @NotNull
    public static final GlobalSearchScope restrictByFileType(@NotNull GlobalSearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        FileType[] fileTypeArray = new FileType[]{fileType};
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)$this$restrictByFileType, (FileType[])fileTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope restrictByFileType(@NotNull SearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        SearchScope searchScope2;
        SearchScope searchScope3 = $this$restrictByFileType;
        if (searchScope3 instanceof GlobalSearchScope) {
            searchScope2 = (SearchScope)KotlinScopeUtils.restrictByFileType((GlobalSearchScope)$this$restrictByFileType, fileType);
        } else if (searchScope3 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            PsiElement[] $this$filter$iv = ((LocalSearchScope)$this$restrictByFileType).getScope();
            boolean $i$f$filter = false;
            PsiElement[] psiElementArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContainingFile().getFileType(), (Object)fileType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List elements2 = (List)destination$iv$iv;
            int n2 = elements2.size();
            if (n2 == 0) {
                localSearchScope = LocalSearchScope.EMPTY;
            } else if (n2 == ((LocalSearchScope)$this$restrictByFileType).getScope().length) {
                localSearchScope = (LocalSearchScope)$this$restrictByFileType;
            } else {
                Collection $this$toTypedArray$iv = elements2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalSearchScope localSearchScope2 = new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0]));
                localSearchScope = localSearchScope2;
            }
            searchScope2 = (SearchScope)localSearchScope;
        } else {
            searchScope2 = $this$restrictByFileType;
        }
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope restrictToKotlinSources(@NotNull GlobalSearchScope $this$restrictToKotlinSources) {
        return KotlinScopeUtils.restrictByFileType($this$restrictToKotlinSources, (FileType)KotlinFileType.INSTANCE);
    }

    @NotNull
    public static final SearchScope restrictToKotlinSources(@NotNull SearchScope $this$restrictToKotlinSources) {
        return KotlinScopeUtils.restrictByFileType($this$restrictToKotlinSources, (FileType)KotlinFileType.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope excludeFileTypes(@NotNull SearchScope $this$excludeFileTypes, @NotNull Project project, FileType ... fileTypes) {
        SearchScope searchScope2;
        if ($this$excludeFileTypes instanceof GlobalSearchScope) {
            searchScope2 = (SearchScope)((GlobalSearchScope)$this$excludeFileTypes).intersectWith(KotlinScopeUtils.everythingScopeExcludeFileTypes(project, Arrays.copyOf(fileTypes, fileTypes.length)));
        } else {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNull((Object)$this$excludeFileTypes, (String)"null cannot be cast to non-null type com.intellij.psi.search.LocalSearchScope");
            LocalSearchScope cfr_ignored_0 = (LocalSearchScope)$this$excludeFileTypes;
            PsiElement[] $this$filter$iv = ((LocalSearchScope)$this$excludeFileTypes).getScope();
            boolean $i$f$filter = false;
            PsiElement[] psiElementArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                if (!(!ArraysKt.contains((Object[])fileTypes, (Object)it.getContainingFile().getFileType()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredElements = (List)destination$iv$iv;
            if (!((Collection)filteredElements).isEmpty()) {
                Collection $this$toTypedArray$iv = filteredElements;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalSearchScope localSearchScope2 = new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0]));
                localSearchScope = localSearchScope2;
            } else {
                localSearchScope = LocalSearchScope.EMPTY;
            }
            searchScope2 = (SearchScope)localSearchScope;
        }
        return searchScope2;
    }

    @NotNull
    public static final SearchScope excludeKotlinSources(@NotNull SearchScope $this$excludeKotlinSources, @NotNull Project project) {
        FileType[] fileTypeArray = new FileType[]{(FileType)KotlinFileType.INSTANCE};
        return KotlinScopeUtils.excludeFileTypes($this$excludeKotlinSources, project, fileTypeArray);
    }
}

