/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.scripting.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LanguageSettingsOwner;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.scripting.ScriptingTargetPlatformDetector;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptSearchScope;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u00103\u001a\u00020\u0004H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J'\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000108H\u0016J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/base/scripting/projectStructure/ScriptModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LanguageSettingsOwner;", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleContentScope", "getModuleContentScope", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScriptFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "targetPlatformVersion", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "getTargetPlatformVersion", "()Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "component1", "component2", "component3", "copy", "dependencies", "", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.base.scripting"})
public final class ScriptModuleInfo
implements IdeaModuleInfo,
LanguageSettingsOwner {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile scriptFile;
    @NotNull
    private final ScriptDefinition scriptDefinition;
    @NotNull
    private final Name name;

    public ScriptModuleInfo(@NotNull Project project, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        this.project = project;
        this.scriptFile = scriptFile;
        this.scriptDefinition = scriptDefinition;
        this.name = Name.special((String)("<script " + this.scriptFile.getName() + " " + this.scriptDefinition.getName() + ">"));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getScriptFile() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition getScriptDefinition() {
        return this.scriptDefinition;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.OTHER;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[]{this.scriptFile.getPresentableName(), this.scriptDefinition.getName()};
        return KotlinBaseProjectStructureBundle.message("script.0.1", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        return GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)this.scriptFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return (GlobalSearchScope)new KotlinScriptSearchScope(this.getProject(), this.getContentScope());
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        Object object;
        block2: {
            object = new IdeaModuleInfo[]{this};
            Object $this$dependencies_u24lambda_u243 = object = SetsKt.mutableSetOf((Object[])object);
            boolean bl = false;
            List<Module> scriptDependentModules = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedModules(this.scriptFile, this.getProject());
            Iterable $this$forEach$iv = scriptDependentModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl2 = false;
                $this$dependencies_u24lambda_u243.addAll((Collection)KotlinProjectStructureUtils.getSourceModuleInfos(it));
            }
            List<Library> scriptDependentLibraries = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedLibraries(this.scriptFile, this.getProject());
            LibraryInfoCache libraryInfoCache2 = LibraryInfoCache.Companion.getInstance(this.getProject());
            Iterable $this$forEach$iv2 = scriptDependentLibraries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Library it = (Library)element$iv;
                boolean bl3 = false;
                $this$dependencies_u24lambda_u243.addAll((Collection)libraryInfoCache2.get(it));
            }
            ScriptDependenciesInfo.ForFile dependenciesInfo = new ScriptDependenciesInfo.ForFile(this.getProject(), this.scriptFile, this.scriptDefinition);
            $this$dependencies_u24lambda_u243.add(dependenciesInfo);
            Sdk sdk2 = dependenciesInfo.getSdk();
            if (sdk2 == null) break block2;
            Sdk it = sdk2;
            boolean bl4 = false;
            $this$dependencies_u24lambda_u243.add(new SdkInfo(this.getProject(), it));
        }
        return CollectionsKt.toList((Iterable)((Iterable)object));
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return ScriptingTargetPlatformDetector.INSTANCE.getPlatform(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return ScriptingTargetPlatformDetector.INSTANCE.getLanguageVersionSettings(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @Override
    @NotNull
    public TargetPlatformVersion getTargetPlatformVersion() {
        return ScriptingTargetPlatformDetector.INSTANCE.getTargetPlatformVersion(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @NotNull
    public final VirtualFile component2() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition component3() {
        return this.scriptDefinition;
    }

    @NotNull
    public final ScriptModuleInfo copy(@NotNull Project project, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        return new ScriptModuleInfo(project, scriptFile, scriptDefinition);
    }

    public static /* synthetic */ ScriptModuleInfo copy$default(ScriptModuleInfo scriptModuleInfo, Project project, VirtualFile virtualFile, ScriptDefinition scriptDefinition, int n, Object object) {
        if ((n & 1) != 0) {
            project = scriptModuleInfo.getProject();
        }
        if ((n & 2) != 0) {
            virtualFile = scriptModuleInfo.scriptFile;
        }
        if ((n & 4) != 0) {
            scriptDefinition = scriptModuleInfo.scriptDefinition;
        }
        return scriptModuleInfo.copy(project, virtualFile, scriptDefinition);
    }

    @NotNull
    public String toString() {
        return "ScriptModuleInfo(project=" + this.getProject() + ", scriptFile=" + this.scriptFile + ", scriptDefinition=" + this.scriptDefinition + ")";
    }

    public int hashCode() {
        int result2 = this.getProject().hashCode();
        result2 = result2 * 31 + this.scriptFile.hashCode();
        result2 = result2 * 31 + this.scriptDefinition.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptModuleInfo)) {
            return false;
        }
        ScriptModuleInfo scriptModuleInfo = (ScriptModuleInfo)other;
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)scriptModuleInfo.getProject())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scriptFile, (Object)scriptModuleInfo.scriptFile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.scriptDefinition), (Object)((Object)scriptModuleInfo.scriptDefinition));
    }
}

