/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013\u001a\u001d\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013\u001a\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001aI\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u001b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u00180\u001c\"\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u0018H\u0007\u00a2\u0006\u0002\u0010\u001d\u001a/\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010\u001a*\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u00180\u001c2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010 \u001a\n\u0010!\u001a\u00020\"*\u00020#\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020&\u001a\n\u0010'\u001a\u00020\u001f*\u00020(\u001a\n\u0010)\u001a\u00020\u001f*\u00020*\u001a\u0014\u0010+\u001a\u00020\u001f*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\n\u0010,\u001a\u00020&*\u00020&\u001a\f\u0010-\u001a\u0004\u0018\u00010&*\u00020.\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006/"}, d2={"callableIdIfNotLocal", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getCallableIdIfNotLocal", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)Lorg/jetbrains/kotlin/name/CallableId;", "classIdIfNonLocal", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getClassIdIfNonLocal", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)Lorg/jetbrains/kotlin/name/ClassId;", "getElementAtOffsetIgnoreWhitespaceAfter", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "getElementAtOffsetIgnoreWhitespaceBefore", "getEndLineOffset", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "getStartLineOffset", "getTopParentWithEndOffset", "element", "stopAt", "Ljava/lang/Class;", "getTopmostElementAtOffset", "T", "classes", "", "(Lcom/intellij/psi/PsiElement;I[Ljava/lang/Class;)Ljava/lang/Object;", "anyIsInstance", "", "([Ljava/lang/Class;Lcom/intellij/psi/PsiElement;)Z", "deleteBody", "", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getCallChain", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isConstructorDeclaredProperty", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "isExpectDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isSuitableTopmostElementAtOffset", "safeDeparenthesize", "singleExpressionBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "kotlin.base.psi"})
@JvmName(name="KotlinPsiUtils")
public final class KotlinPsiUtils {
    @Nullable
    public static final ClassId getClassIdIfNonLocal(@NotNull KtClassOrObject $this$classIdIfNonLocal) {
        boolean bl;
        List classesNames2;
        FqName packageName2;
        block5: {
            if (KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)$this$classIdIfNonLocal))) {
                return null;
            }
            packageName2 = $this$classIdIfNonLocal.getContainingKtFile().getPackageFqName();
            PsiElement $this$parentsOfType_u24default$iv = (PsiElement)$this$classIdIfNonLocal;
            boolean withSelf$iv = true;
            boolean $i$f$parentsOfType = false;
            classesNames2 = CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtDeclaration.class, (boolean)withSelf$iv), (Function1)classIdIfNonLocal.classesNames.1.INSTANCE)));
            Iterable $this$any$iv = classesNames2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return new ClassId(packageName2, new FqName(CollectionsKt.joinToString$default((Iterable)classesNames2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null)), false);
    }

    @Nullable
    public static final CallableId getCallableIdIfNotLocal(@NotNull KtCallableDeclaration $this$callableIdIfNotLocal) {
        Name name2 = $this$callableIdIfNotLocal.getNameAsName();
        if (name2 == null) {
            return null;
        }
        Name callableName = name2;
        if (KtPsiUtilKt.isTopLevelInFileOrScript((PsiElement)((PsiElement)$this$callableIdIfNotLocal))) {
            return new CallableId($this$callableIdIfNotLocal.getContainingKtFile().getPackageFqName(), callableName);
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$callableIdIfNotLocal));
        if (ktClassOrObject == null || (ktClassOrObject = KotlinPsiUtils.getClassIdIfNonLocal(ktClassOrObject)) == null) {
            return null;
        }
        KtClassOrObject classId = ktClassOrObject;
        return new CallableId((ClassId)classId, callableName);
    }

    @Nullable
    public static final PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file2, int offset2) {
        PsiElement element3 = file2.findElementAt(offset2);
        if (element3 instanceof PsiWhiteSpace) {
            return file2.findElementAt(((PsiWhiteSpace)element3).getTextRange().getEndOffset());
        }
        return element3;
    }

    @Nullable
    public static final PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file2, int offset2) {
        PsiElement element3 = file2.findElementAt(offset2 - 1);
        if (element3 instanceof PsiWhiteSpace) {
            return file2.findElementAt(((PsiWhiteSpace)element3).getTextRange().getStartOffset() - 1);
        }
        return element3;
    }

    @Nullable
    public static final Integer getStartLineOffset(@NotNull PsiFile file2, int line) {
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (line >= document2.getLineCount()) {
            return null;
        }
        int lineStartOffset = document2.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document2.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static final Integer getEndLineOffset(@NotNull PsiFile file2, int line) {
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (line >= document2.getLineCount()) {
            return null;
        }
        int lineStartOffset = document2.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document2.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @NotNull
    public static final PsiElement getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2) {
        PsiElement parent2;
        PsiElement node2 = element3;
        while ((parent2 = node2.getParent()) != null && KotlinPsiUtils.isSuitableTopmostElementAtOffset(parent2, offset2)) {
            node2 = parent2;
        }
        return node2;
    }

    @NotNull
    public static final PsiElement getTopParentWithEndOffset(@NotNull PsiElement element3, @NotNull Class<?> stopAt) {
        PsiElement parent2;
        PsiElement node2 = element3;
        int endOffset2 = node2.getTextOffset() + node2.getTextLength();
        while (node2.getParent() != null && parent2.getTextOffset() + parent2.getTextLength() == endOffset2 && !stopAt.isInstance(node2 = parent2)) {
        }
        return node2;
    }

    @SafeVarargs
    @Nullable
    public static final <T> T getTopmostElementAtOffset(@NotNull PsiElement element3, int offset2, Class<? extends T> ... classes2) {
        PsiElement parent2;
        PsiElement psiElement2;
        PsiElement node2 = element3;
        PsiElement lastElementOfType = null;
        if (KotlinPsiUtils.anyIsInstance(classes2, node2) && (psiElement2 = node2) == null) {
            psiElement2 = lastElementOfType = null;
        }
        while ((parent2 = node2.getParent()) != null && KotlinPsiUtils.isSuitableTopmostElementAtOffset(parent2, offset2)) {
            if (KotlinPsiUtils.anyIsInstance(classes2, parent2)) {
                lastElementOfType = parent2 instanceof Object ? parent2 : null;
            }
            node2 = parent2;
        }
        return (T)lastElementOfType;
    }

    private static final <T> boolean anyIsInstance(Class<? extends T>[] $this$anyIsInstance, PsiElement element3) {
        boolean bl;
        block1: {
            Class<? extends T>[] $this$any$iv = $this$anyIsInstance;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                Class<T> element$iv;
                Class<T> it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!it.isInstance(element3)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean isSuitableTopmostElementAtOffset(PsiElement $this$isSuitableTopmostElementAtOffset, int offset2) {
        return $this$isSuitableTopmostElementAtOffset.getTextOffset() >= offset2 && !($this$isSuitableTopmostElementAtOffset instanceof KtBlockExpression) && !($this$isSuitableTopmostElementAtOffset instanceof PsiFile);
    }

    @NotNull
    public static final KtExpression safeDeparenthesize(@NotNull KtExpression $this$safeDeparenthesize) {
        return KtPsiUtil.safeDeparenthesize((KtExpression)$this$safeDeparenthesize);
    }

    public static final boolean isExpectDeclaration(@NotNull KtDeclaration $this$isExpectDeclaration) {
        boolean bl;
        if (PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)$this$isExpectDeclaration))) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$this$isExpectDeclaration);
            bl = ktClassOrObject != null ? KotlinPsiUtils.isExpectDeclaration((KtDeclaration)ktClassOrObject) : false;
        }
        return bl;
    }

    public static final void deleteBody(@NotNull KtPropertyAccessor $this$deleteBody) {
        PsiElement psiElement2 = $this$deleteBody.getLeftParenthesis();
        if (psiElement2 == null) {
            return;
        }
        PsiElement leftParenthesis2 = psiElement2;
        $this$deleteBody.deleteChildRange(leftParenthesis2, $this$deleteBody.getLastChild());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final KtExpression singleExpressionBody(@NotNull KtDeclarationWithBody $this$singleExpressionBody) {
        KtExpression ktExpression;
        KtExpression body2 = $this$singleExpressionBody.getBodyExpression();
        if (body2 instanceof KtBlockExpression) {
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)((KtBlockExpression)body2).getStatements());
            KtExpression ktExpression3 = ktExpression2;
            if (ktExpression2 == null) return null;
            KtExpression $this$asSafely$iv = ktExpression3;
            boolean $i$f$asSafely = false;
            KtExpression ktExpression4 = $this$asSafely$iv;
            if (!(ktExpression4 instanceof KtReturnExpression)) {
                ktExpression4 = null;
            }
            KtReturnExpression ktReturnExpression = (KtReturnExpression)ktExpression4;
            ktExpression3 = ktReturnExpression;
            if (ktReturnExpression == null) return null;
            ktExpression = ktExpression3.getReturnedExpression();
            return ktExpression;
        } else {
            void var1_1;
            ktExpression = var1_1;
        }
        return ktExpression;
    }

    public static final boolean isConstructorDeclaredProperty(@NotNull KtNamedDeclaration $this$isConstructorDeclaredProperty) {
        return $this$isConstructorDeclaredProperty instanceof KtParameter && ((KtParameter)$this$isConstructorDeclaredProperty).getOwnerFunction() instanceof KtPrimaryConstructor && ((KtParameter)$this$isConstructorDeclaredProperty).hasValOrVar();
    }

    @NotNull
    public static final List<KtExpression> getCallChain(@NotNull KtExpression $this$getCallChain) {
        return CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)$this$getCallChain, (Function1)getCallChain.1.INSTANCE), (Function1)getCallChain.2.INSTANCE)));
    }
}

