/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.LibraryModuleInfo;
import org.jetbrains.kotlin.analyzer.TrackableModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.compositeAnalysis.PlatformAnalyzerServicesUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.KotlinLibraryToSourceAnalysisStateComponentUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ResolutionAnchorAwareLibraryModificationTracker;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000106H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000108H\u0016J\u000e\u00109\u001a\b\u0012\u0004\u0012\u00020\u00190:H\u0016J\b\u0010;\u001a\u00020\u0019H\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\r\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "Lorg/jetbrains/kotlin/analyzer/TrackableModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;)V", "_sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "get_sourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/SourceForBinaryModuleInfo;", "_sourcesModuleInfo$delegate", "Lkotlin/Lazy;", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "isDisposed", "", "()Z", "getLibrary", "()Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourcesModuleInfo", "getSourcesModuleInfo", "checkValidity", "", "createModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "dependencies", "", "dependenciesWithoutSelf", "Lkotlin/sequences/Sequence;", "getLibraryRoots", "", "toString", "kotlin.base.project-structure"})
public abstract class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo,
TrackableModuleInfo {
    @NotNull
    private final Project project;
    @NotNull
    private final LibraryEx library;
    @NotNull
    private final Name name;
    @NotNull
    private final Lazy _sourcesModuleInfo$delegate;

    public LibraryInfo(@NotNull Project project, @NotNull LibraryEx library2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        this.project = project;
        this.library = library2;
        Name name2 = Name.special((String)("<library " + this.library.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<library ${library.name}>\")");
        this.name = name2;
        this._sourcesModuleInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LibrarySourceInfo>(this){
            final /* synthetic */ LibraryInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LibrarySourceInfo invoke() {
                return new LibrarySourceInfo(this.this$0.getProject(), (Library)this.this$0.getLibrary(), this.this$0);
            }
        }));
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final LibraryEx getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.library.getPresentableName(), (String)"library.presentableName");
        return KotlinBaseProjectStructureBundle.message("library.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.getProject(), (Library)this.library);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        List list2;
        LibraryDependenciesCache.LibraryDependencies dependencies2 = LibraryDependenciesCache.Companion.getInstance(this.getProject()).getLibraryDependencies(this);
        List $this$dependencies_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$dependencies_u24lambda_u240.add(this);
        $this$dependencies_u24lambda_u240.addAll((Collection)dependencies2.getSdk());
        $this$dependencies_u24lambda_u240.addAll((Collection)dependencies2.getLibrariesWithoutSelf());
        return CollectionsKt.build((List)list2);
    }

    @Override
    @NotNull
    public Sequence<IdeaModuleInfo> dependenciesWithoutSelf() {
        LibraryDependenciesCache.LibraryDependencies dependencies2 = LibraryDependenciesCache.Companion.getInstance(this.getProject()).getLibraryDependencies(this);
        return SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)dependencies2.getSdk()), (Sequence)CollectionsKt.asSequence((Iterable)dependencies2.getLibrariesWithoutSelf()));
    }

    @NotNull
    public abstract TargetPlatform getPlatform();

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return PlatformAnalyzerServicesUtils.findAnalyzerServices(this.getPlatform(), this.getProject());
    }

    private final SourceForBinaryModuleInfo get_sourcesModuleInfo() {
        Lazy lazy = this._sourcesModuleInfo$delegate;
        return (SourceForBinaryModuleInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return this.get_sourcesModuleInfo();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getLibraryRoots() {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            VirtualFile p0 = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (PathUtil.getLocalPath((VirtualFile)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public ModificationTracker createModificationTracker() {
        ModificationTracker modificationTracker;
        if (!KotlinLibraryToSourceAnalysisStateComponentUtils.getUseLibraryToSourceAnalysis(this.getProject())) {
            ModificationTracker modificationTracker2 = ModificationTracker.NEVER_CHANGED;
            modificationTracker = modificationTracker2;
            Intrinsics.checkNotNullExpressionValue((Object)modificationTracker2, (String)"{\n            Modificati\u2026r.NEVER_CHANGED\n        }");
        } else {
            modificationTracker = new ResolutionAnchorAwareLibraryModificationTracker(this);
        }
        return modificationTracker;
    }

    public final boolean isDisposed() {
        return this.library.isDisposed();
    }

    @Override
    public void checkValidity() {
        if (this.isDisposed()) {
            throw new AlreadyDisposedException("Library '" + this.getName() + "' is already disposed");
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "(" + this.library + ")";
    }
}

