/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtLibraryModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtLibrarySourceModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSourceModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.NotUnderContentRootModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.SdkKtModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ProjectStructureProviderIdeImpl;", "Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createKtModuleByModuleInfo", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "getKtModuleByModuleInfo", "getKtModuleForKtElement", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin.base.project-structure"})
public final class ProjectStructureProviderIdeImpl
extends ProjectStructureProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ProjectStructureProviderIdeImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    @NotNull
    public KtModule getKtModuleForKtElement(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        ModuleInfoProvider.Configuration config2 = new ModuleInfoProvider.Configuration(false);
        Project project = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        IdeaModuleInfo ideaModuleInfo = ModuleInfoProviderUtils.firstOrNull(ModuleInfoProvider.Companion.getInstance(project), element3, config2);
        if (ideaModuleInfo == null) {
            ideaModuleInfo = new NotUnderContentRootModuleInfo(this.project);
        }
        IdeaModuleInfo moduleInfo = ideaModuleInfo;
        return this.getKtModuleByModuleInfo(moduleInfo);
    }

    @NotNull
    public final KtModule getKtModuleByModuleInfo(@NotNull ModuleInfo moduleInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        return this.createKtModuleByModuleInfo(moduleInfo);
    }

    private final KtModule createKtModuleByModuleInfo(ModuleInfo moduleInfo) {
        KtModule ktModule;
        ModuleInfo moduleInfo2 = moduleInfo;
        if (moduleInfo2 instanceof ModuleSourceInfo) {
            ktModule = new KtSourceModuleByModuleInfo((ModuleSourceInfo)moduleInfo, this);
        } else if (moduleInfo2 instanceof LibraryInfo) {
            ktModule = new KtLibraryModuleByModuleInfo((LibraryInfo)moduleInfo, this);
        } else if (moduleInfo2 instanceof SdkInfo) {
            ktModule = new SdkKtModuleByModuleInfo((SdkInfo)moduleInfo, this);
        } else if (moduleInfo2 instanceof LibrarySourceInfo) {
            ktModule = new KtLibrarySourceModuleByModuleInfo((LibrarySourceInfo)moduleInfo, this);
        } else if (moduleInfo2 instanceof NotUnderContentRootModuleInfo) {
            ktModule = new NotUnderContentRootModuleByModuleInfo((IdeaModuleInfo)moduleInfo, this);
        } else {
            Intrinsics.checkNotNull((Object)moduleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo");
            ktModule = new NotUnderContentRootModuleByModuleInfo((IdeaModuleInfo)moduleInfo, this);
        }
        return ktModule;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/ProjectStructureProviderIdeImpl$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/ProjectStructureProviderIdeImpl;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectStructureProviderIdeImpl getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProjectStructureProvider.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.ProjectStructureProviderIdeImpl");
            return (ProjectStructureProviderIdeImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

