/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.projectStructure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KLibUtils;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.base.platforms.LibraryEffectiveKindProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCacheKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.JvmLibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.LibraryEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.kotlin.platform.impl.NativeIdePlatformKind;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "libraryInfoCache", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache;", "deduplicatedLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "key", "dispose", "", "get", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "removedLibraryInfoTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "Companion", "LibraryInfoInnerCache", "kotlin.base.project-structure"})
public final class LibraryInfoCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryInfoInnerCache libraryInfoCache;

    public LibraryInfoCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.libraryInfoCache = new LibraryInfoInnerCache(project);
        Disposer.register((Disposable)this, (Disposable)this.libraryInfoCache);
    }

    @NotNull
    public final List<LibraryInfo> get(@NotNull Library key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof LibraryEx)) {
            boolean bl = false;
            String string2 = "Library '" + key.getPresentableName() + "' does not implement LibraryEx which is not expected";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.libraryInfoCache.get((LibraryEx)key);
    }

    @NotNull
    public final Library deduplicatedLibrary(@NotNull Library key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (Library)((LibraryInfo)CollectionsKt.first(this.get(key))).getLibrary();
    }

    public void dispose() {
    }

    @NotNull
    public final ModificationTracker removedLibraryInfoTracker() {
        return (ModificationTracker)this.libraryInfoCache.getRemovedLibraryInfoTracker();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u00018B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J@\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0014H\u0014J:\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J*\u0010\u001b\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J*\u0010\u001c\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014JX\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"2\u001e\u0010#\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040&H\u0002J<\u0010'\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030)H\u0014J*\u0010*\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\"\u0010+\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0014H\u0014J<\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0014H\u0014J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002J\u0017\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0096\u0002J(\u00101\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00022\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010 \u001a\u00020\u0002H\u0002J\u001e\u00105\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\b\u00106\u001a\u00020\u0012H\u0014J\f\u00107\u001a\u00020\n*\u00020\u0002H\u0002R6\u0010\b\u001a*\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\tj\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "deduplicationCache", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "removedLibraryInfoTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "getRemovedLibraryInfoTracker", "()Lcom/intellij/openapi/util/SimpleModificationTracker;", "addEntryToCache", "", "cache", "", "key", "root", "value", "additionalEntitiesCheck", "cachedDeduplicatedValue", "calculate", "checkCacheConsistency", "checkKeyConsistency", "checkKeyValidity", "checkValueValidity", "createLibraryInfos", "library", "platformKind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "klibLibraryInfoFactory", "Lkotlin/Function3;", "metadataLibraryInfoFactory", "Lkotlin/Function2;", "disposeEntry", "entry", "", "disposeIllegalEntry", "doInvalidate", "doInvalidateKeysAndGetOutdatedValues", "", "keys", "dropDisposedKey", "get", "getCachedOrPutNewValue", "newValue", "getPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "postProcessNewValue", "subscribe", "firstRoot", "ModelChangeListener", "kotlin.base.project-structure"})
    private static final class LibraryInfoInnerCache
    extends SynchronizedFineGrainedEntityCache<LibraryEx, List<? extends LibraryInfo>> {
        @NotNull
        private final SimpleModificationTracker removedLibraryInfoTracker;
        @NotNull
        private final HashMap<String, List<LibraryEx>> deduplicationCache;

        public LibraryInfoInnerCache(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, false, 2, null);
            this.removedLibraryInfoTracker = new SimpleModificationTracker();
            this.deduplicationCache = new HashMap();
        }

        @NotNull
        public final SimpleModificationTracker getRemovedLibraryInfoTracker() {
            return this.removedLibraryInfoTracker;
        }

        @Override
        protected void subscribe() {
            this.getProject().getMessageBus().connect((Disposable)this).subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener(this.getProject()));
        }

        @Override
        protected void doInvalidate(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            super.doInvalidate(cache2);
            this.deduplicationCache.clear();
        }

        @Override
        @NotNull
        public List<LibraryInfo> get(@NotNull LibraryEx key) {
            List<LibraryInfo> list2;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.checkKeyAndDisposeIllegalEntry(key);
            List<LibraryInfo> list3 = this.getCachedOrPutNewValue(key, null);
            if (list3 != null) {
                List<LibraryInfo> it = list3;
                boolean bl = false;
                return it;
            }
            ProgressManager.checkCanceled();
            List<LibraryInfo> newValue = this.calculate(key);
            if (FineGrainedEntityCache.Companion.isValidityChecksEnabled()) {
                this.checkValueValidity(newValue);
            }
            if ((list2 = this.getCachedOrPutNewValue(key, newValue)) != null) {
                List<LibraryInfo> it = list2;
                boolean bl = false;
                return it;
            }
            this.postProcessNewValue(key, newValue);
            return newValue;
        }

        private final List<LibraryInfo> getCachedOrPutNewValue(LibraryEx key, List<? extends LibraryInfo> newValue) {
            return (List)this.useCache((Function1)new Function1<Map<LibraryEx, List<? extends LibraryInfo>>, List<? extends LibraryInfo>>(this, key, newValue){
                final /* synthetic */ LibraryInfoInnerCache this$0;
                final /* synthetic */ LibraryEx $key;
                final /* synthetic */ List<LibraryInfo> $newValue;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    this.$newValue = $newValue;
                    super(1);
                }

                @Nullable
                public final List<LibraryInfo> invoke(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
                    Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                    LibraryInfoInnerCache.access$checkEntitiesIfRequired(this.this$0, cache2);
                    List<LibraryInfo> list2 = cache2.get(this.$key);
                    if (list2 != null) {
                        List<LibraryInfo> it = list2;
                        boolean bl = false;
                        return it;
                    }
                    String root = LibraryInfoInnerCache.access$firstRoot(this.this$0, this.$key);
                    List<LibraryInfo> deduplicatedValue = LibraryInfoInnerCache.access$cachedDeduplicatedValue(this.this$0, cache2, this.$key, root);
                    List<LibraryInfo> list3 = deduplicatedValue;
                    if (list3 == null && (list3 = this.$newValue) == null) {
                        return null;
                    }
                    List<LibraryInfo> resultValue = list3;
                    LibraryInfoInnerCache.access$addEntryToCache(this.this$0, cache2, this.$key, root, resultValue);
                    return deduplicatedValue;
                }
            });
        }

        private final void addEntryToCache(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key, String root, List<? extends LibraryInfo> value2) {
            Object object;
            cache2.put(key, value2);
            Map $this$getOrPut$iv = this.deduplicationCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(root);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(root, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(key);
        }

        private final List<LibraryInfo> cachedDeduplicatedValue(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key, String root) {
            Object v0;
            Map keyUrlsByType;
            List<LibraryEx> deduplicatedLibraries;
            block4: {
                deduplicatedLibraries = this.deduplicationCache.get(root);
                Collection collection = deduplicatedLibraries;
                if (collection == null || collection.isEmpty()) {
                    return null;
                }
                keyUrlsByType = LibraryInfoCacheKt.access$urlsByType(key);
                Iterable iterable = deduplicatedLibraries;
                for (Object t : iterable) {
                    LibraryEx it = (LibraryEx)t;
                    boolean bl = false;
                    if (!LibraryInfoCacheKt.access$rootEquals(keyUrlsByType, it)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            LibraryEx libraryEx = v0;
            if (libraryEx == null) {
                return null;
            }
            LibraryEx deduplicatedLibrary = libraryEx;
            List<LibraryInfo> cachedValue2 = cache2.get(deduplicatedLibrary);
            if (cachedValue2 == null) {
                KotlinExceptionWithAttachments exception = new KotlinExceptionWithAttachments(StringsKt.trimIndent((String)("\n                        inconsistent state:\n                        is the same key: " + (deduplicatedLibrary == key) + "\n                        root consistent: " + Intrinsics.areEqual((Object)this.firstRoot(key), (Object)root) + "\n                        urls consistent: " + Intrinsics.areEqual((Object)LibraryInfoCacheKt.access$urlsByType(key), (Object)keyUrlsByType) + "\n                        key name: " + key.getPresentableName() + "\n                        deduplicated key name: " + deduplicatedLibrary.getPresentableName() + "\n                    "))).withAttachment("key.txt", (Object)key.toString()).withAttachment("deduplicated.txt", (Object)deduplicatedLibrary.toString()).withAttachment("librariesBefore.txt", (Object)CollectionsKt.joinToString$default((Iterable)deduplicatedLibraries, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                ((Collection)deduplicatedLibraries).remove(deduplicatedLibrary);
                exception.withAttachment("librariesAfter.txt", (Object)CollectionsKt.joinToString$default((Iterable)deduplicatedLibraries, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                this.getLogger().error((Throwable)exception);
                return this.cachedDeduplicatedValue(cache2, key, root);
            }
            return cachedValue2;
        }

        private final String firstRoot(LibraryEx $this$firstRoot) {
            String[] stringArray = $this$firstRoot.getUrls(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(OrderRootType.CLASSES)");
            String string2 = (String)ArraysKt.firstOrNull((Object[])stringArray);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            LibraryInfoCacheKt.checkValidity((Library)key);
        }

        @Override
        protected void checkKeyConsistency(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super.checkKeyConsistency(cache2, key);
            this.checkCacheConsistency(cache2, key);
        }

        private final void checkCacheConsistency(Map<LibraryEx, List<LibraryInfo>> cache2, LibraryEx key) {
            boolean isDeduplicated;
            boolean isCached = cache2.containsKey(key);
            List<LibraryEx> list2 = this.deduplicationCache.get(this.firstRoot(key));
            boolean bl = list2 != null ? list2.contains(key) : (isDeduplicated = false);
            if (isCached != isDeduplicated) {
                throw new IllegalStateException(("inconsistent state " + key.getPresentableName() + ": is cached: " + isCached + ", is deduplicated: " + isDeduplicated).toString());
            }
        }

        @Override
        protected void additionalEntitiesCheck(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            for (List<LibraryEx> values2 : this.deduplicationCache.values()) {
                Iterator<LibraryEx> iterator = values2.iterator();
                while (iterator.hasNext()) {
                    LibraryEx library2 = iterator.next();
                    try {
                        this.checkCacheConsistency(cache2, library2);
                    }
                    catch (Throwable e) {
                        iterator.remove();
                        cache2.remove(library2);
                        this.getLogger().error(e);
                    }
                }
            }
        }

        @Override
        protected void disposeIllegalEntry(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull LibraryEx key) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super.disposeIllegalEntry(cache2, key);
            this.dropDisposedKey(key);
        }

        @Override
        protected void disposeEntry(@NotNull Map<LibraryEx, List<LibraryInfo>> cache2, @NotNull Map.Entry<LibraryEx, List<LibraryInfo>> entry) {
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            Intrinsics.checkNotNullParameter(entry, (String)"entry");
            this.dropDisposedKey(entry.getKey());
            LibraryEx libInfoKey = ((LibraryInfo)CollectionsKt.first(entry.getValue())).getLibrary();
            if (Intrinsics.areEqual((Object)libInfoKey, (Object)entry.getKey())) {
                return;
            }
            Iterator<Map.Entry<LibraryEx, List<LibraryInfo>>> iterator = cache2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<LibraryEx, List<LibraryInfo>> cacheEntry = iterator.next();
                if (!Intrinsics.areEqual((Object)((LibraryInfo)CollectionsKt.first(cacheEntry.getValue())).getLibrary(), (Object)libInfoKey)) continue;
                iterator.remove();
                this.dropDisposedKey(cacheEntry.getKey());
            }
        }

        private final void dropDisposedKey(LibraryEx key) {
            for (List<LibraryEx> values2 : this.deduplicationCache.values()) {
                if (values2.remove(key)) break;
            }
        }

        @Override
        protected void checkValueValidity(@NotNull List<? extends LibraryInfo> value2) {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Iterable $this$forEach$iv = value2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryInfo p0 = (LibraryInfo)element$iv;
                boolean bl = false;
                p0.checkValidity();
            }
        }

        @Override
        @NotNull
        public List<LibraryInfo> calculate(@NotNull LibraryEx key) {
            List<LibraryInfo> list2;
            List<LibraryInfo> list3;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            IdePlatformKind platformKind = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)this.getPlatform(key));
            if (platformKind instanceof JvmIdePlatformKind) {
                list3 = CollectionsKt.listOf((Object)new JvmLibraryInfo(this.getProject(), key));
            } else if (platformKind instanceof CommonIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.1.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.2.INSTANCE));
            } else if (platformKind instanceof JsIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.3.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.4.INSTANCE));
            } else if (platformKind instanceof NativeIdePlatformKind) {
                list3 = this.createLibraryInfos(key, platformKind, (Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo>)((Function3)calculate.5.INSTANCE), (Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo>)((Function2)calculate.6.INSTANCE));
            } else {
                throw new IllegalStateException(("Unexpected platform kind: " + platformKind).toString());
            }
            List<LibraryInfo> it = list2 = list3;
            boolean bl = false;
            if (!(!((Collection)it).isEmpty())) {
                boolean bl2 = false;
                String string2 = "Must be not empty for consistency with LibraryInfoCache#deduplicatedLibrary";
                throw new IllegalArgumentException(string2.toString());
            }
            return list2;
        }

        @Override
        public void postProcessNewValue(@NotNull LibraryEx key, @NotNull List<? extends LibraryInfo> value2) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            ((LibraryInfoListener)this.getProject().getMessageBus().syncPublisher(LibraryInfoListener.Companion.getTOPIC())).libraryInfosAdded((Collection<? extends LibraryInfo>)value2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Collection<List<LibraryInfo>> doInvalidateKeysAndGetOutdatedValues(@NotNull Collection<? extends LibraryEx> keys, @NotNull Map<LibraryEx, List<LibraryInfo>> cache2) {
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter(cache2, (String)"cache");
            List outdatedValues = new ArrayList();
            Iterable $this$groupBy$iv = keys;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                LibraryEx it = (LibraryEx)element$iv$iv;
                boolean bl = false;
                key$iv$iv = this.firstRoot(it);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry entry : destination$iv$iv.entrySet()) {
                List<LibraryEx> deduplicatedLibraries;
                String root = (String)entry.getKey();
                List invalidatedLibraries = (List)entry.getValue();
                if (this.deduplicationCache.get(root) == null || deduplicatedLibraries.isEmpty()) continue;
                deduplicatedLibraries.removeAll(invalidatedLibraries);
                for (LibraryEx invalidatedLibrary : invalidatedLibraries) {
                    Object object = cache2.remove(invalidatedLibrary);
                    if (object == null) continue;
                    Object it = key$iv$iv = object;
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)((LibraryInfo)CollectionsKt.first((List)it)).getLibrary(), (Object)invalidatedLibrary) ? key$iv$iv : null;
                    if (object == null) {
                        continue;
                    }
                    List<LibraryInfo> anchorInfo = object;
                    ((Collection)outdatedValues).add(anchorInfo);
                    if (deduplicatedLibraries.isEmpty()) continue;
                    Map invalidatedLibraryUrlsByType = LibraryInfoCacheKt.access$urlsByType(invalidatedLibrary);
                    Iterator<LibraryEx> deduplicatedLibrariesIterator = deduplicatedLibraries.iterator();
                    while (deduplicatedLibrariesIterator.hasNext()) {
                        LibraryEx deduplicatedLibrary = deduplicatedLibrariesIterator.next();
                        if (!LibraryInfoCacheKt.access$rootEquals(invalidatedLibraryUrlsByType, deduplicatedLibrary)) continue;
                        deduplicatedLibrariesIterator.remove();
                        cache2.remove(deduplicatedLibrary);
                    }
                }
            }
            return outdatedValues;
        }

        /*
         * WARNING - void declaration
         */
        private final List<LibraryInfo> createLibraryInfos(LibraryEx library2, IdePlatformKind platformKind, Function3<? super Project, ? super LibraryEx, ? super String, ? extends LibraryInfo> klibLibraryInfoFactory, Function2<? super Project, ? super LibraryEx, ? extends LibraryInfo> metadataLibraryInfoFactory) {
            ArrayList<Object> arrayList;
            void $this$filterTo$iv$iv;
            TargetPlatform defaultPlatform = platformKind.getDefaultPlatform();
            VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
            Object[] $this$filter$iv = virtualFileArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!KLibUtils.isKlibLibraryRootForPlatform(it, defaultPlatform)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List klibFiles = (List)destination$iv$iv;
            if (klibFiles.isEmpty()) {
                return CollectionsKt.listOf((Object)metadataLibraryInfoFactory.invoke((Object)this.getProject(), (Object)library2));
            }
            ArrayList<Object> $this$createLibraryInfos_u24lambda_u249 = arrayList = new ArrayList<Object>(klibFiles.size());
            boolean bl = false;
            for (VirtualFile file2 : klibFiles) {
                String path2;
                if (PathUtil.getLocalPath((VirtualFile)file2) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"PathUtil.getLocalPath(file) ?: continue");
                $this$createLibraryInfos_u24lambda_u249.add(klibLibraryInfoFactory.invoke((Object)this.getProject(), (Object)library2, (Object)path2));
            }
            return arrayList;
        }

        private final TargetPlatform getPlatform(LibraryEx library2) {
            TargetPlatform targetPlatform;
            if (!library2.isDisposed()) {
                ComponentManager $this$service$iv = (ComponentManager)this.getProject();
                boolean $i$f$service = false;
                Class<LibraryEffectiveKindProvider> serviceClass$iv = LibraryEffectiveKindProvider.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                targetPlatform = KotlinLibraryKindKt.getPlatform(((LibraryEffectiveKindProvider)object).getEffectiveKind((Library)library2));
            } else {
                targetPlatform = JvmPlatforms.INSTANCE.getDefaultJvmPlatform();
            }
            return targetPlatform;
        }

        public static final /* synthetic */ void access$checkEntitiesIfRequired(LibraryInfoInnerCache $this, Map cache2) {
            $this.checkEntitiesIfRequired(cache2);
        }

        public static final /* synthetic */ String access$firstRoot(LibraryInfoInnerCache $this, LibraryEx $receiver) {
            return $this.firstRoot($receiver);
        }

        public static final /* synthetic */ List access$cachedDeduplicatedValue(LibraryInfoInnerCache $this, Map cache2, LibraryEx key, String root) {
            return $this.cachedDeduplicatedValue(cache2, key, root);
        }

        public static final /* synthetic */ void access$addEntryToCache(LibraryInfoInnerCache $this, Map cache2, LibraryEx key, String root, List value2) {
            $this.addEntryToCache(cache2, key, root, value2);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache$ModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/LibraryEntityChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$LibraryInfoInnerCache;Lcom/intellij/openapi/project/Project;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/roots/libraries/Library;", "kotlin.base.project-structure"})
        public final class ModelChangeListener
        extends LibraryEntityChangeListener {
            public ModelChangeListener(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                super(project, false);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected void entitiesChanged(@NotNull List<? extends Library> outdated) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(outdated, (String)"outdated");
                Iterable iterable = outdated;
                FineGrainedEntityCache fineGrainedEntityCache = LibraryInfoInnerCache.this;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Library library2 = (Library)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
                    collection.add((LibraryEx)it);
                }
                HashSet droppedLibraryInfos = (HashSet)AddToStdlibKt.flattenTo((Iterable)FineGrainedEntityCache.invalidateKeysAndGetOutdatedValues$default(fineGrainedEntityCache, (List)destination$iv$iv, null, 2, null), (Collection)new HashSet());
                if (!((Collection)droppedLibraryInfos).isEmpty()) {
                    LibraryInfoInnerCache.this.getRemovedLibraryInfoTracker().incModificationCount();
                    ((LibraryInfoListener)this.getProject().getMessageBus().syncPublisher(LibraryInfoListener.Companion.getTOPIC())).libraryInfosRemoved(droppedLibraryInfos);
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.project-structure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryInfoCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LibraryInfoCache> serviceClass$iv = LibraryInfoCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (LibraryInfoCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

