/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.plugin.artifacts;

import com.intellij.util.io.Decompressor;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002J\u000e\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/LazyZipUnpacker;", "Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer;", "Ljava/io/File;", "", "destination", "(Ljava/io/File;)V", "getUnpackedIfUpToDateOrNull", "zip", "lazyUnpack", "produceOutput", "", "input", "computationContext", "(Ljava/io/File;Lkotlin/Unit;)Ljava/util/List;", "updateMessageDigestWithInput", "messageDigest", "Ljava/security/MessageDigest;", "buffer", "", "kotlin.base.plugin"})
public final class LazyZipUnpacker
extends AbstractLazyFileOutputProducer<File, Unit> {
    @NotNull
    private final File destination;

    public LazyZipUnpacker(@NotNull File destination) {
        String string2 = LazyZipUnpacker.class.getName();
        String string3 = destination.getCanonicalPath();
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        super(string2 + "-" + DigestUtil.md5Hex((byte[])byArray));
        this.destination = destination;
    }

    @Override
    @NotNull
    protected List<File> produceOutput(@NotNull File input, @NotNull Unit computationContext) {
        FilesKt.deleteRecursively((File)this.destination);
        new Decompressor.Zip(input).extract(this.destination);
        if (!this.destination.isDirectory()) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return CollectionsKt.listOf((Object)this.destination);
    }

    @Override
    protected void updateMessageDigestWithInput(@NotNull MessageDigest messageDigest, @NotNull File input, @NotNull byte[] buffer) {
        DigestUtil.updateContentHash((MessageDigest)messageDigest, (Path)input.toPath(), (byte[])buffer);
    }

    @NotNull
    public final File lazyUnpack(@NotNull File zip) {
        File file2 = (File)CollectionsKt.singleOrNull(this.lazyProduceOutput(zip, Unit.INSTANCE));
        if (file2 == null) {
            throw new IllegalStateException("produceOutput returns only single element".toString());
        }
        return file2;
    }

    @Nullable
    public final File getUnpackedIfUpToDateOrNull(@NotNull File zip) {
        Collection collection = this.getOutputIfUpToDateOrEmpty(zip);
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        File file2 = (File)CollectionsKt.singleOrNull((List)((List)collection));
        if (file2 == null) {
            throw new IllegalStateException("produceOutput returns only single element".toString());
        }
        return file2;
    }
}

