/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\nH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isLegacyNativeKlibComponent", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "checkKlibComponent", "componentFile", "requestedBuiltInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "isKlibLibraryRootForPlatform", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "toBuiltInsPlatform", "kotlin.base.platforms"})
@JvmName(name="KLibUtils")
public final class KLibUtils {
    @ApiStatus.Internal
    public static final boolean isKlibLibraryRootForPlatform(@NotNull VirtualFile $this$isKlibLibraryRootForPlatform, @NotNull TargetPlatform targetPlatform) {
        if (Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getFileType(), (Object)ArchiveFileType.INSTANCE) && !Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getExtension(), (Object)"klib") || !$this$isKlibLibraryRootForPlatform.isDirectory()) {
            return false;
        }
        BuiltInsPlatform requestedBuiltInsPlatform = KLibUtils.toBuiltInsPlatform(targetPlatform);
        if (requestedBuiltInsPlatform == BuiltInsPlatform.NATIVE && KLibUtils.checkKlibComponent($this$isKlibLibraryRootForPlatform, requestedBuiltInsPlatform)) {
            return true;
        }
        try {
            boolean bl;
            VirtualFile[] virtualFileArray = $this$isKlibLibraryRootForPlatform.getChildren();
            if (virtualFileArray != null) {
                boolean bl2;
                block7: {
                    VirtualFile[] $this$any$iv = virtualFileArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        VirtualFile element$iv;
                        VirtualFile it = element$iv = $this$any$iv[j];
                        boolean bl3 = false;
                        if (!KLibUtils.checkKlibComponent(it, requestedBuiltInsPlatform)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }
        catch (InvalidVirtualFileAccessException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkKlibComponent(VirtualFile componentFile, BuiltInsPlatform requestedBuiltInsPlatform) {
        Object object;
        Object it;
        Object object2;
        Object object3;
        block20: {
            block19: {
                object3 = componentFile.findChild("manifest");
                if (object3 == null) break block19;
                it = object2 = object3;
                boolean bl = false;
                object3 = !it.isDirectory() ? object2 : null;
                if (object3 != null) break block20;
            }
            return false;
        }
        VirtualFile manifestFile = object3;
        try {
            Properties properties2;
            object = manifestFile.getInputStream();
            object2 = null;
            try {
                Properties properties3;
                it = (InputStream)object;
                boolean bl = false;
                Properties $this$checkKlibComponent_u24lambda_u243_u24lambda_u242 = properties3 = new Properties();
                boolean bl2 = false;
                $this$checkKlibComponent_u24lambda_u243_u24lambda_u242.load((InputStream)it);
                properties2 = properties3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = properties2;
        }
        catch (IOException iOException) {
            return false;
        }
        Object manifestProperties = object;
        if (!((Properties)manifestProperties).containsKey("unique_name")) {
            return false;
        }
        String string2 = ((Properties)manifestProperties).getProperty("builtins_platform");
        if (string2 == null) {
            return switch (WhenMappings.$EnumSwitchMapping$0[requestedBuiltInsPlatform.ordinal()]) {
                case 1 -> KLibUtils.isLegacyNativeKlibComponent(componentFile);
                case 2 -> {
                    if (!KLibUtils.isLegacyNativeKlibComponent(componentFile)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        String builtInsPlatformProperty = string2;
        BuiltInsPlatform builtInsPlatform = BuiltInsPlatform.Companion.parseFromString(builtInsPlatformProperty);
        if (builtInsPlatform == null) {
            return false;
        }
        BuiltInsPlatform builtInsPlatform2 = builtInsPlatform;
        return builtInsPlatform2 == requestedBuiltInsPlatform;
    }

    private static final BuiltInsPlatform toBuiltInsPlatform(TargetPlatform $this$toBuiltInsPlatform) {
        BuiltInsPlatform builtInsPlatform;
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.COMMON;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.NATIVE;
        } else if (JvmPlatformKt.isJvm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JVM;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JS;
        } else {
            throw new IllegalArgumentException("Unknown platform " + $this$toBuiltInsPlatform);
        }
        return builtInsPlatform;
    }

    private static final boolean isLegacyNativeKlibComponent(VirtualFile $this$isLegacyNativeKlibComponent) {
        VirtualFile irFolder = $this$isLegacyNativeKlibComponent.findChild("ir");
        return irFolder != null && !(irFolder.getChildren().length == 0);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuiltInsPlatform.values().length];
            try {
                nArray[BuiltInsPlatform.NATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInsPlatform.COMMON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

