/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.indices.names;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.DataExternalizer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.indices.names.ListOfNamesDataExternalizer;
import org.jetbrains.kotlin.idea.vfilefinder.FqNameKeyDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinPartialPackageNamesIndex;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b'\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\rH$J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u0010H$J \u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H$J\"\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u001e2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002J\u0014\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\nH\u0016R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/base/indices/names/NameByPackageShortNameIndex;", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dependsOnFileContent", "", "getDeclarationNamesByKtFile", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getDeclarationNamesByMetadata", "kotlinJvmBinaryClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "getIndexer", "Lcom/intellij/util/indexing/DataIndexer;", "Lcom/intellij/util/indexing/FileContent;", "getInputFilter", "Lcom/intellij/util/indexing/DefaultFileTypeSpecificInputFilter;", "getKeyDescriptor", "Lorg/jetbrains/kotlin/idea/vfilefinder/FqNameKeyDescriptor;", "getNamesInPackage", "", "packageFqName", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getPackageAndNamesFromBuiltIns", "", "fileContent", "getPackageAndNamesFromMetadata", "getValueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "getVersion", "", "traceKeyHashToVirtualFileMapping", "kotlin.base.indices"})
@ApiStatus.Internal
public abstract class NameByPackageShortNameIndex
extends FileBasedIndexExtension<FqName, List<? extends Name>> {
    @NotNull
    private final Logger LOG;

    public NameByPackageShortNameIndex() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinPartialPackageNamesIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        this.LOG = logger;
    }

    @NotNull
    protected abstract List<Name> getDeclarationNamesByKtFile(@NotNull KtFile var1);

    @NotNull
    protected abstract List<Name> getDeclarationNamesByMetadata(@NotNull KotlinJvmBinaryClass var1);

    @NotNull
    protected abstract Map<FqName, List<Name>> getPackageAndNamesFromBuiltIns(@NotNull FileContent var1);

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FqNameKeyDescriptor getKeyDescriptor() {
        return FqNameKeyDescriptor.INSTANCE;
    }

    @NotNull
    public DataExternalizer<List<Name>> getValueExternalizer() {
        return ListOfNamesDataExternalizer.INSTANCE;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @NotNull
    public DefaultFileTypeSpecificInputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{(FileType)KotlinFileType.INSTANCE, (FileType)JavaClassFileType.INSTANCE, (FileType)KotlinBuiltInFileType.INSTANCE};
        return new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    @NotNull
    public DataIndexer<FqName, List<Name>, FileContent> getIndexer() {
        return arg_0 -> NameByPackageShortNameIndex.getIndexer$lambda$0(this, arg_0);
    }

    private final Map<FqName, List<Name>> getPackageAndNamesFromMetadata(FileContent fileContent) {
        FqName packageName2;
        KotlinClassFinder.Result result2 = KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent(fileContent.getFile(), fileContent.getContent());
        if (result2 == null) {
            return MapsKt.emptyMap();
        }
        KotlinClassFinder.Result result3 = result2;
        KotlinClassFinder.Result.KotlinClass kotlinClass = result3 instanceof KotlinClassFinder.Result.KotlinClass ? (KotlinClassFinder.Result.KotlinClass)result3 : null;
        if (kotlinClass == null) {
            return MapsKt.emptyMap();
        }
        KotlinClassFinder.Result.KotlinClass kotlinClass2 = kotlinClass;
        KotlinJvmBinaryClass binaryClass = kotlinClass2.getKotlinJvmBinaryClass();
        String string2 = binaryClass.getClassHeader().getPackageName();
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            v3 = new FqName(p0);
        } else {
            v3 = packageName2 = binaryClass.getClassId().getPackageFqName();
        }
        if (binaryClass.getClassHeader().getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS) {
            return MapsKt.emptyMap();
        }
        if (binaryClass.getClassId().isLocal()) {
            return MapsKt.emptyMap();
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)packageName2, (Object)CollectionsKt.distinct((Iterable)this.getDeclarationNamesByMetadata(binaryClass))));
    }

    @NotNull
    public final Set<Name> getNamesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope2) {
        Set set2;
        Set $this$getNamesInPackage_u24lambda_u241 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = FileBasedIndex.getInstance().getValues(this.getName(), (Object)packageFqName, scope2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection p0 = (Collection)element$iv;
            boolean bl2 = false;
            $this$getNamesInPackage_u24lambda_u241.addAll(p0);
        }
        return SetsKt.build((Set)set2);
    }

    private static final Map getIndexer$lambda$0(NameByPackageShortNameIndex this$0, FileContent fileContent) {
        Object object;
        try {
            Map map2;
            object = fileContent.getFileType();
            if (Intrinsics.areEqual((Object)object, (Object)JavaClassFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromMetadata(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinBuiltInFileType.INSTANCE)) {
                map2 = this$0.getPackageAndNamesFromBuiltIns(fileContent);
            } else if (Intrinsics.areEqual((Object)object, (Object)KotlinFileType.INSTANCE)) {
                PsiFile psiFile2 = fileContent.getPsiFile();
                KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (ktFile == null) {
                    return MapsKt.emptyMap();
                }
                KtFile ktFile2 = ktFile;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)ktFile2.getPackageFqName(), (Object)CollectionsKt.distinct((Iterable)this$0.getDeclarationNamesByKtFile(ktFile2))));
            } else {
                map2 = MapsKt.emptyMap();
            }
            object = map2;
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this$0.LOG.warn("Error `(" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")` while indexing file " + fileContent.getFileName() + " using " + this$0.getName() + " index. Probably the file is broken.");
            object = MapsKt.emptyMap();
        }
        return object;
    }
}

