/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\u0007"}, d2={"shouldCheckScript", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Boolean;", "shouldHighlightErrors", "shouldHighlightFile", "shouldHighlightScript", "kotlin.base.highlighting"})
@JvmName(name="KotlinHighlightingUtils")
public final class KotlinHighlightingUtils {
    @ApiStatus.Internal
    public static final boolean shouldHighlightErrors(@NotNull KtFile $this$shouldHighlightErrors) {
        if ($this$shouldHighlightErrors.isCompiled()) {
            return false;
        }
        if ($this$shouldHighlightErrors instanceof KtCodeFragment && ((KtCodeFragment)$this$shouldHighlightErrors).getContext() != null) {
            return true;
        }
        Boolean canCheckScript = KotlinHighlightingUtils.shouldCheckScript($this$shouldHighlightErrors);
        if (Intrinsics.areEqual((Object)canCheckScript, (Object)true)) {
            return KotlinHighlightingUtils.shouldHighlightScript($this$shouldHighlightErrors);
        }
        return SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, canCheckScript == null, 15, null), (PsiElement)$this$shouldHighlightErrors);
    }

    @ApiStatus.Internal
    public static final boolean shouldHighlightFile(@NotNull KtFile $this$shouldHighlightFile) {
        if ($this$shouldHighlightFile instanceof KtCodeFragment && ((KtCodeFragment)$this$shouldHighlightFile).getContext() != null) {
            return true;
        }
        if ($this$shouldHighlightFile.isCompiled()) {
            return false;
        }
        if (OutsidersPsiFileSupport.isOutsiderFile((VirtualFile)$this$shouldHighlightFile.getVirtualFile())) {
            VirtualFile virtualFile = ProjectStructureUtils.getOutsiderFileOrigin($this$shouldHighlightFile.getProject(), $this$shouldHighlightFile.getVirtualFile());
            if (virtualFile == null) {
                return false;
            }
            VirtualFile origin = virtualFile;
            PsiFile psiFile2 = PsiManager.getInstance((Project)$this$shouldHighlightFile.getProject()).findFile(origin);
            KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            if (ktFile == null) {
                return false;
            }
            KtFile psiFileOrigin = ktFile;
            return KotlinHighlightingUtils.shouldHighlightFile(psiFileOrigin);
        }
        Boolean shouldCheckScript = KotlinHighlightingUtils.shouldCheckScript($this$shouldHighlightFile);
        if (Intrinsics.areEqual((Object)shouldCheckScript, (Object)true)) {
            return KotlinHighlightingUtils.shouldHighlightScript($this$shouldHighlightFile);
        }
        return shouldCheckScript != null ? SourceKindFilterUtils.matches(RootKindFilter.everything, (PsiElement)$this$shouldHighlightFile) && !(ModuleInfoProviderUtils.getModuleInfo((PsiElement)$this$shouldHighlightFile) instanceof NotUnderContentRootModuleInfo) : SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.everything, false, false, false, false, true, 15, null), (PsiElement)$this$shouldHighlightFile);
    }

    private static final Boolean shouldCheckScript(KtFile $this$shouldCheckScript) {
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable($this$shouldCheckScript){
            final /* synthetic */ KtFile $this_shouldCheckScript$inlined;
            {
                this.$this_shouldCheckScript$inlined = ktFile;
            }

            public final T compute() {
                boolean bl = false;
                return (T)(DumbService.getInstance((Project)this.$this_shouldCheckScript$inlined.getProject()).isDumb() ? null : (this.$this_shouldCheckScript$inlined.isScript() ? Boolean.valueOf(true) : Boolean.valueOf(false)));
            }
        });
    }

    private static final boolean shouldHighlightScript(KtFile $this$shouldHighlightScript) {
        boolean bl;
        block7: {
            if (KotlinPlatformUtils.isCidr()) {
                return false;
            }
            if (!ScriptConfigurationManager.Companion.getInstance($this$shouldHighlightScript.getProject()).hasConfiguration($this$shouldHighlightScript)) {
                return false;
            }
            Iterable $this$any$iv = IdeScriptReportSink.Companion.getReports($this$shouldHighlightScript);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == ScriptDiagnostic.Severity.FATAL)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (!ScriptDefinitionsManager.Companion.getInstance($this$shouldHighlightScript.getProject()).isReady()) {
            return false;
        }
        return SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, 15, null), (PsiElement)$this$shouldHighlightScript);
    }
}

