/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.highlighting.suspender;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.highlighter.ElementAnnotator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lastThrownExceptionTimestampPerFile", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "suspendTimeoutMs", "timeoutSeconds", "", "updateQueue", "Lcom/intellij/util/Alarm;", "cleanup", "", "isSuspended", "", "file", "scheduleUpdate", "suspend", "unsuspend", "updateNotifications", "Companion", "kotlin.base.fe10.highlighting"})
@ApiStatus.Internal
public final class KotlinHighlightingSuspender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final int timeoutSeconds;
    @NotNull
    private final Map<VirtualFile, Long> lastThrownExceptionTimestampPerFile;
    private final long suspendTimeoutMs;
    @NotNull
    private final Alarm updateQueue;

    public KotlinHighlightingSuspender(@NotNull Project project) {
        this.project = project;
        this.timeoutSeconds = Registry.intValue((String)"kotlin.highlighting.suspended.timeout", (int)10);
        this.lastThrownExceptionTimestampPerFile = new LinkedHashMap();
        this.suspendTimeoutMs = TimeUnit.SECONDS.toMillis(this.timeoutSeconds);
        this.updateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
        ElementAnnotator.Companion.getSuppressDeprecatedAnnotationRegistryKey().addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                ElementAnnotator.Companion.updateSuppressDeprecatedAnnotationValue();
            }
        }, (Disposable)KotlinPluginDisposable.Companion.getInstance(this.project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean suspend(@NotNull VirtualFile file2) {
        long l;
        this.cleanup();
        if (this.suspendTimeoutMs <= 0L) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            long lastThrownExceptionTimestamp;
            long l2;
            boolean bl = false;
            Long l3 = this.lastThrownExceptionTimestampPerFile.get(file2);
            if (l3 != null) {
                l2 = l3;
            } else {
                KotlinHighlightingSuspender $this$suspend_u24lambda_u241_u24lambda_u240 = this;
                boolean bl2 = false;
                Long l4 = timestamp;
                $this$suspend_u24lambda_u241_u24lambda_u240.lastThrownExceptionTimestampPerFile.put(file2, l4);
                l2 = 0L;
            }
            l = lastThrownExceptionTimestamp = l2;
        }
        long lastThrownExceptionTimestamp = l;
        this.scheduleUpdate(file2);
        this.updateNotifications(file2);
        return timestamp - lastThrownExceptionTimestamp > this.suspendTimeoutMs;
    }

    private final void scheduleUpdate(VirtualFile file2) {
        Alarm alarm;
        Alarm $this$scheduleUpdate_u24lambda_u243 = alarm = this.updateQueue;
        boolean bl = false;
        $this$scheduleUpdate_u24lambda_u243.addRequest(() -> KotlinHighlightingSuspender.scheduleUpdate$lambda$3$lambda$2(this, file2), this.suspendTimeoutMs + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsuspend(@NotNull VirtualFile file2) {
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            Long l = this.lastThrownExceptionTimestampPerFile.remove(file2);
        }
        this.cleanup();
        this.updateNotifications(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSuspended(@NotNull VirtualFile file2) {
        long l;
        this.cleanup();
        long timestamp = System.currentTimeMillis();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            Long l2 = this.lastThrownExceptionTimestampPerFile.get(file2);
            if (l2 == null) {
                boolean bl2 = false;
                return bl2;
            }
            long l3 = l2;
            l = l3;
        }
        long lastThrownExceptionTimestamp = l;
        return timestamp - lastThrownExceptionTimestamp < this.suspendTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        VirtualFile p0;
        long timestamp = System.currentTimeMillis();
        List filesToUpdate = new ArrayList();
        List filesToUpdateLater = new ArrayList();
        Map<VirtualFile, Long> map2 = this.lastThrownExceptionTimestampPerFile;
        synchronized (map2) {
            boolean bl = false;
            if (this.lastThrownExceptionTimestampPerFile.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<VirtualFile, Long>> it = this.lastThrownExceptionTimestampPerFile.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<VirtualFile, Long> next2 = it.next();
                if (timestamp - ((Number)next2.getValue()).longValue() <= this.suspendTimeoutMs) continue;
                ((Collection)filesToUpdate).add(next2.getKey());
                it.remove();
            }
            boolean bl2 = filesToUpdateLater.addAll((Collection)this.lastThrownExceptionTimestampPerFile.keySet());
        }
        this.updateQueue.cancelAllRequests();
        Iterable $this$forEach$iv = filesToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (VirtualFile)element$iv;
            boolean bl = false;
            this.updateNotifications(p0);
        }
        $this$forEach$iv = filesToUpdateLater;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (VirtualFile)element$iv;
            boolean bl = false;
            this.scheduleUpdate(p0);
        }
    }

    private final void updateNotifications(VirtualFile file2) {
        EditorNotifications.getInstance((Project)this.project).updateNotifications(file2);
    }

    private static final void scheduleUpdate$lambda$3$lambda$2(KotlinHighlightingSuspender this$0, VirtualFile $file) {
        this$0.updateNotifications($file);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/fe10/highlighting/suspender/KotlinHighlightingSuspender;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fe10.highlighting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinHighlightingSuspender getInstance(@NotNull Project project) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinHighlightingSuspender> serviceClass$iv = KotlinHighlightingSuspender.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (KotlinHighlightingSuspender)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

