/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.codeInsight;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \t*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/codeInsight/NoDeclarationDescriptorsChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "kotlin.base.fe10.code-insight"})
final class NoDeclarationDescriptorsChecker {
    @NotNull
    public static final NoDeclarationDescriptorsChecker INSTANCE = new NoDeclarationDescriptorsChecker();
    @NotNull
    private static final Logger LOG = Logger.getInstance(NoDeclarationDescriptorsChecker.class);
    private static final Set<Class<?>> checkedQuickFixClasses = Collections.synchronizedSet(new HashSet());

    private NoDeclarationDescriptorsChecker() {
    }

    public final void check(@NotNull Class<?> quickFixClass) {
        block2: {
            if (!checkedQuickFixClasses.add(quickFixClass)) {
                return;
            }
            for (Field field2 : quickFixClass.getDeclaredFields()) {
                this.checkType(field2.getGenericType(), field2);
            }
            Class<?> clazz = quickFixClass.getSuperclass();
            if (clazz == null) break block2;
            Class<?> it = clazz;
            boolean bl = false;
            INSTANCE.check(it);
        }
    }

    private final void checkType(Type type2, Field field2) {
        block5: {
            Type type3;
            block7: {
                block6: {
                    block4: {
                        type3 = type2;
                        if (!(type3 instanceof Class)) break block4;
                        if (DeclarationDescriptor.class.isAssignableFrom((Class)type2) || KotlinType.class.isAssignableFrom((Class)type2)) {
                            LOG.error("QuickFix class " + field2.getDeclaringClass().getName() + " contains field " + field2.getName() + " that holds " + ((Class)type2).getSimpleName() + ". This leads to holding too much memory through this quick-fix instance. Possible solution can be wrapping it using KotlinIntentionActionFactoryWithDelegate.");
                        }
                        if (!IntentionAction.class.isAssignableFrom((Class)type2)) break block5;
                        this.check((Class)type2);
                        break block5;
                    }
                    if (!(type3 instanceof GenericArrayType)) break block6;
                    this.checkType(((GenericArrayType)type2).getGenericComponentType(), field2);
                    break block5;
                }
                if (!(type3 instanceof ParameterizedType)) break block7;
                Type type4 = ((ParameterizedType)type2).getRawType();
                Intrinsics.checkNotNull((Object)type4, (String)"null cannot be cast to non-null type java.lang.Class<*>");
                if (!Collection.class.isAssignableFrom((Class)type4)) break block5;
                Type[] $this$forEach$iv = ((ParameterizedType)type2).getActualTypeArguments();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    Type element$iv;
                    Type it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    INSTANCE.checkType(it, field2);
                }
                break block5;
            }
            if (type3 instanceof WildcardType) {
                Type[] $this$forEach$iv = ((WildcardType)type2).getUpperBounds();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    Type element$iv;
                    Type it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    INSTANCE.checkType(it, field2);
                }
            }
        }
    }
}

