/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fe10.analysisApiProviders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactory;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.KotlinModuleStateTrackerProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.caches.project.LibraryModificationTracker;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListener;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinModuleOutOfCodeBlockModificationTracker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/fe10/analysisApiProviders/Fe10KotlinModificationTrackerFactory;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinModificationTrackerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createLibrariesWideModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "createModuleStateTracker", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "createModuleWithoutDependenciesOutOfBlockModificationTracker", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSourceModule;", "createProjectWideOutOfBlockModificationTracker", "incrementModificationsCount", "", "kotlin.base.fe10.analysis-api-providers"})
public final class Fe10KotlinModificationTrackerFactory
extends KotlinModificationTrackerFactory {
    @NotNull
    private final Project project;

    public Fe10KotlinModificationTrackerFactory(@NotNull Project project) {
        this.project = project;
    }

    @Override
    @NotNull
    public ModificationTracker createProjectWideOutOfBlockModificationTracker() {
        return KotlinCodeBlockModificationListener.Companion.getInstance(this.project).getKotlinOutOfCodeBlockTracker();
    }

    @Override
    @NotNull
    public ModificationTracker createModuleWithoutDependenciesOutOfBlockModificationTracker(@NotNull KtSourceModule module2) {
        return new KotlinModuleOutOfCodeBlockModificationTracker(KotlinProjectStructureUtils.getIdeaModule(module2));
    }

    @Override
    @NotNull
    public ModificationTracker createLibrariesWideModificationTracker() {
        return (ModificationTracker)LibraryModificationTracker.Companion.getInstance(this.project);
    }

    @Override
    @NotNull
    public KtModuleStateTracker createModuleStateTracker(@NotNull KtModule module2) {
        return KotlinModuleStateTrackerProvider.Companion.getInstance(this.project).getModuleStateTrackerFor(module2);
    }

    @Override
    @TestOnly
    public void incrementModificationsCount() {
        KotlinCodeBlockModificationListener.Companion.getInstance(this.project).incModificationCount();
        KotlinModuleOutOfCodeBlockModificationTracker.Companion.incrementModificationCountForAllModules(this.project);
        KotlinModuleStateTrackerProvider.Companion.getInstance(this.project).incrementModificationCountForAllModules();
    }
}

