/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.compilerPreferences.configuration;

import com.intellij.openapi.util.NlsSafe;
import java.util.Objects;
import kotlin.KotlinVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.compilerPreferences.KotlinBaseCompilerConfigurationUiBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.utils.DescriptionAware;

class JpsVersionItem
implements DescriptionAware {
    @Nullable
    private final IdeKotlinVersion myVersion;
    @NlsSafe
    @Nullable
    private final String myText;
    final boolean myEnabled;

    private JpsVersionItem(@NlsSafe @Nullable IdeKotlinVersion version2, boolean enabled2, @Nullable String text2) {
        this.myVersion = version2;
        this.myEnabled = enabled2;
        this.myText = text2;
        assert (this.myVersion != null || this.myText != null);
    }

    JpsVersionItem(@NotNull IdeKotlinVersion version2) {
        this(version2, true, null);
    }

    static JpsVersionItem createLabel(@NotNull @Nls String text2) {
        return new JpsVersionItem(null, false, text2);
    }

    static JpsVersionItem createFromRawVersion(@NotNull @Nls String rawVersion) {
        IdeKotlinVersion ideKotlinVersion;
        return new JpsVersionItem(ideKotlinVersion, true, (ideKotlinVersion = IdeKotlinVersion.opt(rawVersion)) != null ? null : rawVersion);
    }

    @NotNull
    public String getDescription() {
        if (this.myVersion == null) {
            return Objects.requireNonNull(this.myText);
        }
        if (this.myVersion.equals(KotlinJpsPluginSettings.getBundledVersion())) {
            return KotlinBaseCompilerConfigurationUiBundle.message("configuration.text.bundled.0.jps.version", this.myVersion);
        }
        KotlinVersion kotlinVersion2 = this.myVersion.getKotlinVersion();
        if (kotlinVersion2.compareTo(KotlinJpsPluginSettings.getJpsMinimumSupportedVersion()) < 0 || kotlinVersion2.compareTo(KotlinJpsPluginSettings.getJpsMaximumSupportedVersion()) > 0) {
            return KotlinBaseCompilerConfigurationUiBundle.message("configuration.text.0.unsupported.jps.version", this.myVersion);
        }
        return this.myVersion.toString();
    }

    @Nullable
    public IdeKotlinVersion getVersion() {
        return this.myVersion;
    }

    @NotNull
    public String getRawVersion() {
        return this.myVersion != null ? this.myVersion.getRawVersion() : Objects.requireNonNull(this.myText);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsVersionItem item = (JpsVersionItem)o;
        return Objects.equals(this.myVersion, item.myVersion) && Objects.equals(this.myText, item.myText);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion);
    }
}

