/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight;

import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinMainFunctionDetector;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/PsiOnlyKotlinMainFunctionDetector;", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector;", "()V", "isMain", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "configuration", "Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinMainFunctionDetector$Configuration;", "isMainCheckParameter", "kotlin.base.code-insight"})
@ApiStatus.Internal
public final class PsiOnlyKotlinMainFunctionDetector
implements KotlinMainFunctionDetector {
    @NotNull
    public static final PsiOnlyKotlinMainFunctionDetector INSTANCE = new PsiOnlyKotlinMainFunctionDetector();

    private PsiOnlyKotlinMainFunctionDetector() {
    }

    @Override
    @RequiresReadLock
    public boolean isMain(@NotNull KtNamedFunction function2, @NotNull KotlinMainFunctionDetector.Configuration configuration2) {
        KtTypeReference returnTypeReference2;
        String string2;
        if (function2.isLocal() || !((Collection)function2.getTypeParameters()).isEmpty()) {
            return false;
        }
        boolean isTopLevel2 = function2.isTopLevel();
        int parameterCount = function2.getValueParameters().size() + (function2.getReceiverTypeReference() != null ? 1 : 0);
        switch (parameterCount) {
            case 0: {
                if (!isTopLevel2) {
                    return false;
                }
                if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)function2).supportsFeature(LanguageFeature.ExtendedMainConvention)) break;
                return false;
            }
            case 1: {
                if (!configuration2.getCheckParameterType() || this.isMainCheckParameter(function2)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if ((string2 = KotlinPsiHeuristics.findJvmName$default((KtAnnotated)function2, null, 2, null)) == null) {
            string2 = function2.getName();
        }
        if (!Intrinsics.areEqual((Object)string2, (Object)"main")) {
            return false;
        }
        if (!isTopLevel2 && configuration2.getCheckJvmStaticAnnotation() && !KotlinPsiHeuristics.hasJvmStaticAnnotation((KtAnnotated)function2)) {
            return false;
        }
        return !configuration2.getCheckResultType() || (returnTypeReference2 = function2.getTypeReference()) == null || KotlinPsiHeuristics.INSTANCE.typeMatches(returnTypeReference2, StandardClassIds.INSTANCE.getUnit(), new ClassId[0]);
    }

    private final boolean isMainCheckParameter(KtNamedFunction function2) {
        boolean bl;
        KtTypeReference receiverTypeReference2 = function2.getReceiverTypeReference();
        if (receiverTypeReference2 != null) {
            ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getString()};
            return KotlinPsiHeuristics.INSTANCE.typeMatches(receiverTypeReference2, StandardClassIds.INSTANCE.getArray(), classIdArray);
        }
        KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull((List)function2.getValueParameters());
        if (ktParameter == null) {
            return false;
        }
        KtParameter parameter2 = ktParameter;
        KtTypeReference ktTypeReference = parameter2.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference parameterTypeReference = ktTypeReference;
        if (parameter2.isVarArg()) {
            bl = KotlinPsiHeuristics.INSTANCE.typeMatches(parameterTypeReference, StandardClassIds.INSTANCE.getString(), new ClassId[0]);
        } else {
            ClassId[] classIdArray = new ClassId[]{StandardClassIds.INSTANCE.getString()};
            bl = KotlinPsiHeuristics.INSTANCE.typeMatches(parameterTypeReference, StandardClassIds.INSTANCE.getArray(), classIdArray);
        }
        return bl;
    }
}

