/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiProviders;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.project.structure.KtBuiltinsModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.providers.KtModuleStateTracker;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.KotlinModuleStateTrackerProvider;
import org.jetbrains.kotlin.idea.base.analysisApiProviders.ModuleStateTrackerImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u000eH\u0007JI\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017\"\u0004\b\u0001\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u00150\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "libraryCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/ModuleStateTrackerImpl;", "sdkCache", "Lcom/intellij/openapi/projectRoots/Sdk;", "sourceModuleCache", "Lcom/intellij/openapi/module/Module;", "dispose", "", "getModuleStateTrackerFor", "Lorg/jetbrains/kotlin/analysis/providers/KtModuleStateTracker;", "module", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "incrementModificationCountForAllModules", "getReplacedEntity", "E", "C", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "Lcom/intellij/workspaceModel/storage/EntityChange$Replaced;", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "get", "Lkotlin/Function2;", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "(Lcom/intellij/workspaceModel/storage/EntityChange$Replaced;Lcom/intellij/workspaceModel/storage/VersionedStorageChange;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Companion", "JdkListener", "ModelChangeListener", "kotlin.base.analysis-api-providers"})
public final class KotlinModuleStateTrackerProvider
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Library, ModuleStateTrackerImpl> libraryCache;
    @NotNull
    private final ConcurrentHashMap<Module, ModuleStateTrackerImpl> sourceModuleCache;
    @NotNull
    private final ConcurrentHashMap<Sdk, ModuleStateTrackerImpl> sdkCache;

    public KotlinModuleStateTrackerProvider(@NotNull Project project) {
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener());
        busConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new JdkListener());
        this.libraryCache = new ConcurrentHashMap();
        this.sourceModuleCache = new ConcurrentHashMap();
        this.sdkCache = new ConcurrentHashMap();
    }

    @NotNull
    public final KtModuleStateTracker getModuleStateTrackerFor(@NotNull KtModule module2) {
        KtModuleStateTracker ktModuleStateTracker;
        KtModule ktModule = module2;
        if (ktModule instanceof KtBuiltinsModule) {
            ktModuleStateTracker = new ModuleStateTrackerImpl();
        } else {
            if (ktModule instanceof KtLibraryModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo");
                LibraryInfo libraryInfo = (LibraryInfo)ideaModuleInfo;
                libraryInfo.checkValidity();
                return this.libraryCache.computeIfAbsent((Library)libraryInfo.getLibrary(), arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$0(getModuleStateTrackerFor.1.INSTANCE, arg_0));
            }
            if (ktModule instanceof KtSdkModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo");
                SdkInfo sdkInfo = (SdkInfo)ideaModuleInfo;
                sdkInfo.checkValidity();
                Sdk sdk2 = sdkInfo.getSdk();
                return this.sdkCache.computeIfAbsent(sdk2, arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$1(getModuleStateTrackerFor.2.INSTANCE, arg_0));
            }
            if (ktModule instanceof KtSourceModule) {
                IdeaModuleInfo ideaModuleInfo = KotlinProjectStructureUtils.getModuleInfo(module2);
                Intrinsics.checkNotNull((Object)ideaModuleInfo, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo");
                ModuleSourceInfo sourceModule = (ModuleSourceInfo)ideaModuleInfo;
                sourceModule.checkValidity();
                return this.sourceModuleCache.computeIfAbsent(sourceModule.getModule(), arg_0 -> KotlinModuleStateTrackerProvider.getModuleStateTrackerFor$lambda$2(getModuleStateTrackerFor.3.INSTANCE, arg_0));
            }
            if (ktModule instanceof KtLibrarySourceModule) {
                ktModuleStateTracker = this.getModuleStateTrackerFor(((KtLibrarySourceModule)module2).getBinaryLibrary());
            } else if (ktModule instanceof KtNotUnderContentRootModule) {
                ktModuleStateTracker = new ModuleStateTrackerImpl();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ktModuleStateTracker;
    }

    private final <C extends WorkspaceEntity, E> E getReplacedEntity(EntityChange.Replaced<C> $this$getReplacedEntity, VersionedStorageChange event, Function2<? super C, ? super EntityStorage, ? extends E> get2) {
        Object object;
        Object old = get2.invoke((Object)$this$getReplacedEntity.getOldEntity(), (Object)event.getStorageBefore());
        if (!Intrinsics.areEqual((Object)old, (Object)(object = get2.invoke((Object)$this$getReplacedEntity.getNewEntity(), (Object)event.getStorageAfter())))) {
            boolean bl = false;
            String string2 = old + " should be equal to " + object + " for " + EntityChange.Replaced.class;
            throw new IllegalStateException(string2.toString());
        }
        return (E)object;
    }

    @TestOnly
    public final void incrementModificationCountForAllModules() {
        this.libraryCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$4(incrementModificationCountForAllModules.1.INSTANCE, arg_0, arg_1));
        this.sourceModuleCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$5(incrementModificationCountForAllModules.2.INSTANCE, arg_0, arg_1));
        this.sdkCache.forEach((arg_0, arg_1) -> KotlinModuleStateTrackerProvider.incrementModificationCountForAllModules$lambda$6(incrementModificationCountForAllModules.3.INSTANCE, arg_0, arg_1));
    }

    public void dispose() {
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$0(Function1 $tmp0, Object p0) {
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$1(Function1 $tmp0, Object p0) {
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final ModuleStateTrackerImpl getModuleStateTrackerFor$lambda$2(Function1 $tmp0, Object p0) {
        return (ModuleStateTrackerImpl)$tmp0.invoke(p0);
    }

    private static final void incrementModificationCountForAllModules$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void incrementModificationCountForAllModules$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void incrementModificationCountForAllModules$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$JdkListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "jdkRemoved", "", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "kotlin.base.analysis-api-providers"})
    private final class JdkListener
    implements ProjectJdkTable.Listener {
        public void jdkRemoved(@NotNull Sdk jdk) {
            block0: {
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sdkCache.remove(jdk);
                if (moduleStateTrackerImpl == null) break block0;
                moduleStateTrackerImpl.invalidate();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$ModelChangeListener;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelChangeListener;", "(Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;)V", "beforeChanged", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "handleContentRootInModuleChanges", "handleLibraryChanges", "handleModuleChanges", "getChangedModule", "Lcom/intellij/openapi/module/Module;", "contentRootBefore", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ContentRootEntity;", "contentRootAfter", "getChangedModules", "", "kotlin.base.analysis-api-providers"})
    private final class ModelChangeListener
    implements WorkspaceModelChangeListener {
        public void beforeChanged(@NotNull VersionedStorageChange event) {
            this.handleLibraryChanges(event);
            this.handleModuleChanges(event);
            this.handleContentRootInModuleChanges(event);
        }

        private final void handleContentRootInModuleChanges(VersionedStorageChange event) {
            for (Module changedModule2 : this.getChangedModules(event)) {
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sourceModuleCache.get(changedModule2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }

        private final Set<Module> getChangedModules(VersionedStorageChange $this$getChangedModules) {
            Module it$iv;
            boolean bl;
            EntityChange it;
            boolean bl2;
            Object element$iv;
            Object element$iv$iv;
            Set set2;
            Set $this$getChangedModules_u24lambda_u243 = set2 = SetsKt.createSetBuilder();
            boolean bl3 = false;
            Iterable $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(ContentRootEntity.class);
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = element$iv$iv = iterator.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl4 = false;
                if (this.getChangedModule($this$getChangedModules, (ContentRootEntity)it.getOldEntity(), (ContentRootEntity)it.getNewEntity()) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(SourceRootEntity.class);
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = element$iv$iv = iterator.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl5 = false;
                SourceRootEntity sourceRootEntity = (SourceRootEntity)it.getOldEntity();
                SourceRootEntity sourceRootEntity2 = (SourceRootEntity)it.getNewEntity();
                if (this.getChangedModule($this$getChangedModules, (ContentRootEntity)(sourceRootEntity != null ? sourceRootEntity.getContentRoot() : null), (ContentRootEntity)(sourceRootEntity2 != null ? sourceRootEntity2.getContentRoot() : null)) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            $this$mapNotNullTo$iv = $this$getChangedModules.getChanges(JavaSourceRootPropertiesEntity.class);
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity;
                element$iv = element$iv$iv = iterator.next();
                bl2 = false;
                it = (EntityChange)element$iv;
                boolean bl6 = false;
                JavaSourceRootPropertiesEntity javaSourceRootPropertiesEntity2 = (JavaSourceRootPropertiesEntity)it.getOldEntity();
                if (this.getChangedModule($this$getChangedModules, javaSourceRootPropertiesEntity2 != null && (javaSourceRootPropertiesEntity2 = javaSourceRootPropertiesEntity2.getSourceRoot()) != null ? javaSourceRootPropertiesEntity2.getContentRoot() : null, (javaSourceRootPropertiesEntity = (JavaSourceRootPropertiesEntity)it.getNewEntity()) != null && (javaSourceRootPropertiesEntity = javaSourceRootPropertiesEntity.getSourceRoot()) != null ? javaSourceRootPropertiesEntity.getContentRoot() : null) == null) continue;
                bl = false;
                ((Collection)$this$getChangedModules_u24lambda_u243).add(it$iv);
            }
            return SetsKt.build((Set)set2);
        }

        private final Module getChangedModule(VersionedStorageChange $this$getChangedModule, ContentRootEntity contentRootBefore, ContentRootEntity contentRootAfter) {
            ModuleBridge newModule;
            ContentRootEntity contentRootEntity = contentRootBefore;
            ModuleBridge oldModule = contentRootEntity != null && (contentRootEntity = contentRootEntity.getModule()) != null ? ModuleEntityUtils.findModule((ModuleEntity)contentRootEntity, (EntityStorage)((EntityStorage)$this$getChangedModule.getStorageBefore())) : null;
            ContentRootEntity contentRootEntity2 = contentRootAfter;
            ModuleBridge moduleBridge = contentRootEntity2 != null && (contentRootEntity2 = contentRootEntity2.getModule()) != null ? ModuleEntityUtils.findModule((ModuleEntity)contentRootEntity2, (EntityStorage)((EntityStorage)$this$getChangedModule.getStorageAfter())) : (newModule = null);
            if (newModule != null && oldModule != null && !Intrinsics.areEqual((Object)oldModule, (Object)newModule)) {
                boolean bl = false;
                String string2 = oldModule + " should be equal to " + newModule + " for " + EntityChange.Replaced.class;
                throw new IllegalStateException(string2.toString());
            }
            ModuleBridge moduleBridge2 = oldModule;
            return moduleBridge2 != null ? (Module)moduleBridge2 : (Module)newModule;
        }

        private final void handleLibraryChanges(VersionedStorageChange event) {
            Collection collection = event.getChanges(LibraryEntity.class);
            if (collection.isEmpty()) {
                boolean bl = false;
                return;
            }
            List libraryEntities = (List)collection;
            for (EntityChange change : libraryEntities) {
                Library changedLibrary2;
                EntityChange entityChange = change;
                if (entityChange instanceof EntityChange.Added) continue;
                if (entityChange instanceof EntityChange.Removed) {
                    Library library2;
                    if (LibraryEntityUtils.findLibraryBridge((LibraryEntity)((LibraryEntity)((EntityChange.Removed)change).getOldEntity()), (EntityStorage)((EntityStorage)event.getStorageBefore())) == null) continue;
                    KotlinModuleStateTrackerProvider kotlinModuleStateTrackerProvider = KotlinModuleStateTrackerProvider.this;
                    Library library3 = library2;
                    boolean bl = false;
                    ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)kotlinModuleStateTrackerProvider.libraryCache.remove(library3);
                    if (moduleStateTrackerImpl == null) continue;
                    moduleStateTrackerImpl.invalidate();
                    continue;
                }
                if (!(entityChange instanceof EntityChange.Replaced) || (Library)KotlinModuleStateTrackerProvider.this.getReplacedEntity((EntityChange.Replaced)change, event, handleLibraryChanges.changedLibrary.1.INSTANCE) == null) continue;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.libraryCache.get(changedLibrary2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }

        private final void handleModuleChanges(VersionedStorageChange event) {
            Collection collection = event.getChanges(ModuleEntity.class);
            if (collection.isEmpty()) {
                boolean bl = false;
                return;
            }
            List moduleEntities = (List)collection;
            for (EntityChange change : moduleEntities) {
                ModuleBridge changedModule2;
                EntityChange entityChange = change;
                if (entityChange instanceof EntityChange.Added) continue;
                if (entityChange instanceof EntityChange.Removed) {
                    ModuleBridge moduleBridge;
                    if (ModuleEntityUtils.findModule((ModuleEntity)((ModuleEntity)((EntityChange.Removed)change).getOldEntity()), (EntityStorage)((EntityStorage)event.getStorageBefore())) == null) continue;
                    KotlinModuleStateTrackerProvider kotlinModuleStateTrackerProvider = KotlinModuleStateTrackerProvider.this;
                    ModuleBridge module2 = moduleBridge;
                    boolean bl = false;
                    ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)kotlinModuleStateTrackerProvider.sourceModuleCache.remove(module2);
                    if (moduleStateTrackerImpl == null) continue;
                    moduleStateTrackerImpl.invalidate();
                    continue;
                }
                if (!(entityChange instanceof EntityChange.Replaced) || (ModuleBridge)KotlinModuleStateTrackerProvider.this.getReplacedEntity((EntityChange.Replaced)change, event, handleModuleChanges.changedModule.1.INSTANCE) == null) continue;
                ModuleStateTrackerImpl moduleStateTrackerImpl = (ModuleStateTrackerImpl)KotlinModuleStateTrackerProvider.this.sourceModuleCache.get(changedModule2);
                if (moduleStateTrackerImpl == null) continue;
                moduleStateTrackerImpl.incModificationCount();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/analysisApiProviders/KotlinModuleStateTrackerProvider;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis-api-providers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinModuleStateTrackerProvider getInstance(@NotNull Project project) {
            return (KotlinModuleStateTrackerProvider)project.getService(KotlinModuleStateTrackerProvider.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

