/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\u001fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allKotlinFiles", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "find", "files", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "selectedKotlinFiles", "update", "hasExplicitNothing", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isNothingOrNothingFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Companion", "kotlin.idea"})
public final class FindImplicitNothingAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.actions.internal.FindImplicitNothingAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        Intrinsics.checkNotNull((Object)object);
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> FindImplicitNothingAction.actionPerformed$lambda$0(this, selectedFiles, project), KotlinBundle.message("progress.finding.implicit.nothing.s", new Object[0]), true, project);
    }

    private final void find(Collection<? extends KtFile> files2, Project project) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ArrayList<KtCallExpression> found = new ArrayList<KtCallExpression>();
        Iterator<? extends KtFile> iterator = files2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i2 = n++;
            KtFile file2 = iterator.next();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                Object[] objectArray = new Object[]{i2, files2.size(), found.size()};
                progressIndicator2.setText(KotlinBundle.message("scanning.files.0.fo.1.file.2.occurrences.found", objectArray));
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText2(file2.getVirtualFile().getPath());
            }
            ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)file2);
            file2.acceptChildren((PsiElementVisitor)new KtVisitorVoid(resolutionFacade, this, found){
                final /* synthetic */ ResolutionFacade $resolutionFacade;
                final /* synthetic */ FindImplicitNothingAction this$0;
                final /* synthetic */ ArrayList<KtCallExpression> $found;
                {
                    this.$resolutionFacade = $resolutionFacade;
                    this.this$0 = $receiver;
                    this.$found = $found;
                }

                public void visitKtElement(@NotNull KtElement element3) {
                    ProgressManager.checkCanceled();
                    element3.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCallExpression(@NotNull KtCallExpression expression2) {
                    expression2.acceptChildren((PsiElementVisitor)this);
                    try {
                        BindingContext bindingContext2 = ResolutionFacade.analyze$default(this.$resolutionFacade, (KtElement)expression2, null, 2, null);
                        KotlinType kotlinType = bindingContext2.getType((KtExpression)expression2);
                        if (kotlinType == null) {
                            return;
                        }
                        KotlinType type2 = kotlinType;
                        if (KotlinBuiltIns.isNothing((KotlinType)type2) && !FindImplicitNothingAction.access$hasExplicitNothing(this.this$0, (KtExpression)expression2, bindingContext2)) {
                            this.$found.add(expression2);
                        }
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        FindImplicitNothingAction.access$getLOG$cp().error(t);
                    }
                }
            });
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i2 + 1) / (double)files2.size());
        }
        SwingUtilities.invokeLater(() -> FindImplicitNothingAction.find$lambda$2(found, project, files2));
    }

    private final boolean hasExplicitNothing(KtExpression $this$hasExplicitNothing, BindingContext bindingContext2) {
        KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)$this$hasExplicitNothing));
        if (ktExpression == null) {
            return false;
        }
        KtExpression callee2 = ktExpression;
        if (callee2 instanceof KtSimpleNameExpression) {
            KtCallableDeclaration declaration2;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)callee2);
            if (declarationDescriptor == null) {
                return false;
            }
            DeclarationDescriptor target2 = declarationDescriptor;
            CallableDescriptor callableDescriptor = target2 instanceof CallableDescriptor ? (CallableDescriptor)target2 : null;
            if (callableDescriptor == null) {
                return false;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor.getOriginal();
            PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor2));
            KtCallableDeclaration ktCallableDeclaration = declaration2 = psiElement2 instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement2 : null;
            if (declaration2 != null && declaration2.getTypeReference() == null) {
                return false;
            }
            KotlinType kotlinType = callableDescriptor2.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            KotlinType type2 = kotlinType;
            return this.isNothingOrNothingFunctionType(type2);
        }
        return this.hasExplicitNothing(callee2, bindingContext2);
    }

    private final boolean isNothingOrNothingFunctionType(KotlinType $this$isNothingOrNothingFunctionType) {
        return KotlinBuiltIns.isNothing((KotlinType)$this$isNothingOrNothingFunctionType) || FunctionTypesKt.isFunctionType((KotlinType)$this$isNothingOrNothingFunctionType) && this.isNothingOrNothingFunctionType(FunctionTypesKt.getReturnTypeFromFunctionType((KotlinType)$this$isNothingOrNothingFunctionType));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean $i$f$isApplicationInternalMode = false;
        e.getPresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Project project2 = project;
        return this.allKotlinFiles(virtualFiles, project2);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, KtFile>(manager){
            final /* synthetic */ PsiManager $manager;
            {
                this.$manager = $manager;
                super(1);
            }

            @Nullable
            public final KtFile invoke(@NotNull VirtualFile it) {
                PsiFile psiFile2 = this.$manager.findFile(it);
                return psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : filesOrDirs) {
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, optionArray){
                final /* synthetic */ ArrayList<VirtualFile> $result;
                {
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public boolean visitFile(@NotNull VirtualFile file2) {
                    this.$result.add(file2);
                    return true;
                }
            }));
        }
        return result2;
    }

    private static final void actionPerformed$lambda$0(FindImplicitNothingAction this$0, List $selectedFiles, Project $project) {
        this$0.find($selectedFiles, $project);
    }

    /*
     * WARNING - void declaration
     */
    private static final void find$lambda$2(ArrayList $found, Project $project, Collection $files) {
        if (!((Collection)$found).isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $found;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtCallExpression ktCallExpression = (KtCallExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)it)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            UsageInfo2UsageAdapter[] usages2 = thisCollection$iv.toArray(new UsageInfo2UsageAdapter[0]);
            UsageViewPresentation presentation = new UsageViewPresentation();
            presentation.setTabName(KotlinBundle.message("implicit.nothing.s", new Object[0]));
            UsageViewManager.getInstance((Project)$project).showUsages(new UsageTarget[0], (Usage[])usages2, presentation);
        } else {
            Object[] objectArray = new Object[]{$files.size()};
            Messages.showInfoMessage((Project)$project, (String)KotlinBundle.message("not.found.in.0.files", objectArray), (String)KotlinBundle.message("titile.not.found", new Object[0]));
        }
    }

    public static final /* synthetic */ boolean access$hasExplicitNothing(FindImplicitNothingAction $this, KtExpression $receiver, BindingContext bindingContext2) {
        return $this.hasExplicitNothing($receiver, bindingContext2);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/FindImplicitNothingAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

