/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "kotlin.idea"})
public final class DumbModeTrembleAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SETTING_REGISTRY_KEY = "action.dumb.tremble";
    @NotNull
    private static final String DEFAULT_SETTINGS_STRING = "800_2000_200_400";
    @NotNull
    private static final Companion.Settings DEFAULT_SETTINGS = org.jetbrains.kotlin.idea.actions.internal.DumbModeTrembleAction$Companion.access$parseSettings(Companion, "800_2000_200_400");
    @NotNull
    private static final Logger LOG = Logger.getInstance(DumbModeTrembleAction.class);
    @NotNull
    private static final Key<Boolean> DUMB_TREMBLE = Key.create((String)"DumbModeTrembleAction");

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (DumbModeTrembleAction.Companion.isTrembleDumb(project2)) {
            DumbModeTrembleAction.Companion.setTrembleDumb(project2, false);
        } else {
            DumbModeTrembleAction.Companion.setTrembleDumb(project2, true);
            DumbModeTrembleAction.Companion.dumbModeTremble(project2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isTrembleDumb = DumbModeTrembleAction.Companion.isTrembleDumb(project);
        e.getPresentation().setText(isTrembleDumb ? KotlinBundle.message("disable.tremble.dumb.mode", new Object[0]) : KotlinBundle.message("enable.tremble.dumb.mode", new Object[0]));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion;", "", "()V", "DEFAULT_SETTINGS", "Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion$Settings;", "DEFAULT_SETTINGS_STRING", "", "DUMB_TREMBLE", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SETTING_REGISTRY_KEY", "dumbModeTremble", "", "project", "Lcom/intellij/openapi/project/Project;", "isTrembleDumb", "parseSettings", "settingsString", "readSettings", "setTrembleDumb", "value", "Settings", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final void dumbModeTremble(Project project) {
            Settings settings2 = this.readSettings();
            ApplicationManager.getApplication().executeOnPooledThread(() -> Companion.dumbModeTremble$lambda$0(project, settings2));
        }

        /*
         * WARNING - void declaration
         */
        private final Settings parseSettings(String settingsString) {
            Iterable $this$map$iv;
            String[] stringArray = new String[]{"_"};
            List numberStrings = StringsKt.split$default((CharSequence)settingsString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (numberStrings.size() != 4) {
                LOG.error("Bad action.dumb.tremble value: `" + numberStrings + "`");
                return DEFAULT_SETTINGS;
            }
            try {
                void $this$mapTo$iv$iv;
                $this$map$iv = numberStrings;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Long.parseLong((String)it));
                }
                $this$map$iv = (List)destination$iv$iv;
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error("Can't parse longs in action.dumb.tremble value: `" + numberStrings + "`");
                return DEFAULT_SETTINGS;
            }
            Iterable numbers = $this$map$iv;
            long disableMinMillis = ((Number)numbers.get(0)).longValue();
            long disableMaxMillis = ((Number)numbers.get(1)).longValue();
            long enableMinMillis = ((Number)numbers.get(2)).longValue();
            long enableMaxMillis = ((Number)numbers.get(3)).longValue();
            boolean bl = 0L <= disableMinMillis ? disableMinMillis < disableMaxMillis : false;
            if (bl) {
                boolean bl2 = 0L <= enableMinMillis ? enableMinMillis < enableMaxMillis : false;
                if (bl2) {
                    return new Settings(disableMinMillis, disableMaxMillis, enableMinMillis, enableMaxMillis);
                }
            }
            return DEFAULT_SETTINGS;
        }

        private final Settings readSettings() {
            String string2;
            try {
                string2 = Registry.stringValue((String)DumbModeTrembleAction.SETTING_REGISTRY_KEY);
            }
            catch (MissingResourceException missingResourceException) {
                return DEFAULT_SETTINGS;
            }
            String settingsString = string2;
            return this.parseSettings(settingsString);
        }

        private final void setTrembleDumb(Project project, boolean value2) {
            project.putUserData(DUMB_TREMBLE, (Object)value2);
        }

        private final boolean isTrembleDumb(Project project) {
            return project.getUserData(DUMB_TREMBLE) == Boolean.TRUE;
        }

        private static final void dumbModeTremble$lambda$0(Project $project, Settings $settings) {
            LOG.info("Dumb Mode Tremble enabled");
            while (Companion.isTrembleDumb($project)) {
                TimeoutUtil.sleep((long)Random.Default.nextLong($settings.getDisableMinMillis(), $settings.getDisableMaxMillis()));
                DumbService.getInstance((Project)$project).queueTask(new DumbModeTask($settings){
                    final /* synthetic */ Settings $settings;
                    {
                        this.$settings = $settings;
                    }

                    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                        TimeoutUtil.sleep((long)Random.Default.nextLong(this.$settings.getEnableMinMillis(), this.$settings.getEnableMaxMillis()));
                        indicator.checkCanceled();
                    }
                });
            }
            LOG.info("Dumb Mode Tremble disabled");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Settings access$parseSettings(Companion $this, String settingsString) {
            return $this.parseSettings(settingsString);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/DumbModeTrembleAction$Companion$Settings;", "", "disableMinMillis", "", "disableMaxMillis", "enableMinMillis", "enableMaxMillis", "(JJJJ)V", "getDisableMaxMillis", "()J", "getDisableMinMillis", "getEnableMaxMillis", "getEnableMinMillis", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.idea"})
        private static final class Settings {
            private final long disableMinMillis;
            private final long disableMaxMillis;
            private final long enableMinMillis;
            private final long enableMaxMillis;

            public Settings(long disableMinMillis, long disableMaxMillis, long enableMinMillis, long enableMaxMillis) {
                this.disableMinMillis = disableMinMillis;
                this.disableMaxMillis = disableMaxMillis;
                this.enableMinMillis = enableMinMillis;
                this.enableMaxMillis = enableMaxMillis;
            }

            public final long getDisableMinMillis() {
                return this.disableMinMillis;
            }

            public final long getDisableMaxMillis() {
                return this.disableMaxMillis;
            }

            public final long getEnableMinMillis() {
                return this.enableMinMillis;
            }

            public final long getEnableMaxMillis() {
                return this.enableMaxMillis;
            }

            public final long component1() {
                return this.disableMinMillis;
            }

            public final long component2() {
                return this.disableMaxMillis;
            }

            public final long component3() {
                return this.enableMinMillis;
            }

            public final long component4() {
                return this.enableMaxMillis;
            }

            @NotNull
            public final Settings copy(long disableMinMillis, long disableMaxMillis, long enableMinMillis, long enableMaxMillis) {
                return new Settings(disableMinMillis, disableMaxMillis, enableMinMillis, enableMaxMillis);
            }

            public static /* synthetic */ Settings copy$default(Settings settings2, long l, long l2, long l3, long l4, int n, Object object) {
                if ((n & 1) != 0) {
                    l = settings2.disableMinMillis;
                }
                if ((n & 2) != 0) {
                    l2 = settings2.disableMaxMillis;
                }
                if ((n & 4) != 0) {
                    l3 = settings2.enableMinMillis;
                }
                if ((n & 8) != 0) {
                    l4 = settings2.enableMaxMillis;
                }
                return settings2.copy(l, l2, l3, l4);
            }

            @NotNull
            public String toString() {
                return "Settings(disableMinMillis=" + this.disableMinMillis + ", disableMaxMillis=" + this.disableMaxMillis + ", enableMinMillis=" + this.enableMinMillis + ", enableMaxMillis=" + this.enableMaxMillis + ")";
            }

            public int hashCode() {
                int result2 = Long.hashCode(this.disableMinMillis);
                result2 = result2 * 31 + Long.hashCode(this.disableMaxMillis);
                result2 = result2 * 31 + Long.hashCode(this.enableMinMillis);
                result2 = result2 * 31 + Long.hashCode(this.enableMaxMillis);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Settings)) {
                    return false;
                }
                Settings settings2 = (Settings)other;
                if (this.disableMinMillis != settings2.disableMinMillis) {
                    return false;
                }
                if (this.disableMaxMillis != settings2.disableMaxMillis) {
                    return false;
                }
                if (this.enableMinMillis != settings2.enableMinMillis) {
                    return false;
                }
                return this.enableMaxMillis == settings2.enableMaxMillis;
            }
        }
    }
}

