/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.base.codeInsight.JavaToKotlinConversionUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.configuration.ExperimentalFeatures;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.ExternalCodeProcessing;
import org.jetbrains.kotlin.j2k.FilesResult;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.OldJavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\u001c\u001a\u00020\u0016*\u00020\tH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allJavaFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isAnyJavaFileSelected", "", "files", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isEnabled", "selectedJavaFiles", "update", "isSuitableDirectory", "Companion", "kotlin.idea"})
public final class JavaToKotlinAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String title = KotlinBundle.message("action.j2k.name", new Object[0]);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        List javaFiles2 = SequencesKt.toList((Sequence)SequencesKt.filter(this.selectedJavaFiles(e), (Function1)actionPerformed.javaFiles.1.INSTANCE));
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        Project project2 = project;
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        if (javaFiles2.isEmpty()) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinBundle.message("action.j2k.errornothing.to.convert", new Object[0]), MessageType.ERROR, null).createBalloon().showInCenterOf(statusBar.getComponent());
        }
        if (!J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).doCheckBeforeConversion(project2, module3)) {
            return;
        }
        PsiErrorElement firstSyntaxError2 = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles2), (Function1)actionPerformed.firstSyntaxError.1.INSTANCE));
        if (firstSyntaxError2 != null) {
            String string2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = javaFiles2;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Object[] destination$iv$iv = (Object[])new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int count = ((Collection)((List)destination$iv$iv)).size();
            boolean bl = $this$filter$iv = count > 0;
            if (_Assertions.ENABLED && !$this$filter$iv) {
                String $i$f$filter2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$filter2);
            }
            String firstFileName = firstSyntaxError2.getContainingFile().getName();
            if (count == 1) {
                destination$iv$iv = new Object[]{firstFileName};
                string2 = KotlinBundle.message("action.j2k.correction.errors.single", destination$iv$iv);
            } else {
                destination$iv$iv = new Object[]{firstFileName, count - 1};
                string2 = KotlinBundle.message("action.j2k.correction.errors.multiple", destination$iv$iv);
            }
            String question = string2;
            String okText = KotlinBundle.message("action.j2k.correction.investigate", new Object[0]);
            String cancelText = KotlinBundle.message("action.j2k.correction.proceed", new Object[0]);
            if (Messages.showOkCancelDialog((Project)project2, (String)question, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)firstSyntaxError2.getNavigationElement());
                return;
            }
        }
        org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.convertFiles$default(Companion, javaFiles2, project2, module3, false, false, false, 56, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.isEnabled(e));
    }

    private final boolean isEnabled(AnActionEvent e) {
        if (KotlinPlatformUtils.isCidr()) {
            return false;
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return false;
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if ((Module)e.getData(PlatformCoreDataKeys.MODULE) == null) {
            return false;
        }
        return this.isAnyJavaFileSelected(project2, virtualFiles);
    }

    private final boolean isAnyJavaFileSelected(Project project, VirtualFile[] files2) {
        boolean bl;
        block4: {
            boolean bl2;
            int n;
            block3: {
                VirtualFile[] $this$any$iv = files2;
                boolean $i$f$any = false;
                n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile element$iv;
                    VirtualFile it = element$iv = $this$any$iv[j];
                    boolean bl3 = false;
                    if (!this.isSuitableDirectory(it)) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            VirtualFile[] $this$any$iv = files2;
            boolean $i$f$any = false;
            int n2 = $this$any$iv.length;
            for (n = 0; n < n2; ++n) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = $this$any$iv[n];
                boolean bl4 = false;
                if (!(Intrinsics.areEqual((Object)it.getExtension(), (Object)"java") && manager.findFile(it) instanceof PsiJavaFile && it.isWritable())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSuitableDirectory(VirtualFile $this$isSuitableDirectory) {
        return $this$isSuitableDirectory.isDirectory() && !($this$isSuitableDirectory.getFileType() instanceof ArchiveFileType) && $this$isSuitableDirectory.isWritable();
    }

    private final Sequence<PsiJavaFile> selectedJavaFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Project project2 = project;
        return this.allJavaFiles(virtualFiles, project2);
    }

    private final Sequence<PsiJavaFile> allJavaFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
            final /* synthetic */ PsiManager $manager;
            {
                this.$manager = $manager;
                super(1);
            }

            @Nullable
            public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                PsiFile psiFile2 = this.$manager.findFile(it);
                return psiFile2 instanceof PsiJavaFile ? (PsiJavaFile)psiFile2 : null;
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : filesOrDirs) {
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, optionArray){
                final /* synthetic */ ArrayList<VirtualFile> $result;
                {
                    this.$result = $result;
                    super($super_call_param$1);
                }

                public boolean visitFile(@NotNull VirtualFile file2) {
                    this.$result.add(file2);
                    return true;
                }
            }));
        }
        return result2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011JR\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0015J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0017H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Companion;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "enableExternalCodeProcessing", "", "askExternalCodeProcessing", "forceUsingOldJ2k", "settings", "Lorg/jetbrains/kotlin/j2k/ConverterSettings;", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "javaFiles", "convertedTexts", "uniqueKotlinFileName", "javaFile", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        private final String uniqueKotlinFileName(VirtualFile javaFile) {
            Path nioFile = javaFile.getFileSystem().getNioPath(javaFile);
            int i2 = 0;
            while (true) {
                block4: {
                    String fileName;
                    block3: {
                        fileName = javaFile.getNameWithoutExtension() + (i2 > 0 ? Integer.valueOf(i2) : "") + ".kt";
                        if (nioFile == null) break block3;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.notExists(nioFile.resolveSibling(fileName), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block4;
                    }
                    return fileName;
                }
                ++i2;
            }
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles2, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair : CollectionsKt.zip((Iterable)javaFiles2, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile2 = (PsiJavaFile)pair.component1();
                String text2 = (String)pair.component2();
                try {
                    String errorMessage;
                    Document document = PsiDocumentManager.getInstance((Project)psiFile2.getProject()).getDocument((PsiFile)psiFile2);
                    if (document == null) {
                        var10_11 = new Object[]{psiFile2.getName()};
                        v0 = KotlinBundle.message("action.j2k.error.cant.find.document", var10_11);
                    } else if (!document.isWritable()) {
                        var10_11 = new Object[]{psiFile2.getName()};
                        v0 = KotlinBundle.message("action.j2k.error.read.only", var10_11);
                    } else {
                        v0 = errorMessage = null;
                    }
                    if (errorMessage != null) {
                        Object[] objectArray = new Object[]{errorMessage};
                        String message2 = KotlinBundle.message("action.j2k.error.cant.save.result", objectArray);
                        MessagesEx.error((Project)psiFile2.getProject(), (String)message2).showLater();
                        continue;
                    }
                    Document document2 = document;
                    Intrinsics.checkNotNull((Object)document2);
                    document2.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile = psiFile2.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile)) {
                        PerFileMappings mapping2 = ScratchFileService.getInstance().getScratchesMapping();
                        mapping2.setMapping(virtualFile, (Object)KotlinFileType.INSTANCE.getLanguage());
                    } else {
                        String fileName = this.uniqueKotlinFileName(virtualFile);
                        JavaToKotlinConversionUtils.setPathBeforeJavaToKotlinConversion(virtualFile, virtualFile.getPath());
                        virtualFile.rename((Object)this, fileName);
                    }
                    ((Collection)result2).add(virtualFile);
                }
                catch (IOException e) {
                    Project project = psiFile2.getProject();
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    MessagesEx.error((Project)project, (String)string2).showLater();
                }
            }
            return result2;
        }

        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k) {
            return this.convertFiles(files2, project, module2, enableExternalCodeProcessing, askExternalCodeProcessing, forceUsingOldJ2k, ConverterSettings.Companion.getDefaultSettings());
        }

        public static /* synthetic */ List convertFiles$default(Companion companion, List list2, Project project, Module module2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            return companion.convertFiles(list2, project, module2, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> files2, @NotNull Project project, @NotNull Module module2, boolean enableExternalCodeProcessing, boolean askExternalCodeProcessing, boolean forceUsingOldJ2k, @NotNull ConverterSettings settings2) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = files2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                boolean bl = false;
                if (!it.getVirtualFile().isWritable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            if ($this$filter$iv.isEmpty()) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            List javaFiles2 = (List)$this$filter$iv;
            Ref.ObjectRef converterResult = new Ref.ObjectRef();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.convertFiles$convertWithStatistics(javaFiles2, forceUsingOldJ2k, project, settings2, module2, converterResult), this.getTitle(), true, project)) {
                return CollectionsKt.emptyList();
            }
            Ref.ObjectRef externalCodeUpdate = new Ref.ObjectRef();
            FilesResult filesResult = (FilesResult)converterResult.element;
            if (filesResult == null) {
                return CollectionsKt.emptyList();
            }
            FilesResult result2 = filesResult;
            ExternalCodeProcessing externalCodeProcessing2 = result2.getExternalCodeProcessing();
            if (enableExternalCodeProcessing && externalCodeProcessing2 != null) {
                String question = KotlinBundle.message("action.j2k.correction.required", new Object[0]);
                if (!askExternalCodeProcessing || Messages.showYesNoDialog((Project)project, (String)question, (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.convertFiles$lambda$6(externalCodeUpdate, externalCodeProcessing2), this.getTitle(), true, project);
                }
            }
            return (List)ApplicationUtilsKt.executeWriteCommand(project, KotlinBundle.message("action.j2k.task.name", new Object[0]), null, (Function0)new Function0<List<? extends KtFile>>(project, (List<? extends PsiJavaFile>)javaFiles2, result2, (Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>>)externalCodeUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ List<PsiJavaFile> $javaFiles;
                final /* synthetic */ FilesResult $result;
                final /* synthetic */ Ref.ObjectRef<Function1<List<? extends KtFile>, Unit>> $externalCodeUpdate;
                {
                    this.$project = $project;
                    this.$javaFiles = $javaFiles;
                    this.$result = $result;
                    this.$externalCodeUpdate = $externalCodeUpdate;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<KtFile> invoke() {
                    List newFiles;
                    block3: {
                        Iterable iterable;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                        Iterable iterable2 = org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.access$saveResults(JavaToKotlinAction.Companion, this.$javaFiles, this.$result.getResults());
                        Project project = this.$project;
                        boolean $i$f$map = false;
                        void var5_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, project);
                            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                            collection.add((KtFile)psiFile2);
                        }
                        Iterable $this$onEach$iv = (List)destination$iv$iv;
                        boolean $i$f$onEach = false;
                        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
                        boolean bl = false;
                        for (T element$iv : $this$onEach_u24lambda_u2416$iv) {
                            KtFile it = (KtFile)element$iv;
                            boolean bl2 = false;
                            UtilsKt.commitAndUnblockDocument((PsiFile)it);
                        }
                        newFiles = (List)iterable;
                        Function1 function1 = (Function1)this.$externalCodeUpdate.element;
                        if (function1 != null) {
                            function1.invoke((Object)newFiles);
                        }
                        PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                        KtFile ktFile = (KtFile)CollectionsKt.singleOrNull((List)newFiles);
                        if (ktFile == null) break block3;
                        KtFile ktFile2 = ktFile;
                        iterable = this.$project;
                        KtFile it = ktFile2;
                        boolean bl3 = false;
                        FileEditorManager.getInstance((Project)iterable).openFile(it.getVirtualFile(), true);
                    }
                    return newFiles;
                }
            });
        }

        public static /* synthetic */ List convertFiles$default(Companion companion, List list2, Project project, Module module2, boolean bl, boolean bl2, boolean bl3, ConverterSettings converterSettings, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                converterSettings = ConverterSettings.Companion.getDefaultSettings();
            }
            return companion.convertFiles(list2, project, module2, bl, bl2, bl3, converterSettings);
        }

        private static final void convertFiles$convert(boolean $forceUsingOldJ2k, Project $project, ConverterSettings $settings, Module $module, Ref.ObjectRef<FilesResult> converterResult, List<? extends PsiJavaFile> javaFiles2) {
            JavaToKotlinConverter converter = $forceUsingOldJ2k ? (JavaToKotlinConverter)new OldJavaToKotlinConverter($project, $settings, IdeaJavaToKotlinServices.INSTANCE) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createJavaToKotlinConverter($project, $module, $settings, IdeaJavaToKotlinServices.INSTANCE);
            PostProcessor postProcessor2 = $forceUsingOldJ2k ? (PostProcessor)new J2kPostProcessor(true) : J2kConverterExtension.Companion.extension(ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled()).createPostProcessor(true);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)progressIndicator);
            converterResult.element = converter.filesToKotlin(javaFiles2, postProcessor2, progressIndicator);
        }

        private static final void convertFiles$convertWithStatistics(List<? extends PsiJavaFile> javaFiles2, boolean $forceUsingOldJ2k, Project $project, ConverterSettings $settings, Module $module, Ref.ObjectRef<FilesResult> converterResult) {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.convertFiles$convert($forceUsingOldJ2k, $project, $settings, $module, converterResult, javaFiles2);
            long conversionTime = System.currentTimeMillis() - start$iv;
            boolean $i$f$runReadAction = false;
            int linesCount = ((Number)ApplicationManager.getApplication().runReadAction(new Computable(javaFiles2){
                final /* synthetic */ List $javaFiles$inlined;
                {
                    this.$javaFiles$inlined = list2;
                }

                /*
                 * WARNING - void declaration
                 */
                public final T compute() {
                    boolean bl = false;
                    Iterable iterable = this.$javaFiles$inlined;
                    int n = 0;
                    for (T t : iterable) {
                        void it;
                        PsiJavaFile psiJavaFile = (PsiJavaFile)t;
                        int n2 = n;
                        boolean bl2 = false;
                        int n3 = StringUtil.getLineBreakCount((CharSequence)it.getText());
                        n = n2 + n3;
                    }
                    return (T)Integer.valueOf(n);
                }
            })).intValue();
            J2KFusCollector.Companion.log(ConversionType.FILES, ExperimentalFeatures.INSTANCE.getNewJ2k().isEnabled(), conversionTime, linesCount, javaFiles2.size());
        }

        private static final void convertFiles$lambda$6(Ref.ObjectRef $externalCodeUpdate, ExternalCodeProcessing $externalCodeProcessing) {
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable($externalCodeUpdate, $externalCodeProcessing){
                final /* synthetic */ Ref.ObjectRef $externalCodeUpdate$inlined;
                final /* synthetic */ ExternalCodeProcessing $externalCodeProcessing$inlined;
                {
                    this.$externalCodeUpdate$inlined = objectRef;
                    this.$externalCodeProcessing$inlined = externalCodeProcessing2;
                }

                public final T compute() {
                    boolean bl = false;
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNull((Object)progressIndicator);
                    this.$externalCodeUpdate$inlined.element = this.$externalCodeProcessing$inlined.prepareWriteOperation(progressIndicator);
                    return (T)Unit.INSTANCE;
                }
            });
        }

        public static final /* synthetic */ List access$saveResults(Companion $this, List javaFiles2, List convertedTexts) {
            return $this.saveResults(javaFiles2, convertedTexts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

